/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.CFileChooser;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.HyperlinkUtil;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jutil.PathUtil;
import net.astah.jomt.jutil.StringConverter;
import net.astah.jomt.jview.EditableTextComponentMouseAdapther;
import net.astah.jomt.jview.KeyDialog;

public class AddFileDialog
extends KeyDialog
implements ActionListener {
    private static final long serialVersionUID = -1291956864619469640L;
    private JTextField filePathText;
    private JButton fileChooserButton;
    private JRadioButton relativeRadio;
    private JRadioButton absoluteRadio;
    private static boolean a = true;
    private File file;
    private String filePath;

    public AddFileDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.a(jFrame);
    }

    private void a(JFrame jFrame) {
        JPanel jPanel = this.a();
        JPanel jPanel2 = this.c();
        Container container = this.getContentPane();
        container.add((Component)jPanel, "North");
        container.add((Component)jPanel2, "South");
        this.setTitle(AddFileDialog.getTitle("ui.add_file_dialog.title"));
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    private JPanel a() {
        JLabel jLabel = new JLabel(AddFileDialog.getTitle("ui.add_file_dialog.text.file_location.label"));
        JLabel jLabel2 = new JLabel(AddFileDialog.getTitle("ui.add_file_dialog.text.path_type.label"));
        JPanel jPanel = new JPanel(new GridLayout(2, 0));
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        this.filePathText = new JTextField(40);
        this.filePathText.addMouseListener(new EditableTextComponentMouseAdapther());
        this.filePathText.setActionCommand("OK");
        this.filePathText.addActionListener(this);
        this.fileChooserButton = new JButton(PathUtil.getIcon("open.png"));
        this.fileChooserButton.setMargin(new Insets(0, 0, 0, 0));
        this.fileChooserButton.setActionCommand("SHOW");
        this.fileChooserButton.addActionListener(this);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.filePathText, "Center");
        jPanel2.add((Component)this.fileChooserButton, "East");
        this.absoluteRadio = new JRadioButton(AddFileDialog.getTitle("ui.add_file_dialog.button.absolute.label"), a);
        this.absoluteRadio.setActionCommand("Absolute");
        this.absoluteRadio.addActionListener(this);
        this.relativeRadio = new JRadioButton(AddFileDialog.getTitle("ui.add_file_dialog.button.relative.label"), !a);
        this.relativeRadio.setActionCommand("Relative");
        this.relativeRadio.addActionListener(this);
        if (this.b()) {
            this.relativeRadio.setEnabled(false);
            a = true;
            this.absoluteRadio.setSelected(a);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.absoluteRadio);
        buttonGroup.add(this.relativeRadio);
        JPanel jPanel3 = new JPanel(new GridLayout(0, 2));
        jPanel3.add(this.absoluteRadio);
        jPanel3.add(this.relativeRadio);
        JPanel jPanel4 = new JPanel(new GridLayout(2, 0));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel, "West");
        jPanel5.add((Component)jPanel4, "Center");
        String string = HyperlinkUtil.getDetailedCurrentRelativeDir();
        string = StringConverter.convertForAllOsString(string);
        JLabel jLabel3 = new JLabel(string);
        CompoundBorder compoundBorder = new CompoundBorder(new LineBorder(Color.black), null);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(compoundBorder, AddFileDialog.getTitle("ui.add_file_dialog.text.current_based_directory.label"));
        jLabel3.setBorder(titledBorder);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jPanel5, "Center");
        jPanel6.add((Component)jLabel3, "South");
        return jPanel6;
    }

    private boolean b() {
        if (RuntimeGlobal.sysProp.getStringWithDefault("hyperlink.relative_path_type.selected").equals("0")) {
            Project project = ModelGlobal.prjManager.getCurrentProject();
            if ("no_title".equals(project.doc.getName())) {
                return true;
            }
        }
        return false;
    }

    private JPanel c() {
        JButton jButton = new JButton(AddFileDialog.getTitle("projectview.button.ok.label"));
        jButton.setActionCommand("OK");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(AddFileDialog.getTitle("projectview.button.cancel.label"));
        jButton2.setActionCommand("CANCEL");
        jButton2.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        if (PropertyManager.isMacOS()) {
            jPanel.add(jButton2);
            jPanel.add(jButton);
        } else {
            jPanel.add(jButton);
            jPanel.add(jButton2);
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JSeparator(), "North");
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("OK".equals(actionEvent.getActionCommand())) {
            this.d();
        } else if ("CANCEL".equals(actionEvent.getActionCommand())) {
            this.dispose();
        } else if ("SHOW".equals(actionEvent.getActionCommand())) {
            Object object;
            if (PropertyManager.isMacOS()) {
                object = (Frame)((SwingComponent)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
                FileDialog fileDialog = new FileDialog((Frame)object);
                fileDialog.setMode(0);
                fileDialog.setDirectory(JomtGlobal.getFileDir());
                fileDialog.show();
                if (fileDialog.getFile() == null) {
                    return;
                }
                String string = fileDialog.getDirectory();
                fileDialog.setDirectory(GolfUtilities.normalizeToNFC(string));
                String string2 = fileDialog.getFile();
                fileDialog.setFile(GolfUtilities.normalizeToNFC(string2));
                this.file = new File(fileDialog.getDirectory() + fileDialog.getFile());
            } else {
                object = this.f();
                if (!object.isApproveOpenDialog()) {
                    return;
                }
                this.file = object.getSelectedFile();
            }
            object = this.file.getAbsolutePath();
            if (this.relativeRadio.isSelected()) {
                object = HyperlinkUtil.convertAbsoluteToRelative((String)object);
            }
            this.filePathText.setText((String)object);
        } else if ("Absolute".equals(actionEvent.getActionCommand())) {
            a = true;
            if (!this.e().equals("") && !HyperlinkUtil.isAbsoluteFilePath(this.e())) {
                this.filePathText.setText(HyperlinkUtil.convertRelativeToAbsolute(this.e()));
            }
        } else if ("Relative".equals(actionEvent.getActionCommand())) {
            a = false;
            if (!this.e().equals("") && HyperlinkUtil.isAbsoluteFilePath(this.e())) {
                this.filePathText.setText(HyperlinkUtil.convertAbsoluteToRelative(this.e()));
            }
        }
    }

    private void d() {
        this.filePath = this.filePathText.getText().trim();
        this.filePath = StringConverter.convertForAllOsString(this.filePath);
        this.dispose();
    }

    private String e() {
        return this.filePathText.getText();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String string) {
        this.filePathText.setText(string);
    }

    public void selectRelativeRadio() {
        if (this.relativeRadio.isEnabled()) {
            this.relativeRadio.setSelected(true);
        }
    }

    private CFileChooser f() {
        String string = HyperlinkUtil.getCurrentRelativeDir();
        CFileChooser cFileChooser = JomtWidgetFactory.instance().createFileChooser(string, "Open Dialog");
        return cFileChooser;
    }

    protected static String getTitle(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.d();
        } else if (keyEvent.getKeyCode() == 27) {
            this.dispose();
        }
    }
}

