/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jutil;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import lombok.NonNull;
import net.astah.golf.control.Mode;
import net.astah.golf.draw.GCamera;
import net.astah.golf.draw.GNode;
import net.astah.golf.geom2D.Line2d;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.model.IExObserver;
import net.astah.golf.widget.CCanvas;
import net.astah.jmodel.ConnectorPresentation;
import net.astah.jmodel.FramePresentation;
import net.astah.jmodel.InteractionUsePresentation;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.LifelinePresentation;
import net.astah.jmodel.MMTopicPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.SequenceMessageEndPresentation;
import net.astah.jmodel.UMLCommunicationDiagram;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jcontrol.mode.CreateRelationMode;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.DrawSuggest;
import net.astah.jomt.jview.JomtCanvasUIView;
import net.astah.jomt.jviewElement.ActivityPartitionViewElement;
import net.astah.jomt.jviewElement.DiagramViewElement;
import net.astah.jomt.jviewElement.FrameViewElement;
import net.astah.jomt.jviewElement.JomtViewElement;
import net.astah.notation.editor.IViewElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import proguard.annotation.Keep;
import proguard.annotation.KeepPublicProtectedClassMembers;

@Keep
@KeepPublicProtectedClassMembers
public class IconButtonUtil {
    private static final Logger a = LoggerFactory.getLogger(IconButtonUtil.class);
    private static IExObserver b;
    private static boolean c;
    private static MessageDirection d;

    public static void setupCreateRelationMode(MouseEvent mouseEvent, GNode gNode) {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        JomtCanvasUIView jomtCanvasUIView = diagramEditor.getCanvasUIView();
        GCamera gCamera = diagramEditor.getCamera();
        if (gNode instanceof JomtViewElement) {
            IconButtonUtil.a(jomtCanvasUIView);
            JomtViewElement jomtViewElement = (JomtViewElement)gNode;
            jomtViewElement.removeAllIconButton();
            IconButtonUtil.a(diagramEditor);
            Object object = jomtViewElement.getModel();
            Pnt2d pnt2d = null;
            if (object instanceof UserObject) {
                Serializable serializable;
                UserObject userObject = (UserObject)object;
                Presentation presentation = userObject.getPresentation();
                if (presentation instanceof ConnectorPresentation && presentation.getDiagram() instanceof UMLCommunicationDiagram) {
                    IconButtonUtil.a(mouseEvent, IconButtonUtil.a(mouseEvent.getPoint(), (ConnectorPresentation)presentation));
                    return;
                }
                if (presentation instanceof LifelinePresentation) {
                    serializable = (LifelinePresentation)presentation;
                    pnt2d = new Pnt2d();
                    pnt2d.x = gCamera.toDeviceCoordX(serializable.getLifelineLocX());
                    pnt2d.y = mouseEvent.getY();
                } else if (presentation instanceof SequenceMessageEndPresentation || presentation instanceof InteractionUsePresentation) {
                    serializable = (RectPresentation)presentation;
                    pnt2d = new Pnt2d();
                    pnt2d.x = gCamera.toDeviceCoordX(serializable.getCenterX());
                    pnt2d.y = mouseEvent.getY();
                } else if (presentation instanceof FramePresentation) {
                    serializable = (RectPresentation)presentation;
                    double d2 = gCamera.toDeviceCoordX(serializable.getMinX());
                    double d3 = gCamera.toDeviceCoordX(serializable.getMaxX());
                    pnt2d = new Pnt2d();
                    pnt2d.x = Math.abs(d2 - (double)mouseEvent.getX()) < Math.abs(d3 - (double)mouseEvent.getX()) ? d2 : d3;
                    pnt2d.y = mouseEvent.getY();
                } else if (presentation instanceof RectPresentation && !(presentation instanceof MMTopicPresentation)) {
                    serializable = (RectPresentation)presentation;
                    Rectangle2d rectangle2d = IconButtonUtil.a(serializable, 0.0);
                    pnt2d = IconButtonUtil.a(gCamera, rectangle2d);
                } else {
                    return;
                }
                serializable = IconButtonUtil.b(mouseEvent, pnt2d);
                b = presentation;
                jomtCanvasUIView.mouseMoved((MouseEvent)serializable);
                MouseEvent mouseEvent2 = IconButtonUtil.b(mouseEvent, pnt2d);
                jomtCanvasUIView.mousePressed(mouseEvent2);
                jomtCanvasUIView.mouseReleased(mouseEvent2);
                b = null;
            }
        }
    }

    public static void setupCreateRelationMode(MouseEvent mouseEvent, DrawSuggest drawSuggest) {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        JomtCanvasUIView jomtCanvasUIView = diagramEditor.getCanvasUIView();
        GCamera gCamera = diagramEditor.getCamera();
        IconButtonUtil.a(jomtCanvasUIView);
        IconButtonUtil.a(diagramEditor);
        Pnt2d pnt2d = drawSuggest.createModeArgumentPoint(new Pnt2d(mouseEvent.getX(), mouseEvent.getY()));
        double d2 = gCamera.toDeviceCoordX(pnt2d.getX());
        double d3 = gCamera.toDeviceCoordY(pnt2d.getY());
        Pnt2d pnt2d2 = new Pnt2d(d2, d3);
        b = drawSuggest.getOwner();
        MouseEvent mouseEvent2 = IconButtonUtil.b(mouseEvent, pnt2d2);
        jomtCanvasUIView.mouseMoved(mouseEvent2);
        MouseEvent mouseEvent3 = IconButtonUtil.b(mouseEvent, pnt2d2);
        jomtCanvasUIView.mousePressed(mouseEvent3);
        jomtCanvasUIView.mouseReleased(mouseEvent3);
        b = null;
    }

    private static void a(MouseEvent mouseEvent, Pnt2d pnt2d) {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        JomtCanvasUIView jomtCanvasUIView = diagramEditor.getCanvasUIView();
        MouseEvent mouseEvent2 = IconButtonUtil.b(mouseEvent, pnt2d);
        jomtCanvasUIView.mouseReleased(mouseEvent2);
        MouseEvent mouseEvent3 = IconButtonUtil.b(mouseEvent, pnt2d);
        jomtCanvasUIView.mouseReleased(mouseEvent3);
        KeyEvent keyEvent = new KeyEvent(mouseEvent.getComponent(), 402, mouseEvent.getWhen(), 0, 27, '\uffff');
        jomtCanvasUIView.keyReleased(keyEvent);
        d = MessageDirection.INVALID;
    }

    private static Pnt2d a(Point point, ConnectorPresentation connectorPresentation) {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        GCamera gCamera = diagramEditor.getCamera();
        Pnt2d[] pnt2dArray = connectorPresentation.getOuterPoints().toArray(new Pnt2d[0]);
        Pnt2d pnt2d = new Pnt2d();
        double d2 = -1.0;
        for (int i2 = 0; i2 < pnt2dArray.length - 1; ++i2) {
            double d3;
            Pnt2d pnt2d2 = new Pnt2d(gCamera.toDeviceCoordX(pnt2dArray[i2].x), gCamera.toDeviceCoordY(pnt2dArray[i2].y));
            Pnt2d pnt2d3 = new Pnt2d(gCamera.toDeviceCoordX(pnt2dArray[i2 + 1].x), gCamera.toDeviceCoordY(pnt2dArray[i2 + 1].y));
            Line2d line2d = new Line2d(pnt2d2, pnt2d3);
            if (d2 != -1.0 && !(d2 > line2d.ptLineDist(point))) continue;
            d2 = line2d.ptLineDist(point);
            if (pnt2d2.x == pnt2d3.x) {
                pnt2d.x = pnt2d2.x;
                pnt2d.y = point.y;
                d = (double)point.x > pnt2d.x ? (pnt2d3.y > pnt2d2.y ? MessageDirection.RIGHT : MessageDirection.LEFT) : (pnt2d3.y > pnt2d2.y ? MessageDirection.LEFT : MessageDirection.RIGHT);
                continue;
            }
            if (pnt2d2.y == pnt2d3.y) {
                pnt2d.x = point.x;
                pnt2d.y = pnt2d2.y;
                d = (double)point.y < pnt2d.y ? (pnt2d3.x > pnt2d2.x ? MessageDirection.RIGHT : MessageDirection.LEFT) : (pnt2d3.x > pnt2d2.x ? MessageDirection.LEFT : MessageDirection.RIGHT);
                continue;
            }
            double d4 = (pnt2d3.y - pnt2d2.y) / (pnt2d3.x - pnt2d2.x);
            if (Math.abs(d4) <= 1.0) {
                pnt2d.x = point.x;
                d3 = pnt2d2.y - d4 * pnt2d2.x;
                pnt2d.y = d4 * (double)point.x + d3;
                if (pnt2d3.x > pnt2d2.x) {
                    d = pnt2d.y > (double)point.y ? MessageDirection.RIGHT : MessageDirection.LEFT;
                    continue;
                }
                d = pnt2d.y > (double)point.y ? MessageDirection.LEFT : MessageDirection.RIGHT;
                continue;
            }
            d4 = (pnt2d3.x - pnt2d2.x) / (pnt2d3.y - pnt2d2.y);
            d3 = pnt2d2.x - d4 * pnt2d2.y;
            pnt2d.x = d4 * (double)point.y + d3;
            pnt2d.y = point.y;
            d = pnt2d3.y > pnt2d2.y ? (pnt2d.x < (double)point.x ? MessageDirection.RIGHT : MessageDirection.LEFT) : (pnt2d.x < (double)point.x ? MessageDirection.LEFT : MessageDirection.RIGHT);
        }
        return pnt2d;
    }

    private static void a(DiagramEditor diagramEditor) {
        CCanvas cCanvas = diagramEditor.getCanvas();
        cCanvas.clear();
        cCanvas.draw();
        cCanvas.repaint();
    }

    private static void a(JomtCanvasUIView jomtCanvasUIView) {
        List<Mode> list = jomtCanvasUIView.getModeStack();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Mode mode = list.get(i2);
            if (!(mode instanceof CreateRelationMode)) continue;
            CreateRelationMode createRelationMode = (CreateRelationMode)mode;
            createRelationMode.setOneTry(true);
        }
    }

    private static Rectangle2d a(RectPresentation rectPresentation, double d2) {
        Rectangle2d rectangle2d = rectPresentation.getRect();
        double d3 = rectangle2d.getX();
        double d4 = rectangle2d.getY();
        double d5 = rectangle2d.getWidth();
        double d6 = rectangle2d.getHeight();
        return new Rectangle2d(d3 - d2, d4 - d2, d5 + d2 * 2.0, d6 + d2 * 2.0);
    }

    private static Pnt2d a(GCamera gCamera, Rectangle2d rectangle2d) {
        double d2 = gCamera.toDeviceCoordX(rectangle2d.getCenterX());
        double d3 = gCamera.toDeviceCoordY(rectangle2d.getCenterY());
        return new Pnt2d(d2, d3);
    }

    private static MouseEvent b(MouseEvent mouseEvent, Pnt2d pnt2d) {
        return new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), (int)pnt2d.x, (int)pnt2d.y, 1, false);
    }

    public static void setupMoveParentMode(MouseEvent mouseEvent) {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        JomtCanvasUIView jomtCanvasUIView = diagramEditor.getCanvasUIView();
        jomtCanvasUIView.mousePressed(mouseEvent);
    }

    public static JomtPresentation getStartPickedPs() {
        return IconButtonUtil.getStartPickedObject(JomtPresentation.class);
    }

    public static <T> T getStartPickedObject(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("type");
        }
        if (clazz.isInstance(b)) {
            return clazz.cast(b);
        }
        if (b != null) {
            a.warn("startPickedObject({}) is not instance of {}", (Object)b.getClass().getSimpleName(), (Object)clazz.getSimpleName());
        }
        return null;
    }

    public static MessageDirection getMessageDirection() {
        return d;
    }

    public static List<GNode> getAllViewElement(List<GNode> list) {
        ArrayList<GNode> arrayList = new ArrayList<GNode>();
        HashSet<GNode> hashSet = new HashSet<GNode>();
        for (GNode gNode : list) {
            GNode gNode2 = gNode.getParent();
            if (!(gNode2 instanceof JomtViewElement) && !(gNode2 instanceof IViewElement) || hashSet.contains(gNode2)) continue;
            if (gNode instanceof FrameViewElement) {
                FrameViewElement frameViewElement = (FrameViewElement)gNode;
                if (!frameViewElement.isOnSequenceDiagram()) continue;
                arrayList.add(frameViewElement);
                hashSet.add(frameViewElement);
                continue;
            }
            if (gNode2 instanceof DiagramViewElement || gNode2 instanceof FrameViewElement || gNode2 instanceof ActivityPartitionViewElement) continue;
            arrayList.add(gNode2);
            hashSet.add(gNode2);
        }
        return arrayList;
    }

    public static boolean hasModeStack(DiagramEditor diagramEditor) {
        JomtCanvasUIView jomtCanvasUIView = diagramEditor.getCanvasUIView();
        return !jomtCanvasUIView.getModeStack().isEmpty();
    }

    public static boolean isMoveFeatureMode() {
        return c;
    }

    public static void setMoveFeatureMode(boolean bl) {
        c = bl;
    }

    static {
        d = MessageDirection.INVALID;
    }

    public static enum MessageDirection {
        INVALID,
        RIGHT,
        LEFT;

    }
}

