/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jutil;

import java.util.Iterator;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.model.operations.DiagramOperations;
import net.astah.uml.mindmap.MMUserIconManager;
import net.astah.uml.profile.StereotypeDefinition;
import net.astah.uml.profile.UMLProfileManager;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityStoreUtil {
    private static final Logger a = LoggerFactory.getLogger(EntityStoreUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNewFrameIfNeed(IEntityStore iEntityStore) {
        iEntityStore.enableTransaction(false);
        try {
            try {
                iEntityStore.beginTransaction();
                Object[] objectArray = iEntityStore.getAllEntities().toArray();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    Object object = objectArray[i2];
                    if (!(object instanceof UMLDiagram)) continue;
                    DiagramOperations.addNewFrameIfNeed((UMLDiagram)object);
                }
                iEntityStore.commitTransaction();
                iEntityStore.setModified(false);
            }
            catch (Exception exception) {
                MessageManager.requireBugReport(exception);
            }
            finally {
                if (iEntityStore.isInTransaction()) {
                    iEntityStore.abortTransaction();
                }
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
        iEntityStore.enableTransaction(true);
        iEntityStore.setModified(false);
    }

    public static void ensureDefaultMMUserIcon(IJomtEntityStore iJomtEntityStore) {
        iJomtEntityStore.enableTransaction(false);
        try {
            iJomtEntityStore.beginTransaction();
            MMUserIconManager.instance().initializeMMUserIconInfo(iJomtEntityStore);
            iJomtEntityStore.commitTransaction();
        }
        catch (BadTransactionException badTransactionException) {
            a.error("error has occurred", badTransactionException);
        }
        iJomtEntityStore.enableTransaction(true);
    }

    public static void ensureDefaultUMLProfile(IJomtEntityStore iJomtEntityStore) {
        iJomtEntityStore.enableTransaction(false);
        try {
            iJomtEntityStore.beginTransaction();
            JomtGlobal.umlProfileManager.ensureDefaultUMLProfile(iJomtEntityStore);
            EntityStoreUtil.addObsever(iJomtEntityStore);
            iJomtEntityStore.commitTransaction();
        }
        catch (BadTransactionException badTransactionException) {
            a.error("error has occurred", badTransactionException);
        }
        iJomtEntityStore.enableTransaction(true);
    }

    public static void addObsever(IEntityStore iEntityStore) {
        Iterator<EObject> iterator = iEntityStore.entityIterator();
        while (iterator.hasNext()) {
            EObject eObject = iterator.next();
            if (!(eObject instanceof JomtPresentation)) continue;
            JomtPresentation jomtPresentation = (JomtPresentation)eObject;
            StereotypeDefinition stereotypeDefinition = UMLProfileManager.instance().getStereotypeDefinition(jomtPresentation.getIconID());
            if (stereotypeDefinition == null) continue;
            stereotypeDefinition.addObserver(jomtPresentation);
        }
    }
}

