/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.tools;

import java.awt.print.Book;
import java.awt.print.PrinterJob;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.PageRanges;
import net.astah.jomt.jcontrol.tools.PrintOutPut;
import net.astah.jomt.jcontrol.tools.PrintableInfo;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PrintUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Printer
extends PrintOutPut {
    private static final Logger a = LoggerFactory.getLogger(Printer.class);

    public Printer(PrintableInfo printableInfo) {
        super(printableInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean out() {
        Book book = this.printableInfo.getBook(false);
        int n2 = PrintUtilities.getPrintOption();
        if (n2 == 0) {
            if (book == null || book.getNumberOfPages() == 0) {
                return false;
            }
            PrinterJob printerJob = this.printableInfo.getPrinterJob();
            printerJob.setPageable(book);
            if (printerJob.printDialog()) {
                JomtGlobal.viewManager.beginWaitCursor();
                try {
                    printerJob.print();
                }
                catch (Exception exception) {
                    MessageManager.displayErrorMessage("app", "tell_printer_err.message");
                }
                finally {
                    JomtGlobal.viewManager.endWaitCursor();
                }
            }
        } else if (n2 == 1) {
            DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
            PrintService[] printServiceArray = this.lookupPrintServices(sERVICE_FORMATTED);
            if (0 >= printServiceArray.length) {
                MessageManager.displayErrorMessage("app", "printer_not_available.message");
                return false;
            }
            PrintRequestAttributeSet printRequestAttributeSet = this.printableInfo.loadPrintAttributes();
            if (printRequestAttributeSet == null) {
                return false;
            }
            int n3 = book.getNumberOfPages();
            printRequestAttributeSet.add(new PageRanges(1, n3));
            PrintService printService = ServiceUI.printDialog(null, 100, 100, printServiceArray, PrintServiceLookup.lookupDefaultPrintService(), null, printRequestAttributeSet);
            if (printService == null) {
                return false;
            }
            this.printableInfo.setPageFormat(printRequestAttributeSet);
            book = this.printableInfo.getBook(false);
            this.printToService(printService, book, printRequestAttributeSet, sERVICE_FORMATTED);
        }
        return false;
    }

    protected PrintService[] lookupPrintServices(DocFlavor docFlavor) {
        return PrintServiceLookup.lookupPrintServices(docFlavor, null);
    }

    public void printToService(PrintService printService, Book book, PrintRequestAttributeSet printRequestAttributeSet, DocFlavor docFlavor) {
        SimpleDoc simpleDoc = new SimpleDoc(book, docFlavor, null);
        DocPrintJob docPrintJob = printService.createPrintJob();
        try {
            docPrintJob.print(simpleDoc, printRequestAttributeSet);
        }
        catch (PrintException printException) {
            a.error("error has occurred.", printException);
        }
    }
}

