/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.tools;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import net.astah.dd.di.Diagram;
import net.astah.golf.draw.GCamera;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.CCanvas;
import net.astah.golf.widget.CDesktopPane;
import net.astah.golf.widget.swing.SwingCanvas;
import net.astah.jmodel.DiagramViewInfo;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jcontrol.tools.PrintableMulti;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.JomtCanvas;
import net.astah.jomt.jview.MultiChooser;
import net.astah.jomt.jview.MultiDiagramChooser;
import net.astah.jomt.jview.PrintUtilities;
import net.astah.jomt.jview.TableEditor;
import net.astah.model.extension.Preferences;
import net.astah.notation.TableView;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintableMultiDiagram
extends PrintableMulti {
    private static final Logger a = LoggerFactory.getLogger(PrintableMultiDiagram.class);

    public PrintableMultiDiagram(boolean bl) {
        super(bl);
    }

    public PrintableMultiDiagram(boolean bl, UMLDiagram[] uMLDiagramArray) {
        super(bl, uMLDiagramArray);
    }

    @Override
    protected MultiChooser getChooser(JFrame jFrame) {
        MultiDiagramChooser multiDiagramChooser = new MultiDiagramChooser(jFrame, false, false, false);
        multiDiagramChooser.setTitle(this.getTitle("ui.dialog.multi_diagram_chooser.title"));
        return multiDiagramChooser;
    }

    @Override
    protected PrintableMulti.ProxyToPrint getProxyToPrint(Object object) {
        return new ProxyToPrintDiagram(object);
    }

    @Override
    protected void addProxyPrintables(List<Diagram> list) {
        this.totalPages = new int[list.size()];
        ArrayList<PrintableMulti.ProxyToPrint> arrayList = new ArrayList<PrintableMulti.ProxyToPrint>();
        int n2 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n3;
            Diagram object = list.get(i2);
            PrintableMulti.ProxyToPrint proxyToPrint = this.getProxyToPrint(object);
            proxyToPrint.setupEditor();
            arrayList.add(proxyToPrint);
            this.setPrintable(proxyToPrint);
            pageFormat = this.loadPageFormat();
            Editor editor = proxyToPrint.editor;
            if (editor == null) {
                a.debug("cannot get JomtCanvas or Table Editor.");
                continue;
            }
            this.totalPages[i2] = n3 = this.a(editor) ? 1 : editor.getNumbersOfPrintable(pageFormat);
            n2 += n3;
            for (int i3 = 0; i3 < n3; ++i3) {
                this.addPrintable(proxyToPrint);
            }
        }
        PrintUtilities.setTotalPage(n2);
        for (PrintableMulti.ProxyToPrint proxyToPrint : arrayList) {
            proxyToPrint.editor.setTotalPages(n2);
        }
    }

    private JomtCanvas a(DiagramEditor diagramEditor) {
        if (diagramEditor == null) {
            throw new IllegalArgumentException("editor is null.");
        }
        CCanvas cCanvas = diagramEditor.getCanvas();
        if (cCanvas == null || !(cCanvas instanceof SwingCanvas)) {
            return null;
        }
        SwingCanvas swingCanvas = (SwingCanvas)SwingCanvas.class.cast(cCanvas);
        Component component = swingCanvas.getComponent();
        if (component == null || !(component instanceof JomtCanvas)) {
            return null;
        }
        return (JomtCanvas)JomtCanvas.class.cast(component);
    }

    private boolean a(Editor editor) {
        if (editor instanceof TableEditor) {
            return !this.getBooleanValueFromPrj("basic.print.table.multi");
        }
        return this.getIntValueFromPrj("basic.print.diagram.multi") == 0;
    }

    @Override
    protected String getStringValueFromPrj(String string) {
        return this.a(string);
    }

    @Override
    protected int getIntValueFromPrj(String string) {
        return Integer.valueOf(this.a(string));
    }

    @Override
    protected boolean getBooleanValueFromPrj(String string) {
        return Boolean.valueOf(this.a(string));
    }

    @Override
    protected double getDoubleValueFromPrj(String string) {
        return Double.valueOf(this.a(string));
    }

    private String a(String string) {
        Project project = ProjectManagerAdapter.getRootProject(ModelGlobal.prjManager.getCurrentProject().doc.getDomain().getResourceSet());
        Preferences preferences = project.getPreferences();
        String string2 = preferences == null ? RuntimeGlobal.sysProp.getStringWithDefault(string) : preferences.getStringValue(string, RuntimeGlobal.sysProp.getStringWithDefault(string));
        return string2;
    }

    protected class ProxyToPrintDiagram
    extends PrintableMulti.ProxyToPrint {
        ProxyToPrintDiagram(Object object) {
            super(object);
        }

        @Override
        protected Editor findExistingEditor(Object object) {
            List<Editor> list = JomtGlobal.viewManager.getAllEditors();
            for (Editor editor : list) {
                if (editor.getEditModel() != object) continue;
                return editor;
            }
            return null;
        }

        @Override
        protected Editor createNewEditor(Object object) {
            if ((Diagram)object instanceof TableView) {
                CDesktopPane cDesktopPane = JomtGlobal.viewManager.getManagementView().getDesktopPane();
                TableEditor tableEditor = new TableEditor((Diagram)object, cDesktopPane);
                tableEditor.getContainer().setVisible(false);
                this.createdEditor = true;
                return tableEditor;
            }
            DiagramViewInfo diagramViewInfo = new DiagramViewInfo((Diagram)object, new GCamera());
            CDesktopPane cDesktopPane = JomtGlobal.viewManager.getManagementView().getDesktopPane();
            DiagramEditor diagramEditor = new DiagramEditor(diagramViewInfo, cDesktopPane);
            diagramEditor.getContainer().setVisible(false);
            this.createdEditor = true;
            return diagramEditor;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n2) throws PrinterException {
            PrintableMultiDiagram.this.setPrintable(this);
            PrintableMultiDiagram.this.iniPrintInformation();
            if (PrintableMultiDiagram.this.a(this.editor)) {
                return super.print(graphics, pageFormat, n2);
            }
            if (this.editor instanceof TableEditor) {
                PrintUtilities.setMultiPageIndex(n2 + 1);
                PrintUtilities.setPageIndex(n2 + 1);
                int n3 = this.a();
                PrintUtilities.setTotalPage(n3);
            } else if (this.editor instanceof DiagramEditor) {
                JomtCanvas jomtCanvas = PrintableMultiDiagram.this.a((DiagramEditor)this.editor);
                if (jomtCanvas == null) {
                    a.debug("cannot get canvas");
                    return super.print(graphics, pageFormat, n2);
                }
                jomtCanvas.setCurrentPages(n2 + 1);
            }
            n2 = this.getPageIndex(n2);
            return super.print(graphics, pageFormat, n2);
        }

        private int a() {
            int n2 = 0;
            for (int i2 = 0; i2 < PrintableMultiDiagram.this.totalPages.length; ++i2) {
                n2 += PrintableMultiDiagram.this.totalPages[i2];
            }
            return n2;
        }

        @Override
        protected int printEditor(Graphics graphics, PageFormat pageFormat, int n2) throws PrinterException {
            if (PrintableMultiDiagram.this.a(this.editor)) {
                return super.printEditor(graphics, pageFormat, n2);
            }
            int n3 = this.editor.getMultiPrintable().print(graphics, pageFormat, n2);
            return n3;
        }
    }
}

