/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.tools;

import com.google.common.collect.Lists;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import net.astah.dd.di.Diagram;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.jmodel.Project;
import net.astah.jomt.jcontrol.tools.PrintableInfo;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.CastUtil;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.MultiChooser;
import net.astah.jomt.jview.PrintUtilities;

public class PrintableMulti
extends PrintableInfo {
    private List<Diagram> a = new ArrayList<Diagram>();
    protected int[] totalPages;

    public PrintableMulti(boolean bl, Diagram[] diagramArray) {
        this.isShowPageSetup = bl;
        this.a = this.a(diagramArray);
        if (this.a.isEmpty()) {
            this.success = false;
            return;
        }
        int n2 = RuntimeGlobal.sysProp.getIntWithDefault("print.mode.selected");
        if (n2 == 1) {
            bl = false;
            String string = this.getProjectFileName();
            this.addPrintStandardName(string);
        }
    }

    public PrintableMulti(boolean bl) {
        this(bl, null);
    }

    public List<Diagram> getPrintElements() {
        return this.a;
    }

    @Override
    protected void setPrintable() {
        JomtGlobal.viewManager.beginWaitCursor();
        this.addProxyPrintables(this.a);
        this.getPrinterJob().setJobName(this.getProjectFileName());
        JomtGlobal.viewManager.endWaitCursor();
    }

    protected String getProjectFileName() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        String string = project.doc.getName();
        int n2 = string.lastIndexOf(File.separatorChar);
        if (n2 > 0 && n2 < string.length() - 1) {
            return string.substring(n2 + 1, string.length());
        }
        return string;
    }

    protected void addProxyPrintables(List<Diagram> list) {
        for (Diagram diagram : list) {
            ProxyToPrint proxyToPrint = this.getProxyToPrint(diagram);
            proxyToPrint.setupEditor();
            this.addPrintable(proxyToPrint);
        }
        PrintUtilities.setTotalPage(list.size());
    }

    @Override
    public void end() {
        this.clearPrintable();
    }

    private List<Diagram> a(Diagram[] diagramArray) {
        if (diagramArray != null) {
            return Arrays.stream(diagramArray).filter(diagram -> diagram != null).collect(Collectors.toList());
        }
        JomtGlobal.viewManager.beginWaitCursor();
        JFrame jFrame = (JFrame)((SwingComponent)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
        MultiChooser multiChooser = this.getChooser(jFrame);
        multiChooser.setLocationRelativeTo(jFrame);
        JomtGlobal.viewManager.endWaitCursor();
        multiChooser.setVisible(true);
        if (!multiChooser.isApprove()) {
            return Lists.newArrayList();
        }
        return (List)CastUtil.automaticCast(multiChooser.getCheckedItems());
    }

    protected ProxyToPrint getProxyToPrint(Object object) {
        return null;
    }

    protected MultiChooser getChooser(JFrame jFrame) {
        return null;
    }

    @Override
    protected void clearPrintable() {
        this.a();
        this.printableList.clear();
    }

    private void a() {
        for (Printable printable : this.printableList) {
            ProxyToPrint proxyToPrint;
            if (printable == null || !(printable instanceof ProxyToPrint) || (proxyToPrint = (ProxyToPrint)ProxyToPrint.class.cast(printable)).b() == null) continue;
            proxyToPrint.a();
        }
    }

    protected String getTitle(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    protected class ProxyToPrint
    implements Printable {
        protected Object obj = null;
        protected Editor editor = null;
        protected boolean createdEditor = false;

        protected ProxyToPrint(Object object) {
            this.obj = object;
        }

        protected void setupEditor() {
            Editor editor = this.findExistingEditor(this.obj);
            this.editor = editor != null ? editor : this.createNewEditor(this.obj);
            this.editor.stopEditing();
        }

        protected Editor createNewEditor(Object object) {
            return null;
        }

        protected Editor findExistingEditor(Object object) {
            return null;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n2) throws PrinterException {
            if (this.editor == null) {
                this.setupEditor();
            }
            boolean bl = PrintableMulti.this.getBackgroundVisibility(this.editor);
            PrintableMulti.this.setBackgroundVisibility(this.editor, false);
            boolean bl2 = RuntimeGlobal.sysProp.getBooleanWithDefault("hyperlink.diagram_icon_print_visibility");
            if (!bl2) {
                PrintableMulti.this.setHyperIconVisibility(this.editor, false);
            }
            int n3 = this.printEditor(graphics, pageFormat, n2);
            if (this.editor != null) {
                PrintableMulti.this.setBackgroundVisibility(this.editor, bl);
                boolean bl3 = RuntimeGlobal.sysProp.getBooleanWithDefault("hyperlink.diagram_icon_visibility");
                PrintableMulti.this.setHyperIconVisibility(this.editor, bl3);
            }
            return n3;
        }

        protected int getPageIndex(int n2) {
            for (int i2 = 0; i2 < PrintableMulti.this.totalPages.length && n2 + 1 - PrintableMulti.this.totalPages[i2] > 0; ++i2) {
                n2 -= PrintableMulti.this.totalPages[i2];
            }
            return n2;
        }

        protected int printEditor(Graphics graphics, PageFormat pageFormat, int n2) throws PrinterException {
            int n3 = this.editor.getPrintable().print(graphics, pageFormat, n2);
            return n3;
        }

        private void a() {
            if (this.createdEditor) {
                this.editor.remove();
                this.createdEditor = false;
                this.editor = null;
            }
        }

        private Editor b() {
            return this.editor;
        }
    }
}

