/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.mode;

import java.awt.event.MouseEvent;
import java.util.List;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Line2d;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.util.Geometry;
import net.astah.jmodel.AssociationClassAnchorPresentation;
import net.astah.jmodel.BinaryRelationPresentation;
import net.astah.jmodel.ConnectorPresentation;
import net.astah.jmodel.GeometryUtil;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.MMLinkPresentation;
import net.astah.jmodel.NoteAnchorPresentation;
import net.astah.jmodel.NotePresentation;
import net.astah.jmodel.PathPresentation;
import net.astah.jmodel.PortPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jcontrol.ModRelationPntsCommand;
import net.astah.jomt.jcontrol.mode.DiagramMode;
import net.astah.jomt.jutil.JomtDiagram;
import net.astah.jomt.jutil.JomtPresentationUtil;
import net.astah.notation.edit.layout.DiagramElementOperations;
import org.eclipse.uml2.uml.Connector;

public class RelationStrategy
extends DiagramMode {
    protected GNode pickedNode = null;
    private GRect a;
    protected Pnt2d start = new Pnt2d();
    protected Pnt2d end = new Pnt2d();
    protected int endKnobNum;
    protected int lineNum = -1;
    protected int knobNum = -1;
    protected double specialOffsetX = 0.0;
    protected double specialOffsetY = 0.0;

    protected void setPickedNode(GNode gNode) {
        this.pickedNode = gNode;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.start.x = this.camera.toWorldCoordX(mouseEvent.getX());
        this.start.y = this.camera.toWorldCoordY(mouseEvent.getY());
        DiagramElement diagramElement = DiagramElementOperations.getDiagramElement(this.pickedNode);
        if (!(diagramElement instanceof BinaryRelationPresentation)) {
            return;
        }
        BinaryRelationPresentation binaryRelationPresentation = (BinaryRelationPresentation)diagramElement;
        this.knobNum = GeometryUtil.getClickedKnobIndex(this.start, binaryRelationPresentation);
        if (!this.isValidKnobNum(binaryRelationPresentation)) {
            this.knobNum = -1;
            if (binaryRelationPresentation instanceof MMLinkPresentation) {
                this.lineNum = -1;
            } else {
                this.lineNum = Geometry.getClickedLineIndex(this.start, binaryRelationPresentation.getAllPoints().toArray(new Pnt2d[0]));
                if (this.lineNum == -1 && binaryRelationPresentation.isCurve()) {
                    if (binaryRelationPresentation.isRightAngleConstraint()) {
                        this.lineNum = this.b(binaryRelationPresentation, this.start);
                    } else {
                        this.knobNum = this.a(binaryRelationPresentation, this.start);
                    }
                }
            }
        }
        if (this.knobNum == -1 && this.lineNum == -1) {
            this.clear();
            return;
        }
        Pnt2d[] pnt2dArray = binaryRelationPresentation.getAllPoints().toArray(new Pnt2d[0]);
        if ((this.knobNum == 0 || this.knobNum == pnt2dArray.length - 1) && binaryRelationPresentation instanceof AssociationClassAnchorPresentation) {
            this.clear();
            return;
        }
        mouseEvent.consume();
        this.mousePressed();
    }

    private int a(BinaryRelationPresentation binaryRelationPresentation, Pnt2d pnt2d) {
        Pnt2d[] pnt2dArray = binaryRelationPresentation.getAllPoints().toArray(new Pnt2d[0]);
        double d2 = Double.POSITIVE_INFINITY;
        int n2 = 0;
        Line2d line2d = new Line2d();
        for (int i2 = 0; i2 < pnt2dArray.length - 1; ++i2) {
            line2d.setLine(pnt2dArray[i2], pnt2dArray[i2 + 1]);
            double d3 = line2d.ptSegDist(pnt2d);
            if (!(d3 < d2)) continue;
            d2 = d3;
            n2 = i2;
        }
        if (n2 == 0) {
            n2 = 1;
        } else if (n2 != pnt2dArray.length - 2) {
            double d4 = Pnt2d.distanceSq(pnt2d.x, pnt2d.y, pnt2dArray[n2].x, pnt2dArray[n2].y);
            double d5 = Pnt2d.distanceSq(pnt2d.x, pnt2d.y, pnt2dArray[n2 + 1].x, pnt2dArray[n2 + 1].y);
            if (d5 < d4) {
                ++n2;
            }
        }
        this.specialOffsetX = pnt2dArray[n2].x - this.start.x;
        this.specialOffsetY = pnt2dArray[n2].y - this.start.y;
        return n2;
    }

    private int b(BinaryRelationPresentation binaryRelationPresentation, Pnt2d pnt2d) {
        Pnt2d[] pnt2dArray = binaryRelationPresentation.getAllPoints().toArray(new Pnt2d[0]);
        double d2 = Double.POSITIVE_INFINITY;
        int n2 = 0;
        Line2d line2d = new Line2d();
        for (int i2 = 0; i2 < pnt2dArray.length - 1; ++i2) {
            if (i2 > 1 && i2 < pnt2dArray.length - 3) continue;
            line2d.setLine(pnt2dArray[i2], pnt2dArray[i2 + 1]);
            double d3 = line2d.ptSegDist(pnt2d);
            if (!(d3 < d2)) continue;
            d2 = d3;
            n2 = i2;
        }
        this.specialOffsetX = pnt2dArray[n2].x - this.start.x;
        this.specialOffsetY = pnt2dArray[n2].y - this.start.y;
        return n2;
    }

    protected boolean isValidKnobNum(BinaryRelationPresentation binaryRelationPresentation) {
        return (this.pickedNode.isSelected() || this.knobNum != 0 && this.knobNum != binaryRelationPresentation.getAllPoints().size() - 1) && this.knobNum != -1;
    }

    protected void mousePressed() {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void clear() {
        this.pickedNode = null;
        this.lineNum = -1;
        this.knobNum = -1;
        this.canvas.clear();
        this.canvas.draw();
        this.canvas.repaint();
        this.specialOffsetX = 0.0;
        this.specialOffsetY = 0.0;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    protected int getPickableType() {
        return 1;
    }

    protected boolean isRelationCorrectForLabel(BinaryRelationPresentation binaryRelationPresentation, JomtPresentation jomtPresentation) {
        if (!(jomtPresentation instanceof LabelPresentation)) {
            return false;
        }
        if (!(jomtPresentation instanceof NotePresentation) && binaryRelationPresentation instanceof NoteAnchorPresentation) {
            return this.isNoteAnchorCorrect(binaryRelationPresentation);
        }
        return true;
    }

    protected boolean isNoteAnchorCorrectForLine(BinaryRelationPresentation binaryRelationPresentation, JomtPresentation jomtPresentation) {
        if (!(jomtPresentation instanceof BinaryRelationPresentation) || !(binaryRelationPresentation instanceof NoteAnchorPresentation)) {
            return false;
        }
        return this.isNoteAnchorCorrect(binaryRelationPresentation);
    }

    protected boolean isNoteAnchorCorrect(BinaryRelationPresentation binaryRelationPresentation) {
        if (this.knobNum == 0 && binaryRelationPresentation.getTargetPresentation() instanceof NotePresentation) {
            return true;
        }
        return this.knobNum == this.endKnobNum && binaryRelationPresentation.getSourcePresentation() instanceof NotePresentation;
    }

    protected void modRelationOfNoteanchor(MouseEvent mouseEvent, BinaryRelationPresentation binaryRelationPresentation, JomtPresentation jomtPresentation) {
        ModRelationPntsCommand modRelationPntsCommand = new ModRelationPntsCommand();
        modRelationPntsCommand.setPresentation(binaryRelationPresentation);
        if (this.knobNum == 0) {
            modRelationPntsCommand.setSourcePresentation(jomtPresentation);
            modRelationPntsCommand.setSourceEnd(0.5, 0.5);
        } else if (this.knobNum == this.endKnobNum) {
            modRelationPntsCommand.setTargetPresentation(jomtPresentation);
            modRelationPntsCommand.setTargetModel(jomtPresentation.getModel());
            modRelationPntsCommand.setTargetEnd(0.5, 0.5);
            if (jomtPresentation instanceof PathPresentation) {
                double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
                double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
                Pnt2d pnt2d = new Pnt2d(d2, d3);
                double d4 = JomtPresentationUtil.getPathRatio(pnt2d, (PathPresentation)jomtPresentation);
                modRelationPntsCommand.setTargetPathPresentationRatio(d4);
            }
        }
        this.fireCommandPerformed(new CommandEvent(mouseEvent.getSource(), mouseEvent.getID(), "ModRelationPnts", modRelationPntsCommand, mouseEvent.getModifiers()));
    }

    protected void hightlightPickedTargetNode(MouseEvent mouseEvent) {
        JomtPresentation jomtPresentation = this.getPickedPresentation(mouseEvent);
        if (jomtPresentation != null && this.shouldHightlightPickedNode(jomtPresentation)) {
            this.hightLightPickedPs(jomtPresentation);
        } else {
            this.a();
        }
    }

    protected boolean shouldHightlightPickedNode(JomtPresentation jomtPresentation) {
        return false;
    }

    protected void hightLightPickedPs(JomtPresentation jomtPresentation) {
        if (jomtPresentation instanceof RectPresentation) {
            Pnt2d pnt2d = jomtPresentation.getLocation();
            double d2 = ((RectPresentation)jomtPresentation).getWidth();
            double d3 = ((RectPresentation)jomtPresentation).getHeight();
            if (this.a != null) {
                this.scene.removeTempNode(this.a);
                this.a = null;
            }
            this.a = new GRect(pnt2d.x, pnt2d.y, d2, d3);
            this.a.setColorNo((byte)3);
            this.a.setBackgroundNo((byte)0);
            this.a.setRimWidth(2);
            this.scene.addTempNode(this.a);
            this.canvas.repaintSync();
            this.canvas.drawTempFront();
        }
    }

    private void a() {
        if (this.a != null) {
            this.scene.removeTempNode(this.a);
            this.a = null;
        }
    }

    protected JomtPresentation getPickedPresentation(MouseEvent mouseEvent) {
        List<GNode> list = this.getPickedNodes(mouseEvent, this.getPickableType(), true);
        JomtPresentation jomtPresentation = null;
        if (list != null && !list.isEmpty()) {
            jomtPresentation = RelationStrategy.getFrontOverlapPresentation(list);
        }
        if (jomtPresentation == null) {
            jomtPresentation = this.a(mouseEvent);
        }
        return jomtPresentation;
    }

    private JomtPresentation a(MouseEvent mouseEvent) {
        int n2 = (int)this.camera.toWorldCoordX(mouseEvent.getX());
        int n3 = (int)this.camera.toWorldCoordY(mouseEvent.getY());
        Pnt2d pnt2d = new Pnt2d(n2, n3);
        Diagram diagram = this.de.getDiagram();
        JomtPresentation jomtPresentation = (JomtPresentation)JomtDiagram.getFrontPresentation(diagram, pnt2d);
        return jomtPresentation;
    }

    protected PortPresentation getAnotherSidePortPs(List list) {
        Object object;
        Presentation presentation = null;
        for (GNode gNode : list) {
            object = (UserObject)gNode.getModel();
            if (!(((UserObject)object).getPresentation() instanceof ConnectorPresentation) || !(((UserObject)object).getModel() instanceof Connector)) continue;
            presentation = (ConnectorPresentation)((UserObject)object).getPresentation();
        }
        if (presentation != null) {
            double d2 = 0.0;
            object = null;
            for (Presentation presentation2 : presentation.getServers()) {
                if (!(presentation2 instanceof PortPresentation)) continue;
                Rectangle2d rectangle2d = ((PortPresentation)presentation2).getBoundsRect();
                double d3 = Pnt2d.distance(rectangle2d.x, rectangle2d.y, this.pickedRect.x, this.pickedRect.y);
                if (!(d3 > d2)) continue;
                object = (PortPresentation)presentation2;
                d2 = d3;
            }
            return object;
        }
        return null;
    }
}

