/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.mode;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.astah.dd.di.Diagram;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.AdapterFactoryTreeCellEditor;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.control.CommandManager;
import net.astah.golf.draw.GCamera;
import net.astah.golf.util.KeyUtil;
import net.astah.golf.util.ResourceBundleList;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.view.swing.CustomerScrollPane;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.golf.widget.CContainer;
import net.astah.golf.widget.CPopupMenu;
import net.astah.golf.widget.CTree;
import net.astah.jmodel.DiagramViewInfo;
import net.astah.jmodel.EntityAccessor;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jmodel.UMLClassDiagram;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UMLSequenceDiagram;
import net.astah.jmodel.UMLStateChartDiagram;
import net.astah.jmodel.UMLUseCaseDiagram;
import net.astah.jomt.jcontrol.DeleteModelFromPrjCommand;
import net.astah.jomt.jcontrol.ModifyNameCommand;
import net.astah.jomt.jcontrol.OpenDiagramEditorCommand;
import net.astah.jomt.jcontrol.OpenDiagramsFromPrjCommand;
import net.astah.jomt.jcontrol.OpenModelFromPrjCommand;
import net.astah.jomt.jcontrol.OpenPropertyViewCommand;
import net.astah.jomt.jcontrol.OpenTableEditorCommand;
import net.astah.jomt.jcontrol.mode.JomtMode;
import net.astah.jomt.jcontrol.mode.j;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.AliasView;
import net.astah.jomt.jview.HierarchyView;
import net.astah.jomt.jview.JTreeTable;
import net.astah.jomt.jview.ProjectTreeCellRenderer;
import net.astah.jomt.jview.ProjectView;
import net.astah.matrix.UMatrixDiagram;
import net.astah.notation.TableView;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.project.Project;
import net.astah.uml2.uml.Classifiers;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.Actor;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectViewMode
extends JomtMode
implements CellEditorListener {
    protected CTree tree;
    protected ProjectView projectView;
    private List<TreePath> a = new ArrayList<TreePath>();
    private List<TreePath> b = new ArrayList<TreePath>();
    private boolean c;
    private boolean d = false;
    private static final Logger e = LoggerFactory.getLogger(ProjectViewMode.class);

    public ProjectViewMode() {
    }

    public ProjectViewMode(ProjectView projectView, CTree cTree) {
        this.tree = cTree;
        this.projectView = projectView;
        cTree.getCellEditor().addCellEditorListener(this);
    }

    public void setProjectView(ProjectView projectView) {
        this.projectView = projectView;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (CommandManager.IS_PAUSE_COMMAND) {
            return;
        }
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        this.b.clear();
        for (int i2 = 0; i2 < treePathArray.length; ++i2) {
            this.b.add(treePathArray[i2]);
        }
        if (this.a.containsAll(this.b)) {
            this.tree.setSelectionPaths(this.a);
        }
        if (this.tree.isEditing()) {
            this.tree.getCellEditor().cancelCellEditing();
        }
        if (!this.isAvoidToConsumeMouseEvent()) {
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.a.clear();
        this.a.addAll(this.b);
        Object object = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (object == null) {
            this.tree.clearSelection();
            this.tree.repaint();
            this.a.clear();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n2;
        Object object;
        if (CommandManager.IS_PAUSE_COMMAND) {
            return;
        }
        if (this.a(mouseEvent)) {
            this.mouseDoubleClick(mouseEvent);
            return;
        }
        Object object2 = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (object2 == null) {
            this.tree.repaint();
            return;
        }
        if (!InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        if (InputEventSupport.isMacExchangedButton(mouseEvent)) {
            return;
        }
        if (this.projectView.getSelectedUIViewTab() instanceof AliasView && (object = ((AliasView)this.projectView.getAliasView()).getTreeTable()) != null) {
            int n3 = ((JTreeTable)object).getEditingRow();
            n2 = ((JTable)object).getEditingColumn();
            if (n3 != -1 && n2 != -1) {
                ((JTable)object).getCellEditor(n3, n2).stopCellEditing();
            }
        }
        object = this.tree.getSelectedUserObject(object2);
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        n2 = 0;
        if (treePathArray != null) {
            for (int i2 = 0; i2 < treePathArray.length; ++i2) {
                if (treePathArray[i2] != object2) continue;
                this.showPopup(object, mouseEvent);
                n2 = 1;
                break;
            }
        }
        if (n2 == 0) {
            if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                this.tree.clearSelection();
            }
            this.tree.addSelectionPath(object2);
            this.showPopup(object, mouseEvent);
        }
    }

    private boolean a(MouseEvent mouseEvent) {
        return !InputEventSupport.isPopupTrigger(mouseEvent) && InputEventSupport.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() >= 2;
    }

    protected boolean isOnlyMMTopic(Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = this.tree.getSelectedUserObject(objectArray[i2]);
            if (object == null) continue;
            return false;
        }
        return true;
    }

    protected boolean isContainReadOnlyModel(Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            UMLDiagram uMLDiagram;
            Object object = this.tree.getSelectedUserObject(objectArray[i2]);
            if (!(object instanceof Presentation) || (uMLDiagram = ((Presentation)object).getDiagram()) == null || !EObjects.isReadOnly(uMLDiagram)) continue;
            return true;
        }
        return false;
    }

    protected boolean isOnlyDiagrams(Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = this.tree.getSelectedUserObject(objectArray[i2]);
            if (object == null) {
                return false;
            }
            if (object instanceof UMLDiagram) continue;
            return false;
        }
        return true;
    }

    protected void showPopup(Object object, MouseEvent mouseEvent) {
        e.trace("ProjectViewMode::showPopup() ");
        if (this.projectView.getSelectedUIViewTab() instanceof HierarchyView) {
            CPopupMenu cPopupMenu = this.projectView.getPopup("projectview.popupmenu.hierachy_view");
            this.showPopup(cPopupMenu, mouseEvent);
            return;
        }
        if (this.tree.getSelectionPaths().length != 1) {
            if (!this.isOnlyMMTopic(this.tree.getSelectionPaths())) {
                if (this.isOnlyDiagrams(this.tree.getSelectionPaths())) {
                    CPopupMenu cPopupMenu = this.projectView.getPopup("projectview.popupmenu.plural_diagram");
                    if (this.isContainReadOnlyModel(this.tree.getSelectionPaths())) {
                        // empty if block
                    }
                    this.showPopup(cPopupMenu, mouseEvent);
                } else if (this.isContainReadOnlyModel(this.tree.getSelectionPaths())) {
                    CPopupMenu cPopupMenu = this.projectView.getPopup("projectview.popupmenu.default");
                    this.showPopup(cPopupMenu, mouseEvent);
                } else {
                    CPopupMenu cPopupMenu = this.projectView.getPopup("projectview.popupmenu.default");
                    this.showPopup(cPopupMenu, mouseEvent);
                }
            }
        } else if (object instanceof Project) {
            this.showProjectPopup((Project)object, mouseEvent);
        } else if (object instanceof Package) {
            this.showPackagePopup(object, mouseEvent);
        } else if (object instanceof ProfileApplication) {
            CPopupMenu cPopupMenu = this.projectView.getPopup("projectview.popupmenu.profile_application");
            this.showPopup(cPopupMenu, mouseEvent);
        } else if (object instanceof Classifier) {
            this.showClassifierPopup((Classifier)object, mouseEvent);
        } else if (object instanceof EnumerationLiteral) {
            this.showEnumerationLiteralPopup((EnumerationLiteral)object, mouseEvent);
        } else if (object instanceof Property && Classifiers.isAttributeWithoutAssociation((Property)object)) {
            this.showAttributePopup((Property)object, mouseEvent);
        } else if (object instanceof Property) {
            CPopupMenu cPopupMenu = this.projectView.getPopup("projectview.popupmenu.part");
            this.projectView.updatePopup((Property)object, cPopupMenu);
            this.projectView.updateHyperlinkPopup((Element)object, cPopupMenu);
            this.showPopup(cPopupMenu, mouseEvent);
        } else if (object instanceof Operation) {
            CPopupMenu cPopupMenu = this.projectView.getPopup(((Operation)object).getOwner() instanceof DataType ? "projectview.popupmenu.operation_datatype_owned" : "projectview.popupmenu.operation");
            this.projectView.updatePopup((Operation)object, cPopupMenu);
            this.projectView.updateRecentTemplateActivityfiles(cPopupMenu);
            this.projectView.updateHyperlinkPopup((Operation)object, cPopupMenu);
            this.showPopup(cPopupMenu, mouseEvent);
        } else if (object instanceof Diagram) {
            this.showDiagramPopUpMenu((Diagram)object, mouseEvent);
        } else if (object instanceof MMTopicShape) {
            MMTopicShape mMTopicShape = (MMTopicShape)object;
            CPopupMenu cPopupMenu = this.projectView.getPopup("projectview.popupmenu.mindmap_topic");
            this.projectView.updatePopup(mMTopicShape, cPopupMenu);
            this.projectView.updateHyperlinkPopup(mMTopicShape, cPopupMenu);
            this.projectView.updateReadonlyPopup((Diagram)((Object)mMTopicShape.getMMOwningElement()), cPopupMenu);
            this.showPopup(cPopupMenu, mouseEvent);
        } else if (object instanceof Vertex || object instanceof Action) {
            CPopupMenu cPopupMenu = this.projectView.getPopup("projectview.popupmenu.state");
            this.projectView.updatePopup((NamedElement)object, cPopupMenu);
            this.projectView.updateHyperlinkPopup((NamedElement)object, cPopupMenu);
            this.showPopup(cPopupMenu, mouseEvent);
        } else {
            this.showPopupMenu((EObject)object, mouseEvent);
        }
    }

    protected void showProjectPopup(Project project, MouseEvent mouseEvent) {
        CPopupMenu cPopupMenu = this.projectView.getPopup("projectview.popupmenu.project_model.offline");
        this.projectView.updateHyperlinkPopup(project, cPopupMenu);
        this.showPopup(cPopupMenu, mouseEvent);
    }

    protected void showPackagePopup(Object object, MouseEvent mouseEvent) {
        CPopupMenu cPopupMenu = null;
        cPopupMenu = object instanceof Model ? (object == EntityAccessor.getProjectModel() ? (this.e() ? this.projectView.getPopup("projectview.popupmenu.project_model") : this.projectView.getPopup("projectview.popupmenu.project_model.offline")) : (this.e() ? this.projectView.getPopup("projectview.popupmenu.model") : this.projectView.getPopup("projectview.popupmenu.model.offline"))) : (this.e() ? this.projectView.getPopup("projectview.popupmenu.package") : this.projectView.getPopup("projectview.popupmenu.package.offline"));
        this.projectView.updatePopup((Package)object, cPopupMenu);
        this.projectView.updateHyperlinkPopup((NamedElement)object, cPopupMenu);
        this.projectView.updateRecentTemplateActivityfiles(cPopupMenu);
        this.showPopup(cPopupMenu, mouseEvent);
    }

    protected void showAttributePopup(Property property, MouseEvent mouseEvent) {
        CPopupMenu cPopupMenu = null;
        cPopupMenu = this.projectView.getPopup("projectview.popupmenu.attribute");
        this.projectView.updateHyperlinkPopup(property, cPopupMenu);
        this.showPopup(cPopupMenu, mouseEvent);
    }

    protected void showDiagramPopUpMenu(Diagram diagram, MouseEvent mouseEvent) {
        CPopupMenu cPopupMenu = this.getDiagramPopupMenu(diagram);
        this.projectView.updateHyperlinkPopup(diagram, cPopupMenu);
        this.projectView.updateReferedMatrixDgmPopup(diagram, cPopupMenu);
        this.projectView.updateReadonlyPopup(diagram, cPopupMenu);
        this.showPopup(cPopupMenu, mouseEvent);
    }

    protected CPopupMenu getDiagramPopupMenu(Diagram diagram) {
        CPopupMenu cPopupMenu = null;
        if (diagram instanceof UMLUseCaseDiagram) {
            cPopupMenu = this.projectView.getPopup("projectview.popupmenu.usecase_diagram");
        } else if (diagram instanceof MMDiagram) {
            cPopupMenu = this.projectView.getPopup("projectview.popupmenu.mindmap_diagram");
            this.projectView.updateTemplatePopup(null, cPopupMenu);
        } else if (diagram instanceof UMLActivityDiagram) {
            cPopupMenu = this.projectView.getPopup("projectview.popupmenu.activity_diagram");
            this.projectView.updateDiagramRefersToPopup((UMLDiagram)diagram, cPopupMenu);
        } else if (diagram instanceof UMLStateChartDiagram || diagram instanceof UMLSequenceDiagram) {
            cPopupMenu = this.projectView.getPopup("projectview.popupmenu.has_refers_to_diagram");
            this.projectView.updateDiagramRefersToPopup((UMLDiagram)diagram, cPopupMenu);
        } else {
            cPopupMenu = diagram instanceof UMLClassDiagram ? this.projectView.getPopup("projectview.popupmenu.class_diagram") : (diagram instanceof UMatrixDiagram ? this.projectView.getPopup("projectview.popupmenu.crud_diagram") : (diagram instanceof TableView ? this.projectView.getPopup("projectview.popupmenu.table") : this.projectView.getPopup("projectview.popupmenu.diagram")));
        }
        return cPopupMenu;
    }

    protected void showClassifierPopup(Classifier classifier, MouseEvent mouseEvent) {
        CPopupMenu cPopupMenu = null;
        if (classifier.eClass().equals(UMLPackage.Literals.ASSOCIATION)) {
            return;
        }
        cPopupMenu = classifier instanceof UseCase ? this.projectView.getPopup("projectview.popupmenu.usecase") : (classifier instanceof Actor ? this.projectView.getPopup("projectview.popupmenu.actor") : (classifier instanceof Interface ? this.projectView.getPopup("projectview.popupmenu.interface") : (classifier instanceof DataType ? (classifier instanceof PrimitiveType ? this.projectView.getPopup("projectview.popupmenu.primitivetype") : (classifier instanceof Enumeration ? this.projectView.getPopup("projectview.popupmenu.enumeration") : this.projectView.getPopup("projectview.popupmenu.datatype"))) : (classifier.getTemplateParameter() != null ? this.projectView.getPopup("projectview.popupmenu.templateparameter") : this.getClassPopup(classifier)))));
        this.projectView.updatePopup(classifier, cPopupMenu);
        this.projectView.updateHyperlinkPopup(classifier, cPopupMenu);
        this.projectView.updateRecentTemplateMMfiles(cPopupMenu);
        this.projectView.updateRecentTemplateActivityfiles(cPopupMenu);
        this.projectView.updateReferedMatrixDgmPopup(classifier, cPopupMenu);
        this.showPopup(cPopupMenu, mouseEvent);
    }

    protected void showEnumerationLiteralPopup(EnumerationLiteral enumerationLiteral, MouseEvent mouseEvent) {
        CPopupMenu cPopupMenu = null;
        cPopupMenu = this.projectView.getPopup("projectview.popupmenu.enumeration_literal");
        this.projectView.updateHyperlinkPopup(enumerationLiteral, cPopupMenu);
        this.showPopup(cPopupMenu, mouseEvent);
    }

    protected CPopupMenu getClassPopup(Classifier classifier) {
        return this.projectView.getPopup("projectview.popupmenu.class");
    }

    protected void showPopupMenu(EObject eObject, MouseEvent mouseEvent) {
        CPopupMenu cPopupMenu = this.getPopupMenu(eObject);
        if (cPopupMenu != null) {
            this.showPopup(cPopupMenu, mouseEvent);
        }
    }

    protected CPopupMenu getPopupMenu(EObject eObject) {
        return null;
    }

    protected String getTitle(String string) {
        return PropertyManager.getProjectViewResourceBundle().getString(string);
    }

    protected void showPopup(CPopupMenu cPopupMenu, MouseEvent mouseEvent) {
        cPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    protected void mouseDoubleClick(MouseEvent mouseEvent) {
        this.b(mouseEvent);
    }

    private void b(MouseEvent mouseEvent) {
        Object object = !this.b.isEmpty() ? this.b.get(0) : this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (object == null) {
            this.tree.repaint();
            return;
        }
        Object object2 = this.tree.getSelectedUserObject(object);
        if (object2 instanceof Diagram) {
            Diagram diagram = (Diagram)object2;
            if (diagram instanceof TableView) {
                this.a(mouseEvent, diagram);
            } else {
                DiagramViewInfo diagramViewInfo = new DiagramViewInfo(diagram, new GCamera());
                this.openDiagram(mouseEvent, diagramViewInfo);
            }
        } else if (object2 instanceof Classifier || object2 instanceof Property || object2 instanceof Operation || object2 instanceof Package) {
            this.tree.repaint();
        } else if (object2 instanceof MMTopicShape) {
            OpenModelFromPrjCommand openModelFromPrjCommand = new OpenModelFromPrjCommand();
            openModelFromPrjCommand.setArgumentString(EcoreUtil.getURI((MMTopicShape)object2).toString());
            this.fireCommandPerformed(new CommandEvent(mouseEvent.getSource(), mouseEvent.getID(), "OpenModelFromPrj", openModelFromPrjCommand, mouseEvent.getModifiers()));
        }
    }

    protected void openDiagramByEnter(KeyEvent keyEvent) {
        OpenDiagramsFromPrjCommand openDiagramsFromPrjCommand = new OpenDiagramsFromPrjCommand();
        this.fireCommandPerformed(new CommandEvent(keyEvent.getSource(), keyEvent.getID(), "OpenDiagramsFromPrj", openDiagramsFromPrjCommand, keyEvent.getModifiers()));
    }

    private void a(InputEvent inputEvent, Element element) {
        OpenPropertyViewCommand openPropertyViewCommand = new OpenPropertyViewCommand();
        openPropertyViewCommand.setModel(element);
        this.fireCommandPerformed(new CommandEvent(inputEvent.getSource(), inputEvent.getID(), "openPropertyView", openPropertyViewCommand, inputEvent.getModifiers()));
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.projectView.getSelectedUIViewTab() instanceof HierarchyView) {
            return;
        }
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (keyEvent.getKeyCode() == KeyUtil.getKeyCode(PropertyManager.getDiagramEditorResourceBundle(), "diagramview.action.start_editing_node.key")) {
            this.a(keyEvent);
            keyEvent.consume();
        } else if (keyEvent.getModifiers() == 0 && n2 != 0 && keyEvent.getKeyCode() == KeyUtil.getKeyCode(PropertyManager.getProjectViewResourceBundle(), "projectview.popupmenu.item.delete_from_diagram.key")) {
            this.deleteFromDiagram(keyEvent);
            keyEvent.consume();
        } else if ((keyEvent.getModifiers() & n2) != 0 && keyEvent.getKeyCode() == KeyUtil.getKeyCode(PropertyManager.getProjectViewResourceBundle(), "projectview.popupmenu.item.delete.key")) {
            this.deleteModel(keyEvent);
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 10) {
            this.d = true;
        }
    }

    protected void deleteFromDiagram(KeyEvent keyEvent) {
    }

    protected void deleteModel(KeyEvent keyEvent) {
        DeleteModelFromPrjCommand deleteModelFromPrjCommand = new DeleteModelFromPrjCommand();
        this.fireCommandPerformed(new CommandEvent(keyEvent.getSource(), keyEvent.getID(), "DeleteModelFromPrj", deleteModelFromPrjCommand, keyEvent.getModifiers()));
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        super.keyReleased(keyEvent);
        if (keyEvent.getKeyCode() == 10 && this.d) {
            this.d = false;
            this.openDiagramByEnter(keyEvent);
        }
    }

    private void a(KeyEvent keyEvent) {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null && this.a(treePath.getLastPathComponent())) {
            this.tree.startEditingAtPath(treePath);
        }
    }

    private boolean a(Object object) {
        return !((object = ItemProviders.unwrap(object)) instanceof EObject) || !EObjects.isReadOnly((EObject)object);
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
        this.d = false;
        this.a(changeEvent);
        if (!this.c() && this.d() || this.c() && this.d()) {
            this.a();
        }
        this.tree.repaint();
    }

    private void a() {
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        Object object = this.tree.getSelectionPath();
        ProjectTreeCellRenderer projectTreeCellRenderer = null;
        if (object == null && treeCellRenderer instanceof ProjectTreeCellRenderer) {
            projectTreeCellRenderer = (ProjectTreeCellRenderer)treeCellRenderer;
            projectTreeCellRenderer.setIDVisible(true);
        }
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        this.editingCanceled(changeEvent);
    }

    private void a(ChangeEvent changeEvent) {
        if (this.tree.getCellEditor() instanceof AdapterFactoryTreeCellEditor) {
            return;
        }
        String string = "";
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        DefaultCellEditor defaultCellEditor = (DefaultCellEditor)changeEvent.getSource();
        TreePath treePath = this.getSelectionPath();
        ProjectTreeCellRenderer projectTreeCellRenderer = null;
        if (treePath == null) {
            if (treeCellRenderer instanceof ProjectTreeCellRenderer) {
                projectTreeCellRenderer = (ProjectTreeCellRenderer)treeCellRenderer;
                projectTreeCellRenderer.setIDVisible(false);
            }
            return;
        }
        EObject eObject = this.b(this.tree.getSelectedUserObject(treePath));
        if (treeCellRenderer instanceof ProjectTreeCellRenderer) {
            projectTreeCellRenderer = (ProjectTreeCellRenderer)treeCellRenderer;
            projectTreeCellRenderer.setIDVisible(true);
        }
        ModifyNameCommand modifyNameCommand = this.getModifyNameCommand();
        string = defaultCellEditor.getCellEditorValue().toString();
        if (this.c() && this.d() && this.a(eObject)) {
            string = string.substring(string.indexOf(":") + 1);
        }
        if (!this.c() && this.d() && (string == null || string.equals(""))) {
            if (eObject instanceof NamedElement) {
                string = ((NamedElement)NamedElement.class.cast(eObject)).getName();
            }
            if (eObject instanceof UMLDiagram) {
                string = ((UMLDiagram)UMLDiagram.class.cast(eObject)).getName();
            }
        }
        modifyNameCommand.setName(string);
        modifyNameCommand.setModel(eObject);
        modifyNameCommand.setIsJustRename(true);
        modifyNameCommand.setArgumentString("FromTree");
        this.fireCommandPerformed(new CommandEvent(changeEvent.getSource(), 0, "ModifyNameFromPrj", modifyNameCommand, 0));
    }

    private EObject b(Object object) {
        if (object instanceof UMLDiagram) {
            return (EObject)UMLDiagram.class.cast(object);
        }
        if (object instanceof NamedElement) {
            return (NamedElement)object;
        }
        return this.getModelFromPresentation(object);
    }

    protected NamedElement getModelFromPresentation(Object object) {
        return null;
    }

    protected ModifyNameCommand getModifyNameCommand() {
        ModifyNameCommand modifyNameCommand = null;
        ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
        if (resourceBundleList != null) {
            try {
                String string = resourceBundleList.getString("jude.modify_name_manager");
                Class<?> clazz = Class.forName(string);
                modifyNameCommand = (ModifyNameCommand)clazz.newInstance();
            }
            catch (Exception exception) {
                e.error("error has occurred.", exception);
            }
        }
        return modifyNameCommand;
    }

    protected TreePath getSelectionPath() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        for (TreePath treePath : treePathArray) {
            if (treePath.getParentPath() == null) continue;
            return treePath;
        }
        return null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        CustomerScrollPane customerScrollPane = this.b();
        if (customerScrollPane != null) {
            this.a(mouseWheelEvent, customerScrollPane);
        } else {
            this.a(mouseWheelEvent);
        }
    }

    private void a(MouseWheelEvent mouseWheelEvent, CustomerScrollPane customerScrollPane) {
        customerScrollPane.processMouseWheelEvent(mouseWheelEvent);
    }

    private CustomerScrollPane b() {
        CContainer cContainer = this.tree.getCParent();
        while (cContainer != null) {
            Component component = cContainer.getComponent();
            if (component instanceof CustomerScrollPane) {
                return (CustomerScrollPane)component;
            }
            if (component != null) {
                cContainer = cContainer.getCParent();
                continue;
            }
            cContainer = null;
        }
        return null;
    }

    private void a(MouseWheelEvent mouseWheelEvent) {
        int n2;
        Point point = mouseWheelEvent.getPoint();
        Point point2 = new Point(point);
        point2.y = mouseWheelEvent.getScrollAmount() * mouseWheelEvent.getWheelRotation() * 20;
        Rectangle rectangle = this.tree.getVisibleRect();
        int n3 = this.tree.getClosestRowForLocation(rectangle.x, rectangle.y);
        if (n3 == (n2 = this.tree.getClosestRowForLocation(rectangle.x, rectangle.y + rectangle.height))) {
            return;
        }
        int n4 = rectangle.height / (n2 - n3);
        int n5 = 0;
        n5 = point2.y > 0 ? n2 + point2.y / n4 : n3 + point2.y / n4;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n5 > this.tree.getRowCount() - 1) {
            n5 = this.tree.getRowCount() - 1;
        }
        this.tree.scrollRowToVisible(n5);
    }

    private boolean c() {
        if (RuntimeGlobal.sysProp.getStringWithDefault("view.tree.show_name") == null) {
            return true;
        }
        return RuntimeGlobal.sysProp.getBooleanWithDefault("view.tree.show_name");
    }

    private boolean d() {
        return RuntimeGlobal.sysProp.getBooleanWithDefault("view.tree.show_id");
    }

    private boolean a(EObject eObject) {
        j j2 = new j(this);
        Boolean bl = (Boolean)j2.doSwitch(eObject);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void setTree(CTree cTree) {
        this.tree = cTree;
    }

    private boolean e() {
        return !PropertyManager.getTarget().equals("P") && !PropertyManager.getTarget().equals("E") && !PropertyManager.getTarget().equals("Y") && !PropertyManager.getTarget().equals("G") && !PropertyManager.getTarget().equals("X") && !PropertyManager.getTarget().equals("S");
    }

    public void setAvoidToConsumeMouseEvent(boolean bl) {
        this.c = bl;
    }

    public boolean isAvoidToConsumeMouseEvent() {
        return this.c;
    }

    private void a(MouseEvent mouseEvent, Diagram diagram) {
        OpenTableEditorCommand openTableEditorCommand = new OpenTableEditorCommand();
        openTableEditorCommand.setElement(diagram);
        this.fireCommandPerformed(new CommandEvent(mouseEvent.getSource(), mouseEvent.getID(), "OpenMatrixEditor", openTableEditorCommand, mouseEvent.getModifiers()));
    }

    protected void openDiagram(MouseEvent mouseEvent, DiagramViewInfo diagramViewInfo) {
        OpenDiagramEditorCommand openDiagramEditorCommand = new OpenDiagramEditorCommand();
        openDiagramEditorCommand.setDiagramViewInfo(diagramViewInfo);
        this.fireCommandPerformed(new CommandEvent(mouseEvent.getSource(), mouseEvent.getID(), "OpenDiagramEditor", openDiagramEditorCommand, mouseEvent.getModifiers()));
    }
}

