/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.mode;

import com.google.common.base.Strings;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import net.astah.emf.common.ecore.EComparators;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.golf.widget.CTree;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ISelectionProvider;
import net.astah.golf.widget.IStructuredSelection;
import net.astah.golf.widget.swing.DragAndDropTreeCellRenderer;
import net.astah.golf.widget.swing.Selections;
import net.astah.golf.widget.swing.SwingTree;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Project;
import net.astah.jomt.jcontrol.mode.DnDFiles;
import net.astah.jomt.jcontrol.mode.IDnDMode;
import net.astah.jomt.jcontrol.mode.JomtMode;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.model.command.AstahDragAndDropCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectDnDMode
extends JomtMode
implements DragGestureListener,
DragSourceListener,
DropTargetListener,
IDnDMode {
    protected JTree tree;
    protected ISelectionProvider selectionProvider;
    private DragGestureRecognizer a = null;
    protected List<?> dragModels = new ArrayList();
    private DataFlavor b;
    private static final Logger c = LoggerFactory.getLogger(ProjectDnDMode.class);
    private DragAndDropCommand d;
    private DragAndDropTreeCellRenderer e;

    public ProjectDnDMode() {
    }

    public ProjectDnDMode(CTree cTree) {
        this.setTree(cTree);
    }

    public void setTree(CTree cTree) {
        this.tree = (JTree)((SwingTree)cTree).getComponent();
        this.selectionProvider = cTree;
        this.e = new DragAndDropTreeCellRenderer(this.tree);
        this.a = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.tree, 3, this);
        new DropTarget(this.tree, 3, this);
        this.b = DataFlavor.javaFileListFlavor;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        ISelection iSelection = this.selectionProvider.getSelection();
        if (Selections.isEmpty(iSelection)) {
            return;
        }
        this.dragModels = new ArrayList<Object>(((IStructuredSelection)iSelection).toList());
        if (this.dragModels.isEmpty()) {
            return;
        }
        String string = this.a(iSelection);
        if (!Strings.isNullOrEmpty(string)) {
            try {
                dragGestureEvent.startDrag(null, new StringSelection(string), this);
            }
            catch (Exception exception) {
                c.error("error has occurred.", exception);
            }
        }
        this.dragModels.sort(EComparators.eObjectPath());
    }

    protected boolean validate(Object object, float f2) {
        if (this.d == null) {
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain(object);
            this.d = new AstahDragAndDropCommand(transactionalEditingDomain, object, f2, 2, 2, this.dragModels);
            return this.d.canExecute();
        }
        return this.d.validate(object, f2, 2, 2, this.dragModels);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(this.b)) {
            return;
        }
        c.trace("dragOver(DropTargetDragEvent)");
        Point point = dropTargetDragEvent.getLocation();
        TreePath treePath = this.tree.getClosestPathForLocation(point.x, point.y);
        Object object = treePath.getLastPathComponent();
        if (this.validate(object, this.getLocation(treePath, point))) {
            c.debug("dragOver: allowed");
            dropTargetDragEvent.acceptDrag(2);
            this.e.update(this.d.getOwner(), this.d.getFeedback());
        } else {
            c.debug("dragOver: Not allowed");
            dropTargetDragEvent.rejectDrag();
            this.e.update(null, 0);
        }
        this.a(dropTargetDragEvent);
    }

    private void a(DropTargetDragEvent dropTargetDragEvent) {
        int n2;
        Rectangle rectangle = this.tree.getVisibleRect();
        Point point = dropTargetDragEvent.getLocation();
        int n3 = this.tree.getClosestRowForLocation(rectangle.x, rectangle.y);
        c.debug("top = {}", n3);
        int n4 = this.tree.getClosestRowForLocation(rectangle.x, rectangle.y + rectangle.height);
        c.debug("bottom = {}", n4);
        int n5 = rectangle.height / (n4 - n3);
        c.debug("nodeHeight = {}", n5);
        if (point.y > rectangle.y + rectangle.height - n5) {
            n2 = n4 + 1;
            if (n2 > this.tree.getRowCount() - 1) {
                n2 = this.tree.getRowCount() - 1;
            }
            this.tree.scrollRowToVisible(n2);
        }
        if (point.y < rectangle.y + n5) {
            n2 = n3 - 1;
            if (n2 < 0) {
                n2 = 0;
            }
            this.tree.scrollRowToVisible(n2);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        if (!dropTargetDropEvent.isLocalTransfer()) {
            try {
                object3 = DnDFiles.getDropFiles(dropTargetDropEvent, this.b);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                c.error("error has occurred.", unsupportedFlavorException);
                return;
            }
            catch (IOException iOException) {
                c.error("error has occurred.", iOException);
                return;
            }
            object2 = object3.iterator();
            while (object2.hasNext()) {
                serializable = (File)object2.next();
                object = JomtGlobal.dnDModeHandler;
                if (object != null && object.isPluginFile((File)serializable)) {
                    object.installPluginFile((File)serializable);
                    continue;
                }
                if (!Project.isSupportedExtension((File)serializable)) continue;
                DnDFiles.openDroppedJudeFile(dropTargetDropEvent, (File)serializable);
                break;
            }
        }
        if (this.d == null) {
            return;
        }
        object3 = dropTargetDropEvent.getTransferable();
        if (object3.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            object2 = dropTargetDropEvent.getLocation();
            serializable = this.tree.getClosestPathForLocation(((Point)object2).x, ((Point)object2).y);
            object = ((TreePath)serializable).getLastPathComponent();
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain(object);
            if (this.validate(object, this.getLocation((TreePath)serializable, (Point)object2))) {
                try {
                    IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
                    iJomtEntityStore.beginTransaction();
                    CommandUtils.execute(transactionalEditingDomain, (Command)this.d);
                    iJomtEntityStore.commitTransaction();
                }
                catch (InterruptedException | RollbackException exception) {
                    c.error("error has occurred.", exception);
                    dropTargetDropEvent.rejectDrop();
                    return;
                }
            }
            this.tree.clearSelection();
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    protected float getLocation(TreePath treePath, Point point) {
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        return (float)(point.y - rectangle.y) / (float)rectangle.height;
    }

    @Override
    public void remove() {
        this.a.removeDragGestureListener(this);
        this.a.resetRecognizer();
        this.a = null;
        this.tree = null;
        this.dragModels = null;
        if (this.e != null) {
            this.e.dispose();
            this.e = null;
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.d = null;
        this.e.update(null, 0);
        c.trace("dragDropEnd");
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        c.trace("dragEnter");
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        c.trace("dragExit");
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        c.trace("dragOver(DragSourceDragEvent)");
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        c.trace("dropActionChanged(DragSourceDragEvent)");
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        c.trace("dragEnter");
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        c.trace("dragExit");
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        c.trace("dtopActionChanged(DropTargetDragEvent)");
    }

    public List<?> getDragModels() {
        return this.dragModels;
    }

    private String a(Object object) {
        if (object instanceof EObject) {
            return EcoreUtil.getID((EObject)object);
        }
        return String.valueOf(System.identityHashCode(object));
    }
}

