/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.mode;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import lombok.NonNull;
import net.astah.golf.draw.GCamera;
import net.astah.golf.draw.GGrid;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.util.KeyUtil;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.jmodel.StateVertexPresentation;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Vertex;

public class MoveModeUtil {
    private static boolean a() {
        if (RuntimeGlobal.sysProp != null) {
            return RuntimeGlobal.sysProp.getBooleanWithDefault("grid.move.mouse");
        }
        return false;
    }

    private static boolean b() {
        if (RuntimeGlobal.sysProp != null) {
            return RuntimeGlobal.sysProp.getBooleanWithDefault("grid.move.key");
        }
        return true;
    }

    public static boolean isFitToGrid(MouseEvent mouseEvent) {
        boolean bl = MoveModeUtil.a();
        return bl && !InputEventSupport.isControlDown(mouseEvent) || !bl && InputEventSupport.isControlDown(mouseEvent);
    }

    public static boolean isFitToGrid(KeyEvent keyEvent) {
        boolean bl = MoveModeUtil.b();
        return bl && !InputEventSupport.isControlDown(keyEvent) || !bl && InputEventSupport.isControlDown(keyEvent);
    }

    protected static Vec2d getVectorToFitGrid(Pnt2d pnt2d, GGrid gGrid) {
        double d2 = gGrid.getX();
        double d3 = gGrid.getY();
        double d4 = gGrid.getIntervalX();
        double d5 = gGrid.getIntervalY();
        double d6 = (pnt2d.x - d2) / d4;
        int n2 = MoveModeUtil.a(d6);
        double d7 = (pnt2d.y - d3) / d5;
        int n3 = MoveModeUtil.a(d7);
        return new Vec2d((double)n2 * d4 + d2 - pnt2d.x, (double)n3 * d5 + d3 - pnt2d.y);
    }

    private static int a(double d2) {
        int n2 = (int)d2;
        if (d2 > 0.0) {
            if (d2 - (double)n2 > 0.5) {
                ++n2;
            }
        } else if (d2 - (double)n2 < -0.5) {
            --n2;
        }
        return n2;
    }

    protected static Vec2d getVectorToFitGrid(KeyEvent keyEvent, Pnt2d pnt2d, GGrid gGrid) {
        double d2 = gGrid.getX();
        double d3 = gGrid.getY();
        double d4 = gGrid.getIntervalX();
        double d5 = gGrid.getIntervalY();
        if (KeyUtil.isUpKey(keyEvent)) {
            double d6 = (pnt2d.y - d3) / d5;
            int n2 = (int)d6;
            if (d6 < 0.0) {
                --n2;
            }
            if (d6 - (double)n2 < 0.1) {
                --n2;
            }
            return new Vec2d(0.0, d3 + (double)n2 * d5 - pnt2d.y);
        }
        if (KeyUtil.isDownKey(keyEvent)) {
            double d7 = (pnt2d.y - d3) / d5;
            int n3 = (int)d7;
            if (d7 > 0.0) {
                ++n3;
            }
            if (d7 - (double)n3 > -0.1) {
                ++n3;
            }
            return new Vec2d(0.0, d3 + (double)n3 * d5 - pnt2d.y);
        }
        if (KeyUtil.isLeftKey(keyEvent)) {
            double d8 = (pnt2d.x - d2) / d4;
            int n4 = (int)d8;
            if (d8 < 0.0) {
                --n4;
            }
            if (d8 - (double)n4 < 0.1) {
                --n4;
            }
            return new Vec2d(d2 + (double)n4 * d4 - pnt2d.x, 0.0);
        }
        if (KeyUtil.isRightKey(keyEvent)) {
            double d9 = (pnt2d.x - d2) / d4;
            int n5 = (int)d9;
            if (d9 > 0.0) {
                ++n5;
            }
            if (d9 - (double)n5 > -0.1) {
                ++n5;
            }
            return new Vec2d(d2 + (double)n5 * d4 - pnt2d.x, 0.0);
        }
        return new Vec2d(0.0, 0.0);
    }

    protected static double getMinVectorXtoFitGrid(double d2, @NonNull GGrid gGrid, double d3) {
        if (gGrid == null) {
            throw new NullPointerException("grid");
        }
        double d4 = gGrid.getX();
        double d5 = gGrid.getIntervalX();
        double d6 = (d2 - d4) / d5;
        double d7 = (double)MoveModeUtil.a(d6) * d5 + d4 - d2;
        if (Math.abs(d3) > Math.abs(d7)) {
            return d7;
        }
        return d3;
    }

    protected static double getMinVectorYtoFitGrid(double d2, GGrid gGrid, double d3) {
        double d4 = gGrid.getY();
        double d5 = gGrid.getIntervalY();
        double d6 = (d2 - d4) / d5;
        double d7 = (double)MoveModeUtil.a(d6) * d5 + d4 - d2;
        if (Math.abs(d3) > Math.abs(d7)) {
            return d7;
        }
        return d3;
    }

    protected static double getVectorXtoFitGrid(@NonNull Rectangle2d rectangle2d, double d2, @NonNull GGrid gGrid) {
        if (rectangle2d == null) {
            throw new NullPointerException("rect");
        }
        if (gGrid == null) {
            throw new NullPointerException("grid");
        }
        double d3 = MoveModeUtil.getMinVectorXtoFitGrid(rectangle2d.getX() + d2, gGrid, 10000.0);
        d3 = MoveModeUtil.getMinVectorXtoFitGrid(rectangle2d.getX() + rectangle2d.getWidth() / 2.0 + d2, gGrid, d3);
        d3 = MoveModeUtil.getMinVectorXtoFitGrid(rectangle2d.getX() + rectangle2d.getWidth() + d2, gGrid, d3);
        return d3;
    }

    protected static double getVectorYtoFitGrid(Rectangle2d rectangle2d, double d2, GGrid gGrid) {
        double d3 = MoveModeUtil.getMinVectorYtoFitGrid(rectangle2d.getY() + d2, gGrid, 10000.0);
        d3 = MoveModeUtil.getMinVectorYtoFitGrid(rectangle2d.getY() + rectangle2d.getHeight() / 2.0 + d2, gGrid, d3);
        d3 = MoveModeUtil.getMinVectorYtoFitGrid(rectangle2d.getY() + rectangle2d.getHeight() + d2, gGrid, d3);
        return d3;
    }

    protected static boolean isMovingAllowed(StateVertexPresentation stateVertexPresentation, Namespace namespace) {
        return MoveModeUtil.isMovingAllowed(stateVertexPresentation, namespace, false);
    }

    public static boolean isMovingAllowed(StateVertexPresentation stateVertexPresentation, Namespace namespace, boolean bl) {
        if (namespace instanceof State) {
            return !((State)namespace).isSubmachineState();
        }
        if (!(namespace instanceof Region)) {
            return false;
        }
        Region region = (Region)namespace;
        Vertex vertex = (Vertex)stateVertexPresentation.getModel();
        if (namespace == vertex.getContainer()) {
            return true;
        }
        return true;
    }

    public static MouseEvent createMouseEvent(KeyEvent keyEvent, GCamera gCamera, Pnt2d pnt2d) {
        Point point = new Point(gCamera.toDeviceCoordX(pnt2d.x), gCamera.toDeviceCoordY(pnt2d.y));
        boolean bl = MoveModeUtil.a();
        if (GolfUtilities.isMacOS()) {
            return new MouseEvent((Component)keyEvent.getSource(), keyEvent.getID(), keyEvent.getWhen(), bl ? 272 : 16, point.x, point.y, 1, false);
        }
        return new MouseEvent((Component)keyEvent.getSource(), keyEvent.getID(), keyEvent.getWhen(), bl ? 144 : 16, point.x, point.y, 1, false);
    }
}

