/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.mode;

import java.awt.Point;
import java.awt.event.MouseEvent;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.jomt.jcontrol.mode.MapMode;
import net.astah.jomt.jview.MapView;

public class MapMoveMode
extends MapMode {
    protected Point start;
    protected Point end;
    protected GRect dragTempNode;

    public MapMoveMode(MapView mapView) {
        super(mapView);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.a(mouseEvent)) {
            return;
        }
        this.start = new Point(mouseEvent.getX(), mouseEvent.getY());
        GRect gRect = this.mapView.getDiagramFrame();
        this.dragTempNode = new GRect((Rectangle2d)gRect.getShape(0));
        this.dragTempNode.setColorNo((byte)4);
        this.dragTempNode.setRimWidth(4);
        this.mapView.getDiagramEditorFrameScene().getTree().addTempNode(this.dragTempNode);
        this.end = this.start;
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.a(mouseEvent)) {
            return;
        }
        this.a();
        mouseEvent.consume();
    }

    private void a() {
        if (this.dragTempNode != null) {
            this.mapView.getDiagramEditorFrameScene().getTree().removeTempNode(this.dragTempNode);
        }
        this.dragTempNode = null;
        this.start = null;
        this.end = null;
    }

    private boolean b() {
        return this.dragTempNode != null && this.start != null && this.end != null;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.a(mouseEvent)) {
            return;
        }
        if (!this.b()) {
            this.a();
            mouseEvent.consume();
            return;
        }
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Vec2d vec2d = this.a(this.end, point);
        this.updateDiagramCamera(vec2d);
        this.end = point;
        mouseEvent.consume();
    }

    private boolean a(MouseEvent mouseEvent) {
        if (this.mapView.getMapMouseOperation()) {
            return InputEventSupport.isLeftMouseButton(mouseEvent) && this.mapView.getDiagramEditor() != null;
        }
        return InputEventSupport.isRightMouseButton(mouseEvent) && this.mapView.getDiagramEditor() != null;
    }

    protected void updateDiagramFrame(Vec2d vec2d) {
        double d2 = this.dragTempNode.getX() + vec2d.x;
        double d3 = this.dragTempNode.getY() + vec2d.y;
        this.dragTempNode.setPoint(d2, d3);
    }

    protected void updateDiagramCamera(Vec2d vec2d) {
        this.mapView.getDiagramEditor().pan(vec2d);
        this.mapView.getDiagramEditor().repaintCanvas();
    }

    private Vec2d a(Point point, Point point2) {
        Vec2d vec2d = new Vec2d((double)(point2.x - point.x) / this.camera.getScale(), (double)(point2.y - point.y) / this.camera.getScale());
        return vec2d;
    }
}

