/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.mode;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.astah.jmodel.Project;
import net.astah.jomt.jcontrol.mode.DnDFiles;
import net.astah.jomt.jcontrol.mode.DnDModeHandler;
import net.astah.jomt.jcontrol.mode.IDnDMode;
import net.astah.jomt.jcontrol.mode.JomtMode;
import net.astah.jomt.jsystem.JomtGlobal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDnDMode
extends JomtMode
implements DropTargetListener,
IDnDMode {
    private DataFlavor a = DataFlavor.javaFileListFlavor;
    private static final Logger b = LoggerFactory.getLogger(FileDnDMode.class);

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        List<File> list;
        if (dropTargetDropEvent.isLocalTransfer()) {
            dropTargetDropEvent.dropComplete(true);
            return;
        }
        try {
            list = DnDFiles.getDropFiles(dropTargetDropEvent, this.a);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            b.error("error has occurred.", unsupportedFlavorException);
            return;
        }
        catch (IOException iOException) {
            b.error("error has occurred.", iOException);
            return;
        }
        for (File file : list) {
            if (file == null) continue;
            if (Project.isSupportedExtension(file)) {
                DnDFiles.openDroppedJudeFile(dropTargetDropEvent, file);
                break;
            }
            DnDModeHandler dnDModeHandler = JomtGlobal.dnDModeHandler;
            if (dnDModeHandler == null || !dnDModeHandler.isPluginFile(file)) continue;
            dnDModeHandler.installPluginFile(file);
            break;
        }
    }

    public void setComponent(Component component) {
        DropTarget dropTarget = new DropTarget(component, 1, this);
        dropTarget.setActive(true);
    }
}

