/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.mode;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.astah.golf.control.CommandManager;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.jmodel.Project;
import net.astah.jmodel.RectPresentation;
import net.astah.jomt.jcontrol.DnDFileCommand;
import net.astah.jomt.jcontrol.OpenPrjSeqCommand;
import net.astah.jomt.jsystem.PropertyManager;

public class DnDFiles {
    public static void openDroppedJudeFile(DropTargetDropEvent dropTargetDropEvent, DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        File file = DnDFiles.a(dropTargetDropEvent, dataFlavor);
        DnDFiles.openDroppedJudeFile(dropTargetDropEvent, file);
    }

    public static void openDroppedJudeFile(DropTargetDropEvent dropTargetDropEvent, File file) {
        if (file == null) {
            dropTargetDropEvent.dropComplete(true);
            return;
        }
        DnDFiles.fireOpenPrjSeqCommand(file);
        dropTargetDropEvent.dropComplete(true);
    }

    public static List<File> getDropFiles(DropTargetDropEvent dropTargetDropEvent, DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        dropTargetDropEvent.acceptDrop(1);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (!DnDFiles.a(transferable.getTransferDataFlavors(), dataFlavor)) {
            return new ArrayList<File>();
        }
        List list = (List)transferable.getTransferData(dataFlavor);
        if (list == null) {
            return new ArrayList<File>();
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Object e2 : list) {
            if (e2 == null || !(e2 instanceof File)) continue;
            arrayList.add((File)File.class.cast(e2));
        }
        return arrayList;
    }

    public static boolean areValidDropFiles(DropTargetDropEvent dropTargetDropEvent, List<File> list) {
        return list != null && !list.isEmpty() && list.size() <= 1;
    }

    public static void fireDnDFileCommand(DropTargetDropEvent dropTargetDropEvent, File file, RectPresentation rectPresentation, Pnt2d pnt2d) {
        DnDFileCommand dnDFileCommand = new DnDFileCommand();
        dnDFileCommand.setDropFile(file);
        dnDFileCommand.setLocation(pnt2d);
        dnDFileCommand.setCoveredPresentation(rectPresentation);
        CommandManager.instance().callCommand(dnDFileCommand);
        dropTargetDropEvent.dropComplete(true);
    }

    public static void fireOpenPrjSeqCommand(File file) {
        OpenPrjSeqCommand openPrjSeqCommand = DnDFiles.a();
        openPrjSeqCommand.setArgumentString(file.getAbsolutePath());
        CommandManager.instance().callCommand(openPrjSeqCommand);
    }

    private static OpenPrjSeqCommand a() {
        try {
            String string = PropertyManager.getJudeResourceBundle().getString("jude.open_prj_seq");
            Class<?> clazz = Class.forName(string);
            return (OpenPrjSeqCommand)clazz.newInstance();
        }
        catch (Exception exception) {
            return new OpenPrjSeqCommand();
        }
    }

    private static File a(DropTargetDropEvent dropTargetDropEvent, DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        List<File> list = DnDFiles.getDropFiles(dropTargetDropEvent, dataFlavor);
        return DnDFiles.a(list);
    }

    private static File a(List<File> list) {
        if (list == null) {
            return null;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            File file = list.get(i2);
            if (!Project.isSupportedExtension(file)) continue;
            return file;
        }
        return null;
    }

    private static boolean a(DataFlavor[] dataFlavorArray, DataFlavor dataFlavor) {
        for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
            if (!dataFlavor.equals(dataFlavorArray[i2])) continue;
            return true;
        }
        return false;
    }
}

