/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.mode;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.ImageIcon;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.draw.GCamera;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.golf.widget.swing.SwingCursor;
import net.astah.jomt.jcontrol.ZoomInViewCommand;
import net.astah.jomt.jcontrol.ZoomOutViewCommand;
import net.astah.jomt.jcontrol.ZoomViewCommand;
import net.astah.jomt.jcontrol.mode.DiagramMode;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.IconResource;

public class DiagramZoomMode
extends DiagramMode {
    private int a = 400;
    private double b = 1.0;
    private Point c = null;
    private Vec2d d = new Vec2d();
    private Point e = new Point();

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            this.c = this.e;
            this.c.setLocation(mouseEvent.getX(), mouseEvent.getY());
            this.b = this.de.getCamera().getScale();
            this.a = mouseEvent.getY();
        }
        this.editingNodeModify(mouseEvent, true);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            if (this.a(this.de)) {
                this.d();
            }
            this.c = null;
        } else if (this.a(this.de)) {
            this.d();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        Point point = mouseWheelEvent.getPoint();
        int n2 = point.x;
        int n3 = point.y;
        if (Math.abs(mouseWheelEvent.getPreciseWheelRotation()) <= 0.001) {
            return;
        }
        if (!InputEventSupport.isControlDown(mouseWheelEvent)) {
            int n4 = mouseWheelEvent.getScrollAmount() * mouseWheelEvent.getWheelRotation() * 20;
            if (!mouseWheelEvent.isShiftDown()) {
                n3 = point.y - n4;
                this.pan(this.de.getCamera(), n2, n3, point.x, point.y, true);
            } else {
                n2 = point.x - n4;
                this.pan(this.de.getCamera(), n2, n3, point.x, point.y, true);
            }
            this.canvas.repaint(() -> {
                this.canvas.clear();
                this.canvas.draw();
            });
        } else {
            this.a(mouseWheelEvent);
        }
    }

    private void a(MouseWheelEvent mouseWheelEvent) {
        this.c();
        ZoomViewCommand zoomViewCommand = null;
        zoomViewCommand = mouseWheelEvent.getWheelRotation() > 0 ? (this.a() ? new ZoomInViewCommand() : new ZoomOutViewCommand()) : (this.a() ? new ZoomOutViewCommand() : new ZoomInViewCommand());
        zoomViewCommand.setDatumPoint(mouseWheelEvent.getPoint());
        for (int i2 = 0; i2 < Math.abs(mouseWheelEvent.getScrollAmount() * mouseWheelEvent.getWheelRotation()); ++i2) {
            this.fireCommandPerformed(new CommandEvent((Object)this.de.getCanvas(), 0, null, zoomViewCommand, 0));
        }
    }

    private boolean a() {
        return RuntimeGlobal.sysProp.getBooleanWithDefault("basic.editor.zoom_operation_as_ie");
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (!mouseEvent.isControlDown()) {
            this.b();
            if (this.c == null) {
                return;
            }
            this.pan(this.de.getCamera(), n2, n3, this.c.x, this.c.y, false);
            this.b = this.de.getCamera().getScale();
            this.a = n3;
        } else {
            this.zoomByDrag(this.de.getCamera(), n2, n3, this.c.x, this.c.y);
        }
        this.canvas.repaint(() -> {
            this.canvas.clear();
            this.canvas.draw();
        });
        this.c.setLocation(n2, n3);
        mouseEvent.consume();
    }

    protected void pan(GCamera gCamera, int n2, int n3, int n4, int n5, boolean bl) {
        if (n4 == n2 && n5 == n3) {
            return;
        }
        this.d.x = (double)(n4 - n2) / gCamera.getScale();
        this.d.y = (double)(n5 - n3) / gCamera.getScale();
        if (bl) {
            this.de.panWithLimited(this.d);
        } else {
            this.de.pan(this.d);
        }
    }

    protected void zoomByDrag(GCamera gCamera, int n2, int n3, int n4, int n5) {
        this.c();
        double d2 = 200.0;
        double d3 = -(n5 - this.a);
        double d4 = this.b * Math.pow(2.0, d3 / 200.0);
        this.de.zoom(d4, true);
        this.canvas.repaint(() -> {
            this.canvas.clear();
            this.canvas.draw();
        });
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 17 && this.a(this.de)) {
            this.d();
        }
    }

    private boolean a(DiagramEditor diagramEditor) {
        int n2 = ((SwingCursor)diagramEditor.getComponent().getCCursor()).getComponent().getType();
        return n2 != 0 && n2 != 3;
    }

    private void b() {
        SwingComponent swingComponent = (SwingComponent)this.de.getComponent();
        swingComponent.setCCursor(new SwingCursor(Cursor.getPredefinedCursor(13)));
    }

    private void c() {
        SwingComponent swingComponent = (SwingComponent)this.de.getComponent();
        Cursor cursor = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getBestCursorSize(0, 0);
        if (dimension.width == 32) {
            cursor = toolkit.createCustomCursor(((ImageIcon)IconResource.getIcon("projectview.icon.cursor_zoom_icon_32")).getImage(), new Point(0, 0), "zoom");
        } else if (dimension.width == 64) {
            cursor = toolkit.createCustomCursor(((ImageIcon)IconResource.getIcon("projectview.icon.cursor_zoom_icon_64")).getImage(), new Point(0, 0), "zoom");
        }
        if (cursor == null) {
            swingComponent.setCCursor(new SwingCursor(Cursor.getPredefinedCursor(0)));
        } else {
            swingComponent.setCCursor(new SwingCursor(cursor));
        }
    }

    private void d() {
        SwingComponent swingComponent = (SwingComponent)this.de.getComponent();
        swingComponent.setCCursor(new SwingCursor(Cursor.getPredefinedCursor(0)));
    }
}

