/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.mode;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dg.DGFactory;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Rectangle;
import net.astah.dd.dg.Style;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.draw.GPolygon;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.jmodel.JmodelFactory;
import net.astah.jmodel.PresentationUtil;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jcontrol.CreateRectCommand;
import net.astah.jomt.jcontrol.mode.DiagramMode;
import net.astah.jomt.jcontrol.mode.DrawingRubberSupport;
import net.astah.notation.GraphicalShape;
import net.astah.notation.editor.IItemEditorFactory;
import net.astah.notation.resource.NotationResources;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class CreateRectMode
extends DiagramMode {
    protected GPolygon rect;
    protected Pnt2d start;
    private Pnt2d[] a = new Pnt2d[4];
    protected boolean first = true;
    protected boolean mouseMoved = false;

    public CreateRectMode() {
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2] = new Pnt2d();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    protected RectPresentation getPresentation() {
        RectPresentation rectPresentation = JmodelFactory.eINSTANCE.createRectPresentation();
        rectPresentation.setBodyColorWithDefault();
        return rectPresentation;
    }

    protected GraphicalShape createShape() {
        IItemEditorFactory iItemEditorFactory = ItemProviders.adapt(this.getDiagram(), IItemEditorFactory.class);
        EClass eClass = iItemEditorFactory.getGraphicalShapeClass();
        if (eClass == null) {
            throw new UnsupportedOperationException("\u672a\u5bfe\u5fdc\u306e\u56f3");
        }
        return (GraphicalShape)EcoreUtil.create(eClass);
    }

    protected GraphicalShape prepareShape(Bounds bounds) {
        GraphicalElement graphicalElement = this.createFigure(bounds);
        GraphicalShape graphicalShape = this.createShape();
        graphicalShape.setFigure(graphicalElement);
        return graphicalShape;
    }

    protected GraphicalElement createFigure(Bounds bounds) {
        Style style = NotationResources.getLibraryStyle(this.getDiagram(), "Rectangle");
        Rectangle rectangle = DGFactory.eINSTANCE.createRectangle();
        rectangle.setBounds(bounds);
        rectangle.getSharedStyles().add(style);
        return rectangle;
    }

    protected CreateRectCommand getCommand() {
        return new CreateRectCommand();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!InputEventSupport.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (this.first || !this.mouseMoved) {
            mouseEvent.consume();
            return;
        }
        this.canvas.unselect();
        if (InputEventSupport.isLeftMouseButton(mouseEvent)) {
            double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
            double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
            Rectangle2d rectangle2d = new Rectangle2d(this.start.x, this.start.y, 0.0, 0.0);
            rectangle2d.add(d2, d3);
            rectangle2d.add(rectangle2d.getX() + 20.0, rectangle2d.getY() + 20.0);
            CreateRectCommand createRectCommand = this.getCommand();
            if (this.getDiagram() instanceof UMLDiagram) {
                RectPresentation rectPresentation = this.getPresentation();
                rectPresentation.setLocation(new Pnt2d(rectangle2d.getX(), rectangle2d.getY()));
                rectPresentation.setWidth(rectangle2d.getWidth());
                rectPresentation.setHeight(rectangle2d.getHeight());
                int n2 = PresentationUtil.getMinDepth(this.de.getDiagram());
                rectPresentation.setDepth(n2 - 1);
                createRectCommand.setPresentation(rectPresentation);
            } else {
                createRectCommand.setPresentation(this.prepareShape(Geometries.toBounds(rectangle2d)));
            }
            createRectCommand.setDiagram(this.getDiagram());
            createRectCommand.setShiftPressedState(mouseEvent.isShiftDown());
            this.fireCommandPerformed(new CommandEvent(mouseEvent.getSource(), mouseEvent.getID(), "CreateRect", createRectCommand, mouseEvent.getModifiers()));
            mouseEvent.consume();
        }
        this.a();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!InputEventSupport.isLeftMouseButton(mouseEvent)) {
            return;
        }
        mouseEvent.consume();
        if (!this.first) {
            return;
        }
        this.first = false;
        this.de.hidePopupMenus();
        this.rect = new GPolygon();
        this.rect.setColorNo((byte)3);
        this.scene.addTempNode(this.rect);
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        this.start = new Pnt2d(d2, d3);
        this.a[0].set(this.start);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        mouseEvent.consume();
        if (this.first) {
            return;
        }
        this.mouseMoved = true;
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        this.a[1].set(d2, this.start.y);
        this.a[2].set(d2, d3);
        this.a[3].set(this.start.x, d3);
        DrawingRubberSupport.clearOldRubber(this.canvas);
        this.autoScroll(mouseEvent);
        this.rect.setPoints(this.a);
        DrawingRubberSupport.drawNewRubber(this.canvas);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.a();
        }
    }

    private void a() {
        this.scene.removeTempNode(this.rect);
        this.canvas.clear();
        this.canvas.draw();
        this.canvas.repaint();
        this.first = true;
        this.mouseMoved = false;
    }
}

