/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.mode;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.ComponentPresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.PresentationUtil;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.UMLCompositeStructureDiagram;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jcontrol.CreatePropertyCommand;
import net.astah.jomt.jcontrol.mode.DiagramMode;

public abstract class CreatePropertyMode
extends DiagramMode {
    protected RectPresentation parent = null;
    protected GRect containerRect = new GRect(0.0, 0.0, 0.0, 0.0);

    public CreatePropertyMode() {
        this.containerRect.setColorNo((byte)3);
        this.containerRect.setRimWidth(2);
        this.containerRect.setBackgroundNo((byte)0);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!InputEventSupport.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.editingNodeModify(mouseEvent, true);
        this.canvas.unselect();
        CreatePropertyCommand createPropertyCommand = this.createCommand();
        LabelPresentation labelPresentation = this.createPresentation();
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        Pnt2d pnt2d = new Pnt2d(d2, d3);
        this.setupPresentation(labelPresentation, pnt2d);
        if (!this.isCorrectDiagramAndParent()) {
            return;
        }
        if (!this.isValidParent()) {
            return;
        }
        int n2 = this.parent.getDepth();
        labelPresentation.setDepth(n2 - 1);
        createPropertyCommand.setParent(this.parent);
        createPropertyCommand.setPresentation(labelPresentation);
        createPropertyCommand.setDiagram((UMLDiagram)this.getDiagram());
        createPropertyCommand.setShiftPressedState(mouseEvent.isShiftDown());
        this.fireCommandPerformed(new CommandEvent(mouseEvent.getSource(), mouseEvent.getID(), this.getCommandName(), createPropertyCommand, mouseEvent.getModifiers()));
        mouseEvent.consume();
        this.scene.removeAllTempNodes();
        if (mouseEvent.isShiftDown()) {
            this.parent = null;
            this.containerRect.setRect(0.0, 0.0, 0.0, 0.0);
            this.scene.addTempNode(this.containerRect);
        }
    }

    protected boolean isValidParent() {
        return 1 == ((ClassifierPresentation)this.parent).getClassType() || this.parent instanceof ComponentPresentation;
    }

    protected boolean isCorrectDiagramAndParent() {
        Diagram diagram = this.de.getDiagram();
        boolean bl = diagram instanceof UMLCompositeStructureDiagram;
        boolean bl2 = false;
        return (bl || bl2) && this.parent instanceof ClassifierPresentation;
    }

    protected void setupPresentation(LabelPresentation labelPresentation, Pnt2d pnt2d) {
        labelPresentation.setLocation(pnt2d);
        labelPresentation.setDepth(PresentationUtil.getMinDepth(this.de.getDiagram()) - 1);
    }

    protected abstract CreatePropertyCommand createCommand();

    protected abstract LabelPresentation createPresentation();

    protected abstract String getCommandName();

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.scene.addTempNode(this.containerRect);
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.scene.removeTempNode(this.containerRect);
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        Pnt2d pnt2d = new Pnt2d(d2, d3);
        this.parent = this.setTempRectOfEnterContainer(this.parent, this.containerRect, pnt2d);
        mouseEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    protected boolean isCompositePatternLegal(DiagramElement diagramElement) {
        return diagramElement instanceof ComponentPresentation || diagramElement instanceof ClassifierPresentation && 1 == ((ClassifierPresentation)diagramElement).getClassType();
    }
}

