/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.mode;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.jmodel.JmodelFactory;
import net.astah.jmodel.PackagePresentation;
import net.astah.jmodel.PresentationUtil;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jcontrol.CreatePackageCommand;
import net.astah.jomt.jcontrol.mode.DiagramMode;
import net.astah.jomt.jviewElement.CJomtTextNode;

public class CreatePackageMode
extends DiagramMode {
    protected PackagePresentation parent = null;
    protected GRect containerRect = new GRect(0.0, 0.0, 0.0, 0.0);

    public CreatePackageMode() {
        this.containerRect.setColorNo((byte)3);
        this.containerRect.setRimWidth(2);
        this.containerRect.setBackgroundNo((byte)0);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!InputEventSupport.isLeftMouseButton(mouseEvent)) {
            return;
        }
        CJomtTextNode cJomtTextNode = this.de.getEditingNode();
        if (cJomtTextNode != null) {
            this.fireEditingNodeModifyCommand(mouseEvent, cJomtTextNode);
            cJomtTextNode.setComponentFocus(false);
            this.canvas.requestFocus();
        }
        CreatePackageCommand createPackageCommand = this.createCommand();
        PackagePresentation packagePresentation = this.createPresentation();
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        Pnt2d pnt2d = new Pnt2d(d2, d3);
        this.setPresentationSize(packagePresentation);
        packagePresentation.setLocation(pnt2d);
        UMLDiagram uMLDiagram = (UMLDiagram)this.getDiagram();
        int n2 = PresentationUtil.getMinDepth(uMLDiagram);
        packagePresentation.setDepth(n2 - 1);
        createPackageCommand.setParent(this.parent);
        this.canvas.unselect();
        createPackageCommand.setPresentation(packagePresentation);
        createPackageCommand.setDiagram(uMLDiagram);
        createPackageCommand.setShiftPressedState(mouseEvent.isShiftDown());
        this.fireCommandPerformed(new CommandEvent(mouseEvent.getSource(), mouseEvent.getID(), this.getCommandName(), createPackageCommand, mouseEvent.getModifiers()));
        mouseEvent.consume();
        this.scene.removeAllTempNodes();
        if (mouseEvent.isShiftDown()) {
            this.parent = null;
            this.containerRect.setRect(0.0, 0.0, 0.0, 0.0);
            this.scene.addTempNode(this.containerRect);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.scene.addTempNode(this.containerRect);
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.scene.removeTempNode(this.containerRect);
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        Pnt2d pnt2d = new Pnt2d(d2, d3);
        this.parent = (PackagePresentation)this.setTempRectOfEnterContainer(this.parent, this.containerRect, pnt2d);
        mouseEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    protected CreatePackageCommand createCommand() {
        return new CreatePackageCommand();
    }

    protected PackagePresentation createPresentation() {
        PackagePresentation packagePresentation = JmodelFactory.eINSTANCE.createPackagePresentation();
        if (RuntimeGlobal.sysProp != null) {
            boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("basic.package.default_name_in_body");
            packagePresentation.setWithinBodyName(bl);
        }
        return packagePresentation;
    }

    protected String getCommandName() {
        return "CreatePakcage";
    }

    protected void setPresentationSize(PackagePresentation packagePresentation) {
        packagePresentation.setDoAutoResize(true);
    }

    @Override
    protected boolean isCompositePatternLegal(DiagramElement diagramElement) {
        return diagramElement instanceof PackagePresentation;
    }
}

