/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.mode;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.draw.GArrow;
import net.astah.golf.draw.GCurve;
import net.astah.golf.draw.GNode;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.util.Geometry;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.jmodel.CommunicationMessagePresentation;
import net.astah.jmodel.ConnectorPresentation;
import net.astah.jmodel.JmodelFactory;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.PresentationUtil;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jcontrol.CreateMessageCLCommand;
import net.astah.jomt.jcontrol.mode.DiagramMode;
import net.astah.jomt.jutil.IconButtonUtil;

public class CreateMessageCLMode
extends DiagramMode {
    protected boolean direction = true;
    private GArrow a;
    protected Pnt2d start = null;
    protected Pnt2d end = null;
    protected ConnectorPresentation linkPs = null;
    protected CommunicationMessagePresentation messagePs = null;

    protected void clear() {
        if (this.a != null) {
            this.scene.removeTempNode(this.a);
            this.a = null;
        }
        this.linkPs = null;
        this.start = null;
    }

    protected void createRubber() {
        this.a = new GArrow();
        this.a.setColorNo((byte)4);
        this.a.setBackgroundNo((byte)0);
        this.a.setRimPattern((byte)0);
        this.a.setRimPatternScale(5);
        this.scene.addTempNode(this.a);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.start == null || this.linkPs == null || this.linkPs.getOuterPoints() == null) {
            mouseEvent.consume();
            return;
        }
        this.a.setPoints(this.getRubberPoints(mouseEvent));
        this.canvas.repaintSync();
        this.canvas.drawTempFront();
        mouseEvent.consume();
    }

    protected Pnt2d[] getRubberPoints(MouseEvent mouseEvent) {
        double d2;
        double d3 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d4 = this.camera.toWorldCoordY(mouseEvent.getY());
        this.direction = this.b(new Pnt2d(d3, d4));
        if (this.direction) {
            d2 = 20.0;
            this.a.setType(0, 0);
            this.a.setType(1, 1);
        } else {
            d2 = -20.0;
            this.a.setType(0, 1);
            this.a.setType(1, 0);
        }
        return this.messagePs.getNewPoints(this.linkPs, this.start, d2);
    }

    public void fireCommand(MouseEvent mouseEvent) {
        int n2 = PresentationUtil.getMinDepth(this.de.getDiagram());
        this.messagePs.setDepth(n2 - 1);
        CreateMessageCLCommand createMessageCLCommand = new CreateMessageCLCommand();
        createMessageCLCommand.setPresentation(this.messagePs);
        createMessageCLCommand.setLinkPresentation(this.linkPs);
        createMessageCLCommand.setDiagram((UMLDiagram)this.de.getDiagram());
        this.messagePs.setLocation(this.start);
        if (IconButtonUtil.getMessageDirection() != IconButtonUtil.MessageDirection.INVALID) {
            createMessageCLCommand.setDirection(IconButtonUtil.getMessageDirection() == IconButtonUtil.MessageDirection.RIGHT);
        } else {
            createMessageCLCommand.setDirection(this.direction);
        }
        createMessageCLCommand.setShiftPressedState(mouseEvent.isShiftDown());
        this.fireCommandPerformed(new CommandEvent(mouseEvent.getSource(), mouseEvent.getID(), "CreateMessageCLCommand", createMessageCLCommand, mouseEvent.getModifiers()));
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            this.clear();
            this.canvas.repaint();
            return;
        }
        if (!InputEventSupport.isLeftMouseButton(mouseEvent)) {
            return;
        }
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        Pnt2d pnt2d = new Pnt2d(d2, d3);
        this.editingNodeModify(mouseEvent, true);
        if (this.start == null) {
            List<GNode> list = this.getPickedNodes(mouseEvent, 1);
            if (list == null || list.isEmpty()) {
                mouseEvent.consume();
                return;
            }
            this.a(list);
            if (list.isEmpty()) {
                mouseEvent.consume();
                return;
            }
            JomtPresentation jomtPresentation = CreateMessageCLMode.getFrontOverlapPresentation(list);
            if (!(jomtPresentation instanceof ConnectorPresentation)) {
                mouseEvent.consume();
                return;
            }
            this.linkPs = (ConnectorPresentation)jomtPresentation;
            this.start = this.linkPs.isCurve() ? this.c(pnt2d) : pnt2d;
            this.createRubber();
            this.messagePs = JmodelFactory.eINSTANCE.createCommunicationMessagePresentation();
            this.messagePs.setPointRatio(this.a(this.start));
            this.messagePs.setStereotypeVisibility(RuntimeGlobal.sysProp.getBooleanWithDefault("uml.message_collaboration.stereotype_visibility"));
        } else {
            this.end = pnt2d;
            this.fireCommand(mouseEvent);
            this.clear();
            this.canvas.unselect();
            this.canvas.repaint();
        }
        mouseEvent.consume();
    }

    private void a(List<GNode> list) {
        ArrayList<GNode> arrayList = new ArrayList<GNode>();
        for (GNode gNode : list) {
            UserObject userObject = (UserObject)gNode.getModel();
            if (!(userObject.getPresentation() instanceof ConnectorPresentation)) continue;
            ConnectorPresentation connectorPresentation = (ConnectorPresentation)userObject.getPresentation();
            if (connectorPresentation.isCurve()) {
                if (gNode instanceof GCurve) continue;
                arrayList.add(gNode);
                continue;
            }
            if (!(gNode instanceof GCurve)) continue;
            arrayList.add(gNode);
        }
        list.removeAll(arrayList);
    }

    private double a(Pnt2d pnt2d) {
        double d2 = 0.0;
        Pnt2d[] pnt2dArray = this.linkPs.getOuterPoints().toArray(new Pnt2d[0]);
        int n2 = Geometry.getClickedLineIndex(pnt2d, pnt2dArray);
        if (n2 == -1) {
            return 0.0;
        }
        if (pnt2dArray != null) {
            int n3;
            double d3 = 0.0;
            double d4 = 0.0;
            for (n3 = 0; n3 < pnt2dArray.length - 1; ++n3) {
                d3 += pnt2dArray[n3].distance(pnt2dArray[n3 + 1]);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                d4 += pnt2dArray[n3].distance(pnt2dArray[n3 + 1]);
            }
            d2 = (d4 += pnt2dArray[n2].distance(pnt2d)) / d3;
        }
        return d2;
    }

    private double a() {
        Pnt2d[] pnt2dArray = this.linkPs.getOuterPoints().toArray(new Pnt2d[0]);
        int n2 = Geometry.getClickedLineIndex(this.start, pnt2dArray);
        if (n2 == -1) {
            return 0.0;
        }
        return pnt2dArray[n2].angle(pnt2dArray[n2 + 1]);
    }

    private boolean b(Pnt2d pnt2d) {
        double d2;
        double d3 = this.a();
        double d4 = Math.cos(-d3);
        double d5 = Math.sin(-d3);
        double d6 = pnt2d.getX();
        return (d6 - this.start.x) * d4 - ((d2 = pnt2d.getY()) - this.start.y) * d5 > 0.0;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        this.mouseMoved(mouseEvent);
    }

    private Pnt2d c(Pnt2d pnt2d) {
        Pnt2d[] pnt2dArray = this.linkPs.getOuterPoints().toArray(new Pnt2d[0]);
        int n2 = Geometry.getClickedCurveLineIndex(pnt2d, pnt2dArray);
        double d2 = pnt2dArray[n2].distance(pnt2d) / (pnt2dArray[n2].distance(pnt2d) + pnt2dArray[n2 + 1].distance(pnt2d));
        Pnt2d pnt2d2 = new Pnt2d();
        pnt2d2.interpolate(pnt2dArray[n2], pnt2dArray[n2 + 1], d2);
        return pnt2d2;
    }
}

