/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.mode;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.jmodel.PackagePresentation;
import net.astah.jomt.jcontrol.CreateMMBoundaryCommand;
import net.astah.jomt.jcontrol.mode.MMDiagramMode;
import net.astah.jomt.jviewElement.CJomtTextNode;
import net.astah.notation.mindmap.MMBoundaryShape;
import net.astah.notation.mindmap.MMNotationFactory;
import net.astah.notation.mindmap.MMTopicShape;

public class CreateMMBoundaryMode
extends MMDiagramMode {
    protected MMTopicShape parent;
    protected GRect containerRect = new GRect(0.0, 0.0, 0.0, 0.0);

    public CreateMMBoundaryMode() {
        this.containerRect.setColorNo((byte)3);
        this.containerRect.setRimWidth(2);
        this.containerRect.setBackgroundNo((byte)0);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!InputEventSupport.isLeftMouseButton(mouseEvent)) {
            return;
        }
        CJomtTextNode cJomtTextNode = this.de.getEditingNode();
        if (cJomtTextNode != null) {
            this.fireEditingNodeModifyCommand(mouseEvent, cJomtTextNode);
            cJomtTextNode.setComponentFocus(false);
            this.canvas.requestFocus();
        }
        if (this.parent == null) {
            if (!InputEventSupport.isLeftMouseButton(mouseEvent)) {
                return;
            }
            mouseEvent.consume();
            return;
        }
        CreateMMBoundaryCommand createMMBoundaryCommand = new CreateMMBoundaryCommand();
        this.canvas.unselect();
        createMMBoundaryCommand.setTopicShape(this.parent);
        createMMBoundaryCommand.setShiftPressedState(mouseEvent.isShiftDown());
        this.fireCommandPerformed(new CommandEvent(mouseEvent.getSource(), mouseEvent.getID(), this.getCommandName(), createMMBoundaryCommand, mouseEvent.getModifiers()));
        mouseEvent.consume();
        this.scene.removeAllTempNodes();
        if (mouseEvent.isShiftDown()) {
            this.parent = null;
            this.containerRect.setRect(0.0, 0.0, 0.0, 0.0);
            this.scene.addTempNode(this.containerRect);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.scene.addTempNode(this.containerRect);
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.scene.removeTempNode(this.containerRect);
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        Pnt2d pnt2d = new Pnt2d(d2, d3);
        this.parent = this.setTempRectOfEnterTopic(this.parent, this.containerRect, pnt2d);
        mouseEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    protected MMBoundaryShape createPresentation() {
        return MMNotationFactory.eINSTANCE.createMMBoundaryShape();
    }

    protected String getCommandName() {
        return "CreateMMBoundary";
    }

    protected void setPresentationSize(PackagePresentation packagePresentation) {
        packagePresentation.setDoAutoResize(true);
    }

    @Override
    protected boolean isCompositePatternLegal(DiagramElement diagramElement) {
        if (diagramElement instanceof MMTopicShape) {
            MMTopicShape mMTopicShape = (MMTopicShape)diagramElement;
            if (mMTopicShape.isTop()) {
                return false;
            }
            if (mMTopicShape.getBoundary() == null || !mMTopicShape.getBoundary().isVisible()) {
                return true;
            }
        }
        return false;
    }
}

