/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.mode;

import com.google.common.collect.Iterables;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.jmodel.CombinedFragmentPresentation;
import net.astah.jmodel.InteractionUsePresentation;
import net.astah.jmodel.JmodelFactory;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.LifelinePresentation;
import net.astah.jmodel.ObjectPresentation;
import net.astah.jmodel.ObjectPresentationUtil;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.PresentationUtil;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.SequenceDiagram;
import net.astah.jmodel.UMLInteractionDiagram;
import net.astah.jmodel.UMLSequenceDiagram;
import net.astah.jomt.jcontrol.ClassifierFactory;
import net.astah.jomt.jcontrol.CreateLifelineCommand;
import net.astah.jomt.jcontrol.mode.DiagramMode;

public class CreateLifelineMode
extends DiagramMode {
    protected RectPresentation parent = null;
    protected GRect containerRect;
    private int a = 45;
    private Map<RectPresentation, GRect> b = new HashMap<RectPresentation, GRect>();

    public CreateLifelineMode() {
        this.containerRect = new GRect(0.0, 0.0, 0.0, 0.0);
        this.containerRect.setColorNo((byte)3);
        this.containerRect.setRimWidth(2);
        this.containerRect.setBackgroundNo((byte)0);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!InputEventSupport.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.editingNodeModify(mouseEvent, false);
        this.canvas.unselect();
        CreateLifelineCommand createLifelineCommand = this.createCommand();
        LabelPresentation labelPresentation = this.createPresentation();
        if (labelPresentation == null) {
            return;
        }
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        Pnt2d pnt2d = new Pnt2d(d2, d3);
        this.setupPresentation(labelPresentation, pnt2d);
        UMLInteractionDiagram uMLInteractionDiagram = (UMLInteractionDiagram)this.getDiagram();
        int n2 = PresentationUtil.getMinDepth(uMLInteractionDiagram);
        labelPresentation.setDepth(n2 - 1);
        createLifelineCommand.setPresentation(labelPresentation);
        createLifelineCommand.setDiagram((UMLInteractionDiagram)this.getDiagram());
        createLifelineCommand.setShiftPressedState(mouseEvent.isShiftDown());
        this.fireCommandPerformed(new CommandEvent(mouseEvent.getSource(), mouseEvent.getID(), this.getCommandName(), createLifelineCommand, mouseEvent.getModifiers()));
        mouseEvent.consume();
        this.scene.removeAllTempNodes();
        if (mouseEvent.isShiftDown()) {
            this.parent = null;
            this.containerRect.setRect(0.0, 0.0, 0.0, 0.0);
            this.scene.addTempNode(this.containerRect);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.scene.addTempNode(this.containerRect);
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.scene.removeTempNode(this.containerRect);
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        Pnt2d pnt2d = new Pnt2d(d2, d3);
        this.parent = this.setTempRectOfEnterContainer(this.parent, this.containerRect, pnt2d);
        this.setTempCoveredBy(pnt2d);
        mouseEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    protected CreateLifelineCommand createCommand() {
        CreateLifelineCommand createLifelineCommand = new CreateLifelineCommand();
        createLifelineCommand.setCoveredBys(this.getCoveredBys());
        return createLifelineCommand;
    }

    protected List<LabelPresentation> getCoveredBys() {
        ArrayList<LabelPresentation> arrayList = new ArrayList<LabelPresentation>(0);
        for (RectPresentation rectPresentation : this.b.keySet()) {
            if (!(rectPresentation instanceof LabelPresentation)) continue;
            arrayList.add((LabelPresentation)rectPresentation);
        }
        return arrayList;
    }

    protected LabelPresentation createPresentation() {
        ObjectPresentation objectPresentation = null;
        if (this.de.getDiagram() instanceof UMLSequenceDiagram) {
            objectPresentation = JmodelFactory.eINSTANCE.createLifelinePresentation();
            objectPresentation.setWidth(objectPresentation.getInitialWidth());
            objectPresentation.setHeight(((LifelinePresentation)objectPresentation).getInitialHeight());
        } else {
            objectPresentation = JmodelFactory.eINSTANCE.createObjectPresentation();
            objectPresentation.setWidth(objectPresentation.getMinWidth());
            objectPresentation.setHeight(objectPresentation.getMinHeight());
            ObjectPresentationUtil.setCreating(true);
        }
        ClassifierFactory.setVisibilities(objectPresentation);
        return objectPresentation;
    }

    protected void setupPresentation(LabelPresentation labelPresentation, Pnt2d pnt2d) {
        labelPresentation.setLocation(pnt2d);
        labelPresentation.setDepth(PresentationUtil.getMinDepth(this.de.getDiagram()) - 1);
        if (this.de.getDiagram() instanceof UMLSequenceDiagram) {
            labelPresentation.setLocation(new Pnt2d(pnt2d.x, 30.0));
            ((LifelinePresentation)labelPresentation).setLifelineLength(SequenceDiagram.getPrefferedLifelineLength((UMLSequenceDiagram)this.getDiagram()));
        }
    }

    protected String getCommandName() {
        return "CreateLifeline";
    }

    @Override
    protected boolean isCompositePatternLegal(DiagramElement diagramElement) {
        return false;
    }

    protected void setTempCoveredBy(Pnt2d pnt2d) {
        for (Presentation presentation : Iterables.filter(this.de.getDiagram().getOwnedElements(), Presentation.class)) {
            boolean bl;
            if (!(presentation instanceof CombinedFragmentPresentation) && !(presentation instanceof InteractionUsePresentation)) continue;
            LabelPresentation labelPresentation = (LabelPresentation)presentation;
            Pnt2d pnt2d2 = labelPresentation.getLocation();
            double d2 = labelPresentation.getWidth();
            double d3 = pnt2d.x + (double)this.a;
            boolean bl2 = bl = d3 > pnt2d2.x && d3 < pnt2d2.x + d2;
            if (bl) {
                this.a(labelPresentation);
                continue;
            }
            this.b(labelPresentation);
        }
    }

    private void a(RectPresentation rectPresentation) {
        if (this.b.containsKey(rectPresentation)) {
            return;
        }
        Pnt2d pnt2d = rectPresentation.getLocation();
        double d2 = rectPresentation.getWidth();
        double d3 = rectPresentation.getHeight();
        GRect gRect = new GRect(pnt2d.x, pnt2d.y, d2, d3);
        this.b.put(rectPresentation, gRect);
        gRect.setColorNo((byte)11);
        gRect.setBackgroundNo((byte)0);
        gRect.setRimWidth(2);
        this.scene.addTempNode(gRect);
        this.canvas.repaintSync();
        this.canvas.drawTempFront();
    }

    private void b(RectPresentation rectPresentation) {
        if (!this.b.containsKey(rectPresentation)) {
            return;
        }
        GRect gRect = this.b.remove(rectPresentation);
        this.scene.removeTempNode(gRect);
        gRect = null;
        this.canvas.repaintSync();
        this.canvas.drawTempFront();
    }
}

