/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.mode;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.List;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.jmodel.ActivityPartitionPresentation;
import net.astah.jmodel.JmodelFactory;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jomt.jcontrol.CreateActivityPartitionCommand;
import net.astah.jomt.jcontrol.mode.DiagramMode;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jutil.JomtDefaultSizeUtilities;
import net.astah.jomt.jutil.ReflectionUtil;
import net.astah.jomt.jview.DiagramEditorPeer;
import net.astah.jomt.jviewElement.CJomtTextNode;
import net.astah.uml2.uml.util.PartitionUtil;
import org.eclipse.uml2.uml.ActivityPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateActivityPartitionMode
extends DiagramMode {
    protected final double WIDTH = 0.0;
    protected ActivityPartitionPresentation parentPresentation = null;
    protected GRect containerRect = new GRect(0.0, 0.0, 0.0, 0.0);
    protected ActivityPartitionPresentation overlappedPresentation = null;
    protected Pnt2d point = null;
    private static final Logger a = LoggerFactory.getLogger(CreateActivityPartitionMode.class);

    public CreateActivityPartitionMode() {
        this.containerRect.setColorNo((byte)3);
        this.containerRect.setRimWidth(2);
        this.containerRect.setBackgroundNo((byte)0);
        this.point = new Pnt2d();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!InputEventSupport.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.refreshOverlappedPresentation(mouseEvent.getX(), mouseEvent.getY());
        CJomtTextNode cJomtTextNode = this.de.getEditingNode();
        if (cJomtTextNode != null) {
            this.fireEditingNodeModifyCommand(mouseEvent, cJomtTextNode);
            cJomtTextNode.setComponentFocus(false);
            this.canvas.requestFocus();
        }
        this.canvas.unselect();
        this.callCreateSwimlaneCommand(mouseEvent);
        this.scene.removeAllTempNodes();
        DiagramEditorPeer diagramEditorPeer = (DiagramEditorPeer)this.de.getUiViewPeer();
        if (mouseEvent.isShiftDown() || diagramEditorPeer.getToggleButtonState("diagramview.modetoolbar.lock")) {
            this.overlappedPresentation = null;
            this.parentPresentation = null;
            this.containerRect.setRect(0.0, 0.0, 0.0, 0.0);
            this.scene.addTempNode(this.containerRect);
            this.mouseMoved(mouseEvent);
            return;
        }
        mouseEvent.consume();
    }

    protected CreateActivityPartitionCommand getCreateCommand() {
        CreateActivityPartitionCommand createActivityPartitionCommand = new CreateActivityPartitionCommand();
        return createActivityPartitionCommand;
    }

    protected void callCreateSwimlaneCommand(MouseEvent mouseEvent) {
        Object object;
        CreateActivityPartitionCommand createActivityPartitionCommand = this.getCreateCommand();
        ActivityPartitionPresentation activityPartitionPresentation = JmodelFactory.eINSTANCE.createActivityPartitionPresentation();
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        Pnt2d pnt2d = new Pnt2d(d2, d3);
        JomtDefaultSizeUtilities jomtDefaultSizeUtilities = ReflectionUtil.getJomtDefaultSizeUtilities(activityPartitionPresentation);
        if (jomtDefaultSizeUtilities.getDefaultUse()) {
            activityPartitionPresentation.setWidth(0.0);
            activityPartitionPresentation.setHeight(jomtDefaultSizeUtilities.getDefaultHeight());
            createActivityPartitionCommand.setDefaultSpan(jomtDefaultSizeUtilities.getDefaultWidth());
        } else {
            activityPartitionPresentation.setWidth(0.0);
            object = JomtGlobal.viewManager.getCurrentDiagramEditor().getCanvasBound();
            double d4 = 0.0;
            d4 = ((Rectangle2D.Double)object).getHeight() - activityPartitionPresentation.getNameBlockHeight() / 2.0;
            if (d4 > activityPartitionPresentation.getMinLength()) {
                activityPartitionPresentation.setLength(d4);
            } else {
                activityPartitionPresentation.setHeight(this.canvas.getHeight());
            }
        }
        activityPartitionPresentation.setLocation(pnt2d);
        createActivityPartitionCommand.setPresentation(activityPartitionPresentation);
        createActivityPartitionCommand.setParentPresentation(this.parentPresentation);
        createActivityPartitionCommand.setDiagram((UMLActivityDiagram)this.getDiagram());
        object = (DiagramEditorPeer)this.de.getUiViewPeer();
        boolean bl = mouseEvent.isShiftDown() || object.getToggleButtonState("diagramview.modetoolbar.lock");
        createActivityPartitionCommand.setShiftPressedState(bl);
        this.fireCommandPerformed(new CommandEvent(mouseEvent.getSource(), mouseEvent.getID(), "CreateSwimlane", createActivityPartitionCommand, mouseEvent.getModifiers()));
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.scene.addTempNode(this.containerRect);
        this.canvas.xorTemp();
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.canvas.xorTemp();
        this.scene.removeTempNode(this.containerRect);
        this.containerRect.setRect(0.0, 0.0, 0.0, 0.0);
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.refreshOverlappedPresentation(mouseEvent.getX(), mouseEvent.getY());
        mouseEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    protected void refreshOverlappedPresentation(int n2, int n3) {
        double d2 = this.camera.toWorldCoordX(n2);
        double d3 = this.camera.toWorldCoordY(n3);
        this.point.set(d2, d3);
        this.overlappedPresentation = this.setTempRectToInsertVerticalSwimlane(this.overlappedPresentation, this.containerRect, this.point);
    }

    protected ActivityPartitionPresentation setTempRectToInsertVerticalSwimlane(ActivityPartitionPresentation activityPartitionPresentation, GRect gRect, Pnt2d pnt2d) {
        if (!(this.getDiagram() instanceof UMLActivityDiagram)) {
            return null;
        }
        UMLActivityDiagram uMLActivityDiagram = (UMLActivityDiagram)this.getDiagram();
        ActivityPartitionPresentation activityPartitionPresentation2 = PartitionUtil.getReferedSwimlanePs(uMLActivityDiagram, pnt2d, false);
        a.debug("{}", activityPartitionPresentation2);
        this.canvas.xorTemp();
        if (activityPartitionPresentation2 == null) {
            gRect.setRect(0.0, 0.0, 0.0, 0.0);
            this.parentPresentation = null;
        } else {
            double d2 = PartitionUtil.getNameBlockHeightWithChildren((UMLActivityDiagram)activityPartitionPresentation2.getDiagram(), activityPartitionPresentation2);
            double d3 = activityPartitionPresentation2.getMaxX();
            double d4 = d3 - activityPartitionPresentation2.getSpan() / 2.0;
            double d5 = 0.0;
            double d6 = activityPartitionPresentation2.getMinY() + d2;
            if (pnt2d.x > d3) {
                List<Presentation> list;
                d5 = d3;
                gRect.setRect(d5, activityPartitionPresentation2.getMinY(), 25.0, activityPartitionPresentation2.getHeight());
                ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation2.getModel();
                ActivityPartition activityPartition2 = activityPartition.getSuperPartition();
                if (activityPartition2 != null && (list = Presentations.getPresentations(activityPartition2)).size() > 0) {
                    this.parentPresentation = (ActivityPartitionPresentation)list.get(0);
                }
            } else if (pnt2d.y > d6) {
                gRect.setRect(activityPartitionPresentation2.getMinX(), d6, activityPartitionPresentation2.getSpan(), activityPartitionPresentation2.getHeight() - d2);
                this.parentPresentation = activityPartitionPresentation2;
            } else {
                List<Presentation> list;
                if (pnt2d.x < d4) {
                    d5 = activityPartitionPresentation2.getMinX();
                } else if (pnt2d.x < d3) {
                    d5 = activityPartitionPresentation2.getMinX() + activityPartitionPresentation2.getSpan() - 25.0;
                }
                gRect.setRect(d5, activityPartitionPresentation2.getMinY(), 25.0, activityPartitionPresentation2.getHeight());
                ActivityPartition activityPartition = (ActivityPartition)activityPartitionPresentation2.getModel();
                ActivityPartition activityPartition3 = activityPartition.getSuperPartition();
                if (activityPartition3 != null && (list = Presentations.getPresentations(activityPartition3)).size() > 0) {
                    this.parentPresentation = (ActivityPartitionPresentation)list.get(0);
                }
            }
        }
        this.canvas.xorTemp();
        return activityPartitionPresentation2;
    }
}

