/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol.mode;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import net.astah.dd.di.Diagram;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.draw.GRect;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.jmodel.ActivityNodePresentation;
import net.astah.jmodel.ActivityPartitionPresentation;
import net.astah.jmodel.PresentationUtil;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jomt.jcontrol.CreateActivityNodeCommand;
import net.astah.jomt.jcontrol.mode.DiagramMode;
import net.astah.uml2.uml.util.PartitionUtil;
import org.eclipse.uml2.uml.Activity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CreateActivityNodeMode
extends DiagramMode {
    private static final Logger a = LoggerFactory.getLogger(CreateActivityNodeMode.class);
    protected ActivityPartitionPresentation overlappedVerticalPresentation = null;
    protected ActivityPartitionPresentation overlappedHorizontalPresentation = null;
    protected GRect containerVerticalRect = new GRect(0.0, 0.0, 0.0, 0.0);
    protected GRect containerHorizontalRect;

    abstract CreateActivityNodeCommand createCommand();

    protected abstract ActivityNodePresentation createPresentation();

    protected abstract void setPresentationAttribute(ActivityNodePresentation var1);

    protected abstract void setAdditionalCommandInformation(CreateActivityNodeCommand var1);

    protected abstract String getCommandName();

    public CreateActivityNodeMode() {
        this.containerVerticalRect.setColorNo((byte)3);
        this.containerVerticalRect.setRimWidth(2);
        this.containerVerticalRect.setBackgroundNo((byte)0);
        this.containerHorizontalRect = new GRect(0.0, 0.0, 0.0, 0.0);
        this.containerHorizontalRect.setColorNo((byte)3);
        this.containerHorizontalRect.setRimWidth(2);
        this.containerHorizontalRect.setBackgroundNo((byte)0);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!InputEventSupport.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.canvas.unselect();
        CreateActivityNodeCommand createActivityNodeCommand = this.createCommand();
        ActivityNodePresentation activityNodePresentation = this.createPresentation();
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        Pnt2d pnt2d = new Pnt2d(d2, d3);
        UMLActivityDiagram uMLActivityDiagram = (UMLActivityDiagram)this.de.getDiagram();
        a.debug("\u30d1\u30fc\u30c6\u30a3\u30b7\u30e7\u30f3\u306e\u5224\u5b9a\u3092\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059");
        if (!PartitionUtil.isValidPosition(pnt2d, uMLActivityDiagram)) {
            return;
        }
        Activity activity = uMLActivityDiagram.getActivityGraph();
        this.resetSwimlaneIndependent(activityNodePresentation);
        activityNodePresentation.setLocation(pnt2d);
        if (activity == null) {
            int n2 = PresentationUtil.getMinDepth(this.de.getDiagram());
            activityNodePresentation.setDepth(n2 - 1);
        } else {
            a.debug("\u30b3\u30f3\u30c6\u30ca\u306b\u5fdc\u3058\u305fdepth\u8a2d\u5b9a\u306f\u672a\u5bfe\u5fdc");
            int n3 = PresentationUtil.getMinDepth(uMLActivityDiagram);
            activityNodePresentation.setDepth(n3 - 1);
        }
        this.setPresentationAttribute(activityNodePresentation);
        createActivityNodeCommand.setPresentation(activityNodePresentation);
        createActivityNodeCommand.setDiagram(uMLActivityDiagram);
        createActivityNodeCommand.setShiftPressedState(mouseEvent.isShiftDown());
        createActivityNodeCommand.setContainer(activity);
        if (this.overlappedVerticalPresentation != null) {
            createActivityNodeCommand.addPartitions(PartitionUtil.getAllParentPartitions(this.overlappedVerticalPresentation.getPartition()));
        }
        if (this.overlappedHorizontalPresentation != null) {
            createActivityNodeCommand.addPartitions(PartitionUtil.getAllParentPartitions(this.overlappedHorizontalPresentation.getPartition()));
        }
        this.setAdditionalCommandInformation(createActivityNodeCommand);
        this.fireCommandPerformed(new CommandEvent(mouseEvent.getSource(), mouseEvent.getID(), this.getCommandName(), createActivityNodeCommand, mouseEvent.getModifiers()));
        mouseEvent.consume();
        this.scene.removeAllTempNodes();
        if (mouseEvent.isShiftDown()) {
            activity = null;
            this.overlappedVerticalPresentation = null;
            this.overlappedHorizontalPresentation = null;
            this.containerVerticalRect.setRect(0.0, 0.0, 0.0, 0.0);
            this.scene.addTempNode(this.containerVerticalRect);
            this.containerHorizontalRect.setRect(0.0, 0.0, 0.0, 0.0);
            this.scene.addTempNode(this.containerHorizontalRect);
        }
    }

    protected void resetSwimlaneIndependent(ActivityNodePresentation activityNodePresentation) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        double d2 = this.camera.toWorldCoordX(mouseEvent.getX());
        double d3 = this.camera.toWorldCoordY(mouseEvent.getY());
        Pnt2d pnt2d = new Pnt2d(d2, d3);
        this.overlappedVerticalPresentation = this.setTempRectOfEnterVerticalSwimlane(this.overlappedVerticalPresentation, this.containerVerticalRect, pnt2d);
        this.overlappedHorizontalPresentation = this.setTempRectOfEnterHorizontalSwimlane(this.overlappedHorizontalPresentation, this.containerHorizontalRect, pnt2d);
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.scene.addTempNode(this.containerVerticalRect);
        this.scene.addTempNode(this.containerHorizontalRect);
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.scene.removeTempNode(this.containerVerticalRect);
        this.scene.removeTempNode(this.containerHorizontalRect);
        mouseEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        mouseEvent.consume();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (InputEventSupport.isRightMouseButton(mouseEvent)) {
            return;
        }
        mouseEvent.consume();
    }

    @Override
    protected ActivityPartitionPresentation setTempRectOfEnterVerticalSwimlane(ActivityPartitionPresentation activityPartitionPresentation, GRect gRect, Pnt2d pnt2d) {
        Diagram diagram = this.de.getDiagram();
        if (!(diagram instanceof UMLActivityDiagram)) {
            return null;
        }
        UMLActivityDiagram uMLActivityDiagram = (UMLActivityDiagram)diagram;
        ActivityPartitionPresentation activityPartitionPresentation2 = PartitionUtil.getReferedSwimlanePsToMoveIn(uMLActivityDiagram, pnt2d, false);
        if (activityPartitionPresentation2 != activityPartitionPresentation) {
            activityPartitionPresentation = activityPartitionPresentation2;
            if (activityPartitionPresentation2 != null) {
                gRect.setRect(activityPartitionPresentation2.getLocation().x, activityPartitionPresentation2.getLocation().y, activityPartitionPresentation2.getWidth(), activityPartitionPresentation2.getHeight());
            } else {
                gRect.setRect(0.0, 0.0, 0.0, 0.0);
            }
            this.canvas.repaintSync();
            this.canvas.drawTempFront();
        }
        return activityPartitionPresentation2;
    }

    @Override
    protected ActivityPartitionPresentation setTempRectOfEnterHorizontalSwimlane(ActivityPartitionPresentation activityPartitionPresentation, GRect gRect, Pnt2d pnt2d) {
        Diagram diagram = this.de.getDiagram();
        if (!(diagram instanceof UMLActivityDiagram)) {
            return null;
        }
        UMLActivityDiagram uMLActivityDiagram = (UMLActivityDiagram)diagram;
        ActivityPartitionPresentation activityPartitionPresentation2 = PartitionUtil.getReferedSwimlanePsToMoveIn(uMLActivityDiagram, pnt2d, true);
        if (activityPartitionPresentation2 != activityPartitionPresentation) {
            activityPartitionPresentation = activityPartitionPresentation2;
            if (activityPartitionPresentation2 != null) {
                gRect.setRect(activityPartitionPresentation2.getLocation().x, activityPartitionPresentation2.getLocation().y, activityPartitionPresentation2.getWidth(), activityPartitionPresentation2.getHeight());
            } else {
                gRect.setRect(0.0, 0.0, 0.0, 0.0);
            }
            this.canvas.repaintSync();
            this.canvas.drawTempFront();
        }
        return activityPartitionPresentation2;
    }
}

