/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Point;
import net.astah.golf.control.Command;
import net.astah.golf.draw.GCamera;
import net.astah.golf.widget.CCanvas;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;

public class ZoomViewCommand
extends Command {
    protected static final double QUOTIETY = 1.1;
    protected Point datumPoint = null;

    public void setDatumPoint(Point point) {
        this.datumPoint = point;
    }

    @Override
    public void execute() {
        try {
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            if (diagramEditor == null) {
                return;
            }
            GCamera gCamera = diagramEditor.getCamera();
            double d2 = this.getNewZoomScale(gCamera.getScale());
            if (this.datumPoint != null) {
                double d3 = diagramEditor.getZoomScale();
                double d4 = DiagramEditor.getNewZoomScale(d3, d2);
                double d5 = (1.0 / d3 - 1.0 / d4) * (double)this.datumPoint.x;
                double d6 = (1.0 / d3 - 1.0 / d4) * (double)this.datumPoint.y;
                gCamera.pan(d5, d6);
                diagramEditor.zoom(d2, false);
            } else {
                diagramEditor.zoom(d2, true);
            }
            CCanvas cCanvas = diagramEditor.getCanvas();
            cCanvas.repaint(() -> {
                cCanvas.clear();
                cCanvas.draw();
            });
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected double getNewZoomScale(double d2) {
        return DiagramEditor.ZOOM_SCALE_DEFAULT;
    }
}

