/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.Map;
import net.astah.emf.edit.job.Jobs;
import net.astah.emf.validation.ValidationJob;
import net.astah.golf.control.Command;
import net.astah.jomt.jcontrol.ShowExtraViewCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.ExtraView;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.ValidationView;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(ValidateCommand.class);
    private IValidator<EObject> b;
    private Map<String, Object> c;

    public IValidator<EObject> getValidator() {
        return this.b;
    }

    public void setValidator(IValidator<EObject> iValidator) {
        this.b = iValidator;
    }

    public Map<String, Object> getClientData() {
        return this.c;
    }

    public void setClientData(Map<String, Object> map) {
        this.c = map;
    }

    @Override
    public void execute() {
        if (this.b == null) {
            this.b = ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        }
        if (this.c != null) {
            this.c.forEach(this.b::putClientData);
        }
        EditingDomain editingDomain = ModelGlobal.prjManager.getCurrentProject().doc.getDomain();
        TransactionalEditingDomain transactionalEditingDomain = (TransactionalEditingDomain)editingDomain;
        ValidationJob validationJob = new ValidationJob(transactionalEditingDomain, this.b, this.getEObjects(editingDomain));
        validationJob.setPriority(10);
        validationJob.addJobChangeListener(Jobs.done(iJobChangeEvent -> {
            IStatus iStatus = iJobChangeEvent.getResult();
            if (iStatus.isOK()) {
                if (!validationJob.getValidationResult().isOK()) {
                    this.showValidationView();
                }
            } else if (iStatus.matches(7)) {
                if (iStatus.getSeverity() == 4) {
                    MessageManager.displayStatusMessageDialog("app", "validation.unexpected_error", iStatus);
                }
                Jobs.log(a, iStatus);
            }
        }, true));
        validationJob.schedule();
    }

    protected Iterable<EObject> getEObjects(EditingDomain editingDomain) {
        Project project = ProjectManagerAdapter.getRootProject(editingDomain.getResourceSet());
        return project.getContents();
    }

    protected void showValidationView() {
        ValidationView validationView;
        ExtraView extraView = JomtGlobal.viewManager.getExtraView();
        if (extraView != null && (validationView = extraView.getValidationView()) != null) {
            new ShowExtraViewCommand().execute();
            extraView.setSelectedUIViewTab(validationView);
        }
    }
}

