/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import org.eclipse.emf.ecore.EObject;

public abstract class UpDownHyperlinkCommand
extends Command {
    protected EObject hyperlinkOwner;
    protected JTable table;
    protected int[] selectedHyperlinks;
    protected int hyperlinkCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            if (this.hyperlinkOwner == null) {
                return;
            }
            if (this.selectedHyperlinks == null || this.selectedHyperlinks.length <= 0) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                int[] nArray = this.upDownHyperLink();
                iJomtEntityStore.commitTransaction();
                this.table.clearSelection();
                if (nArray != null) {
                    ListSelectionModel listSelectionModel = this.table.getSelectionModel();
                    for (int n2 : nArray) {
                        listSelectionModel.addSelectionInterval(n2, n2);
                    }
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected abstract int[] upDownHyperLink();

    public void setHyperlinkOwner(EObject eObject) {
        this.hyperlinkOwner = eObject;
    }

    public void setSelectedHyperlinks(int[] nArray) {
        this.selectedHyperlinks = nArray;
    }

    public void setHyperlinkCount(int n2) {
        this.hyperlinkCount = n2;
    }

    public void setHyperlinkTable(JTable jTable) {
        this.table = jTable;
    }
}

