/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.List;
import net.astah.golf.control.Command;
import net.astah.golf.draw.GNode;
import net.astah.golf.util.Debug;
import net.astah.jmodel.Project;
import net.astah.jmodel.impl.BinaryRelationPresentationImpl;
import net.astah.jmodel.impl.FramePresentationImpl;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.ViewGlobal;
import net.astah.jomt.jutil.JomtFontUtilities;
import net.astah.jomt.jutil.JomtPresentationUtil;
import net.astah.jomt.jutil.SwingInvoker;
import net.astah.jomt.jview.CModelPane;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PropertyView;
import net.astah.jomt.jview.proptab.ModelTabGroup;
import net.astah.jomt.jviewElement.DiagramViewElement;
import net.astah.jomt.jviewElement.JomtDiagramViewElement;
import net.astah.uml.mindmap.MMUserIconManager;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(UndoCommand.class);
    public static boolean inUndo = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        JomtGlobal.commandSupport.startWaitCursor();
        Project project = ModelGlobal.prjManager.getCurrentProject();
        try {
            Editor editor;
            DiagramViewElement diagramViewElement = null;
            List<GNode> list = null;
            if (JomtGlobal.viewManager.getProjectView() != null) {
                JomtGlobal.viewManager.getProjectView().getStructureTree().clearSelection();
            }
            EObject eObject = this.b();
            if (!JomtGlobal.isNoGUI() && (editor = JomtGlobal.viewManager.getCurrentEditor()) != null) {
                if (editor instanceof DiagramEditor) {
                    list = ((DiagramEditor)editor).getCanvas().getSelectedNodes();
                    ((DiagramEditor)editor).getCanvas().unselect();
                    ((DiagramEditor)editor).getCanvasUIView().popMode();
                    JomtGlobal.modeManager.changeButtonsState(false);
                    diagramViewElement = ((DiagramEditor)editor).getDiagramScene().getDiagramViewElement();
                } else {
                    editor.unselect();
                }
            }
            if (project == null) {
                Debug.impossible("UndoCommand#execute(): current project = null.");
                return;
            }
            if (project.canUndo()) {
                boolean bl = false;
                if (diagramViewElement != null && diagramViewElement instanceof JomtDiagramViewElement) {
                    bl = diagramViewElement.getCreateEditState();
                    diagramViewElement.setCreateEditState(false);
                }
                project.doc.beginTransaction();
                inUndo = true;
                FramePresentationImpl.NEED_UPDATED = false;
                BinaryRelationPresentationImpl.setSuppressUpdate(true);
                project.undo();
                BinaryRelationPresentationImpl.setSuppressUpdate(false);
                JomtPresentationUtil.validateClipboard(ViewGlobal.clipboard, project.doc);
                JomtFontUtilities.resetProjectFont();
                MMUserIconManager.instance().initializeProjectUserIconInfo(project.doc);
                project.doc.commitTransaction();
                if (diagramViewElement != null) {
                    diagramViewElement.setCreateEditState(bl);
                }
                if (!JomtGlobal.isNoGUI()) {
                    EObject eObject2;
                    DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
                    if (diagramEditor != null && list != null) {
                        diagramEditor.getCanvas().select(list);
                    }
                    if ((eObject2 = this.b()) == eObject) {
                        JomtGlobal.viewManager.updatePropertyView(eObject2);
                    }
                    SwingInvoker.runLaterInEDT(() -> this.a());
                }
            }
        }
        catch (Exception exception) {
            project.doc.abortTransaction();
            MessageManager.requireBugReport(exception);
        }
        finally {
            FramePresentationImpl.NEED_UPDATED = true;
            project.doc.abortTransaction();
            JomtGlobal.commandSupport.endWaitCursor();
            inUndo = false;
        }
    }

    private void a() {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        if (diagramEditor != null) {
            diagramEditor.repaintCanvas();
            diagramEditor.setNeedInitializeSearchToolBar(true);
        }
    }

    private EObject b() {
        PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
        if (propertyView == null) {
            return null;
        }
        CModelPane cModelPane = propertyView.getModelPane();
        if (cModelPane == null) {
            return null;
        }
        ModelTabGroup modelTabGroup = cModelPane.getCurrentModelTabGroup();
        if (modelTabGroup == null) {
            return null;
        }
        return modelTabGroup.getModelElement();
    }
}

