/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.widget.CColor;
import net.astah.notation.mindmap.MMOrientationKind;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.notation.mindmap.edit.layout.MMStyleSupport;
import org.eclipse.emf.common.util.EList;

public class TopicStringCopyHelper {
    private Set<MMTopicShape> a(DiagramElement[] diagramElementArray) {
        HashSet<MMTopicShape> hashSet = new HashSet<MMTopicShape>();
        List<MMTopicShape> list = this.getAllRootTopics(diagramElementArray);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            EList<MMTopicShape> eList = list.get(i2).allChildren();
            hashSet.addAll(eList);
        }
        hashSet.addAll(list);
        return hashSet;
    }

    private Set<CColor> a(Set<MMTopicShape> set) {
        HashSet<CColor> hashSet = new HashSet<CColor>();
        Iterator<MMTopicShape> iterator = set.iterator();
        while (iterator.hasNext()) {
            CColor cColor = MMStyleSupport.getFontColor(iterator.next());
            if (cColor == null) continue;
            hashSet.add(cColor);
        }
        return hashSet;
    }

    protected Map<CColor, Integer> getColorTable(Set<CColor> set) {
        HashMap<CColor, Integer> hashMap = new HashMap<CColor, Integer>();
        int n2 = 1;
        for (CColor cColor : set) {
            hashMap.put(cColor, new Integer(++n2));
        }
        return hashMap;
    }

    private String b(Set<CColor> set) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\\colortbl;\\red0\\green0\\blue0;");
        for (CColor cColor : set) {
            stringBuilder.append("\\red");
            stringBuilder.append(cColor.getRed());
            stringBuilder.append("\\green");
            stringBuilder.append(cColor.getGreen());
            stringBuilder.append("\\blue");
            stringBuilder.append(cColor.getBlue());
            stringBuilder.append(";");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    protected String getRichTextHeader(Set<CColor> set) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang1033{\\fonttbl{\\f0\\fswiss\\fcharset0 Arial;}");
        stringBuilder.append(this.b(set));
        stringBuilder.append("}");
        stringBuilder.append("\\viewkind4\\uc1\\pard\\f0\\fs20{}");
        return stringBuilder.toString();
    }

    protected String getRichText(DiagramElement[] diagramElementArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Set<MMTopicShape> set = this.a(diagramElementArray);
        Set<CColor> set2 = this.a(set);
        Map<CColor, Integer> map = this.getColorTable(set2);
        stringBuilder.append(this.getRichTextHeader(set2));
        List<MMTopicShape> list = this.getAllRootTopics(diagramElementArray);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MMTopicShape mMTopicShape = list.get(i2);
            stringBuilder.append(this.a(mMTopicShape, 0, map));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String a(MMTopicShape mMTopicShape, int n2, Map<CColor, Integer> map) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        String string = n2 <= 8 ? "\\outlinelevel" + n2 : "";
        stringBuilder.append("{");
        stringBuilder.append("\\li");
        stringBuilder.append(n2 * 350);
        stringBuilder.append(string);
        stringBuilder.append("{}");
        stringBuilder.append("{\\li");
        stringBuilder.append(n2 * 350);
        CColor cColor = MMStyleSupport.getFontColor(mMTopicShape);
        if (cColor != null) {
            object = map.get(cColor);
            stringBuilder.append("\\cf");
            stringBuilder.append((Integer)object);
            stringBuilder.append("\\ppscheme");
            stringBuilder.append(this.getPPShemeNumber(cColor));
        } else {
            stringBuilder.append("\\cf1\\ppscheme1");
        }
        object = this.castRTFCharacters(mMTopicShape.getText());
        stringBuilder.append(" ");
        stringBuilder.append((String)object);
        stringBuilder.append("\\par");
        stringBuilder.append("}}");
        stringBuilder.append("\n");
        for (MMTopicShape mMTopicShape2 : mMTopicShape.getChildren()) {
            stringBuilder.append(this.a(mMTopicShape2, n2 + 1, map));
        }
        return stringBuilder.toString();
    }

    protected int getPPShemeNumber(CColor cColor) {
        int n2 = cColor.getRed();
        int n3 = cColor.getGreen();
        int n4 = cColor.getBlue();
        int n5 = n2 + n3 * 256 + n4 * 65536 + 1;
        return n5;
    }

    protected String castRTFCharacters(String string) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        block6: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            char c3 = string.charAt(i2);
            if (c3 > '\u0080') {
                stringBuilder.append("\\u").append((int)c3).append("?");
                continue;
            }
            switch (c2) {
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block6;
                }
                case '{': {
                    stringBuilder.append("\\{");
                    continue block6;
                }
                case '}': {
                    stringBuilder.append("\\}");
                    continue block6;
                }
                case '\n': {
                    stringBuilder.append(" \\line ");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.toString();
    }

    protected String getTransferableTopicString(DiagramElement[] diagramElementArray) {
        StringBuilder stringBuilder = new StringBuilder();
        List<MMTopicShape> list = this.getAllRootTopics(diagramElementArray);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MMTopicShape mMTopicShape = list.get(i2);
            if (i2 > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(this.a(mMTopicShape, 0));
            stringBuilder.append("\r");
        }
        return stringBuilder.toString();
    }

    private List<MMTopicShape> a(List<MMTopicShape> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            for (int i3 = 0; i3 < list.size() - i2 - 1; ++i3) {
                MMTopicShape mMTopicShape = list.get(i3);
                MMTopicShape mMTopicShape2 = list.get(i3 + 1);
                if (mMTopicShape.isRoot()) continue;
                if (mMTopicShape2.isRoot()) {
                    this.a(list, i3, i3 + 1);
                    continue;
                }
                if (mMTopicShape2.getOrientation() == MMOrientationKind.RIGHT && mMTopicShape.getOrientation() == MMOrientationKind.LEFT) {
                    this.a(list, i3, i3 + 1);
                    continue;
                }
                if (!mMTopicShape2.getOrientation().equals(mMTopicShape.getOrientation()) || !(mMTopicShape2.getMinY() < mMTopicShape.getMinY())) continue;
                this.a(list, i3, i3 + 1);
            }
        }
        return list;
    }

    private void a(List<MMTopicShape> list, int n2, int n3) {
        MMTopicShape mMTopicShape = list.get(n2);
        list.set(n2, list.get(n3));
        list.set(n3, mMTopicShape);
    }

    public List<MMTopicShape> getAllRootTopics(DiagramElement[] diagramElementArray) {
        ArrayList<MMTopicShape> arrayList = new ArrayList<MMTopicShape>();
        for (int i2 = 0; i2 < diagramElementArray.length; ++i2) {
            MMTopicShape mMTopicShape;
            if (!(diagramElementArray[i2] instanceof MMTopicShape) || !this.a(mMTopicShape = (MMTopicShape)diagramElementArray[i2], diagramElementArray)) continue;
            arrayList.add(mMTopicShape);
        }
        return this.a(arrayList);
    }

    private boolean a(MMTopicShape mMTopicShape, DiagramElement[] diagramElementArray) {
        EList<MMTopicShape> eList = mMTopicShape.allParents();
        for (int i2 = 0; i2 < diagramElementArray.length; ++i2) {
            if (!eList.contains(diagramElementArray[i2])) continue;
            return false;
        }
        return true;
    }

    private String a(MMTopicShape mMTopicShape, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 > 0) {
            stringBuilder.append("\n");
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append("\t");
            }
        }
        String string = mMTopicShape.getText().replaceAll("\n", " ");
        stringBuilder.append(string);
        for (MMTopicShape mMTopicShape2 : mMTopicShape.getChildren()) {
            int n3 = n2++;
            stringBuilder.append(this.a(mMTopicShape2, n2));
            n2 = n3;
        }
        return stringBuilder.toString();
    }
}

