/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import net.astah.dd.dc.Bounds;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.util.Debug;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.jmodel.FramePresentation;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.PresentationUtil;
import net.astah.model.extension.Hyperlinks;
import net.astah.notation.edit.layout.DiagramElementOperations;
import net.astah.notation.mindmap.MMDiagramElement;
import net.astah.notation.mindmap.MMGraphicalShape;

public class ToImageUtil {
    public static final double INSET = 10.0;
    private static final double a = 20.0;

    public static DiagramElement[] adjustForFramePs(@NonNull DiagramElement[] diagramElementArray) {
        if (diagramElementArray == null) {
            throw new NullPointerException("results");
        }
        List<DiagramElement> list = Arrays.asList(diagramElementArray);
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>(list);
        Iterable<FramePresentation> iterable = Iterables.filter(list, FramePresentation.class);
        for (FramePresentation framePresentation : iterable) {
            if (framePresentation.isVisibility()) continue;
            arrayList.remove(framePresentation);
        }
        return (DiagramElement[])DiagramElement[].class.cast(arrayList.toArray(new DiagramElement[arrayList.size()]));
    }

    public static double getImageX(@NonNull Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new NullPointerException("r");
        }
        return rectangle2D.getX() - 10.0;
    }

    public static double getImageY(@NonNull Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new NullPointerException("r");
        }
        return rectangle2D.getY() - 10.0;
    }

    public static int getImageWidth(@NonNull Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new NullPointerException("r");
        }
        return Math.max(10, (int)((double)Math.round(rectangle2D.getWidth()) + 20.0));
    }

    public static int getImageHeight(@NonNull Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new NullPointerException("r");
        }
        return Math.max(10, (int)((double)Math.round(rectangle2D.getHeight()) + 20.0));
    }

    public static Rectangle2D getRectangle(@NonNull DiagramElement[] diagramElementArray) {
        if (diagramElementArray == null) {
            throw new NullPointerException("diagramElements");
        }
        ArrayList<Presentation> arrayList = Lists.newArrayList();
        for (DiagramElement diagramElement : diagramElementArray) {
            if (!(diagramElement instanceof Presentation)) continue;
            arrayList.add((Presentation)diagramElement);
        }
        DiagramElement[] diagramElementArray2 = arrayList.toArray(new Presentation[arrayList.size()]);
        int n2 = RuntimeGlobal.sysProp.getBooleanWithDefault("hyperlink.diagram_icon_image_visibility") ? 1 : 0;
        int n3 = RuntimeGlobal.sysProp.getBooleanWithDefault("mini_icon.diagram_icon_image_visibility") ? 1 : 0;
        if (n2 != 0 && n3 != 0) {
            return ToImageUtil.a((Presentation[])diagramElementArray2);
        }
        if (n2 != 0 && n3 == 0) {
            return ToImageUtil.b((Presentation[])diagramElementArray2);
        }
        if (n2 == 0 && n3 != 0) {
            return ToImageUtil.c((Presentation[])diagramElementArray2);
        }
        return DiagramElementOperations.getBoundsRect(diagramElementArray, true);
    }

    static Rectangle2d a(@NonNull Presentation[] presentationArray) {
        if (presentationArray == null) {
            throw new NullPointerException("presentations");
        }
        Rectangle2d rectangle2d = new Rectangle2d();
        for (Presentation presentation : presentationArray) {
            double d2;
            if (!(presentation instanceof JomtPresentation)) {
                Debug.impossible();
                continue;
            }
            Rectangle2d rectangle2d2 = ((JomtPresentation)presentation).getBoundsRect();
            if (rectangle2d2.isEmpty()) continue;
            PresentationUtil.resizeOutsideNameForFlowElement(presentation, rectangle2d2);
            if (Hyperlinks.hasVisibleHyperlinkIcon(presentation)) {
                if (ToImageUtil.a(presentation)) {
                    d2 = ToImageUtil.b(presentation);
                    rectangle2d2.setRect(rectangle2d2.x, rectangle2d2.y - 15.0, rectangle2d2.width + 15.0 + d2 * 20.0, rectangle2d2.height + 15.0);
                } else {
                    rectangle2d2.setRect(rectangle2d2.x, rectangle2d2.y - 15.0, rectangle2d2.width + 15.0, rectangle2d2.height + 15.0);
                }
            } else if (ToImageUtil.a(presentation)) {
                d2 = (double)ToImageUtil.b(presentation) - 1.0;
                rectangle2d2.setRect(rectangle2d2.x, rectangle2d2.y - 15.0, rectangle2d2.width + 15.0 + d2 * 20.0, rectangle2d2.height + 15.0);
            }
            rectangle2d = ToImageUtil.a(rectangle2d, rectangle2d2);
        }
        return rectangle2d;
    }

    static Rectangle2d b(@NonNull Presentation[] presentationArray) {
        if (presentationArray == null) {
            throw new NullPointerException("presentations");
        }
        Rectangle2d rectangle2d = new Rectangle2d();
        for (Presentation presentation : presentationArray) {
            if (!(presentation instanceof JomtPresentation)) {
                Debug.impossible();
                continue;
            }
            Rectangle2d rectangle2d2 = ((JomtPresentation)presentation).getBoundsRect();
            if (rectangle2d2.isEmpty()) continue;
            PresentationUtil.resizeOutsideNameForFlowElement(presentation, rectangle2d2);
            if (Hyperlinks.hasVisibleHyperlinkIcon(presentation)) {
                rectangle2d2.setRect(rectangle2d2.x, rectangle2d2.y - 15.0, rectangle2d2.width + 15.0, rectangle2d2.height + 15.0);
            }
            rectangle2d = ToImageUtil.a(rectangle2d, rectangle2d2);
        }
        return rectangle2d;
    }

    static Rectangle2d c(@NonNull Presentation[] presentationArray) {
        if (presentationArray == null) {
            throw new NullPointerException("presentations");
        }
        Rectangle2d rectangle2d = new Rectangle2d();
        for (Presentation presentation : presentationArray) {
            if (!(presentation instanceof JomtPresentation)) {
                Debug.impossible();
                continue;
            }
            Rectangle2d rectangle2d2 = ((JomtPresentation)presentation).getBoundsRect();
            if (rectangle2d2.isEmpty()) continue;
            PresentationUtil.resizeOutsideNameForFlowElement(presentation, rectangle2d2);
            if (ToImageUtil.a(presentation)) {
                double d2 = (double)ToImageUtil.b(presentation) - 1.0;
                rectangle2d2.setRect(rectangle2d2.x, rectangle2d2.y - 15.0, rectangle2d2.width + 15.0 + d2 * 20.0, rectangle2d2.height + 15.0);
            }
            rectangle2d = ToImageUtil.a(rectangle2d, rectangle2d2);
        }
        return rectangle2d;
    }

    private static boolean a(@NonNull Presentation presentation) {
        List<String> list;
        if (presentation == null) {
            throw new NullPointerException("presentation");
        }
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("mini_icon.diagram_icon_visibility");
        if (!bl) {
            return false;
        }
        return presentation instanceof JomtPresentation && (list = ((JomtPresentation)presentation).getMiniIcons()) != null && list.size() > 0;
    }

    private static int b(@NonNull Presentation presentation) {
        if (presentation == null) {
            throw new NullPointerException("element");
        }
        if (presentation instanceof JomtPresentation) {
            return ((JomtPresentation)presentation).getMiniIcons().size();
        }
        return 0;
    }

    public static Rectangle2D getRectangle(@NonNull MMDiagramElement[] mMDiagramElementArray) {
        if (mMDiagramElementArray == null) {
            throw new NullPointerException("mmDiagramElements");
        }
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("hyperlink.diagram_icon_image_visibility");
        boolean bl2 = RuntimeGlobal.sysProp.getBooleanWithDefault("mini_icon.diagram_icon_image_visibility");
        if (bl && bl2) {
            return ToImageUtil.a(mMDiagramElementArray);
        }
        if (bl && !bl2) {
            return ToImageUtil.b(mMDiagramElementArray);
        }
        if (!bl && bl2) {
            return ToImageUtil.c(mMDiagramElementArray);
        }
        return DiagramElementOperations.getBoundsRect(mMDiagramElementArray, true);
    }

    static Rectangle2d a(@NonNull MMDiagramElement[] mMDiagramElementArray) {
        if (mMDiagramElementArray == null) {
            throw new NullPointerException("mmDiagramElements");
        }
        Rectangle2d rectangle2d = new Rectangle2d();
        for (MMDiagramElement mMDiagramElement : mMDiagramElementArray) {
            double d2;
            Bounds bounds = new LayoutCalculator().getBounds(mMDiagramElement);
            if (bounds == null) continue;
            double d3 = bounds.getX();
            double d4 = bounds.getY();
            double d5 = bounds.getWidth();
            double d6 = bounds.getHeight();
            if (Hyperlinks.hasVisibleHyperlinkIcon(mMDiagramElement)) {
                d2 = ToImageUtil.b(mMDiagramElement);
                d5 += 15.0 + d2 * 20.0;
                d4 -= 15.0;
                d6 += 15.0;
            } else if (ToImageUtil.a(mMDiagramElement)) {
                d2 = (double)ToImageUtil.b(mMDiagramElement) - 1.0;
                d5 += 15.0 + d2 * 20.0;
                d4 -= 15.0;
                d6 += 15.0;
            }
            rectangle2d = ToImageUtil.a(rectangle2d, new Rectangle2d(d3, d4, d5, d6));
        }
        return rectangle2d;
    }

    static Rectangle2d b(@NonNull MMDiagramElement[] mMDiagramElementArray) {
        if (mMDiagramElementArray == null) {
            throw new NullPointerException("mmDiagramElements");
        }
        Rectangle2d rectangle2d = new Rectangle2d();
        for (MMDiagramElement mMDiagramElement : mMDiagramElementArray) {
            Bounds bounds = new LayoutCalculator().getBounds(mMDiagramElement);
            if (bounds == null) continue;
            double d2 = bounds.getX();
            double d3 = bounds.getY();
            double d4 = bounds.getWidth();
            double d5 = bounds.getHeight();
            if (Hyperlinks.hasVisibleHyperlinkIcon(mMDiagramElement)) {
                d3 -= 15.0;
                d4 += 15.0;
                d5 += 15.0;
            }
            rectangle2d = ToImageUtil.a(rectangle2d, new Rectangle2d(d2, d3, d4, d5));
        }
        return rectangle2d;
    }

    static Rectangle2d c(@NonNull MMDiagramElement[] mMDiagramElementArray) {
        if (mMDiagramElementArray == null) {
            throw new NullPointerException("mmDiagramElements");
        }
        Rectangle2d rectangle2d = new Rectangle2d();
        for (MMDiagramElement mMDiagramElement : mMDiagramElementArray) {
            Bounds bounds = new LayoutCalculator().getBounds(mMDiagramElement);
            if (bounds == null) continue;
            double d2 = bounds.getX();
            double d3 = bounds.getY();
            double d4 = bounds.getWidth();
            double d5 = bounds.getHeight();
            if (ToImageUtil.a(mMDiagramElement)) {
                d3 -= 15.0;
                double d6 = (double)ToImageUtil.b(mMDiagramElement) - 1.0;
                d4 += 15.0 + d6 * 20.0;
                d5 += 15.0;
            }
            rectangle2d = ToImageUtil.a(rectangle2d, new Rectangle2d(d2, d3, d4, d5));
        }
        return rectangle2d;
    }

    private static boolean a(@NonNull MMDiagramElement mMDiagramElement) {
        if (mMDiagramElement == null) {
            throw new NullPointerException("element");
        }
        return RuntimeGlobal.sysProp.getBooleanWithDefault("mini_icon.diagram_icon_visibility") && ToImageUtil.b(mMDiagramElement) > 0;
    }

    private static int b(@NonNull MMDiagramElement mMDiagramElement) {
        if (mMDiagramElement == null) {
            throw new NullPointerException("element");
        }
        if (mMDiagramElement instanceof MMGraphicalShape) {
            return ((MMGraphicalShape)mMDiagramElement).getIcons().size();
        }
        return 0;
    }

    private static Rectangle2d a(@NonNull Rectangle2d rectangle2d, @NonNull Rectangle2d rectangle2d2) {
        if (rectangle2d == null) {
            throw new NullPointerException("r1");
        }
        if (rectangle2d2 == null) {
            throw new NullPointerException("r2");
        }
        return (Rectangle2d)ToImageUtil.a((Rectangle2D)rectangle2d, (Rectangle2D)rectangle2d2);
    }

    static Rectangle2D a(@NonNull Rectangle2D rectangle2D, @NonNull Rectangle2D rectangle2D2) {
        if (rectangle2D == null) {
            throw new NullPointerException("r1");
        }
        if (rectangle2D2 == null) {
            throw new NullPointerException("r2");
        }
        if (rectangle2D.isEmpty()) {
            return rectangle2D2;
        }
        if (rectangle2D2.isEmpty()) {
            return rectangle2D;
        }
        Rectangle2d rectangle2d = (Rectangle2d)rectangle2D.clone();
        rectangle2d.add(rectangle2D2);
        return rectangle2d;
    }
}

