/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.golf.control.Command;
import net.astah.golf.draw.GCamera;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.DiagramViewInfo;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Project;
import net.astah.jomt.jcontrol.CloneModelFromPrjCommand;
import net.astah.jomt.jcontrol.OpenDiagramEditorCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.HyperlinkUtil;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMLinkEdge;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.uml.exception.UMLSemanticsException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.uml2.uml.NamedElement;

public class SplitMMToMindmapCommand
extends Command {
    private MMTopicShape a;

    @Override
    public void execute() {
        try {
            Project project = ModelGlobal.prjManager.getCurrentProject();
            IJomtEntityStore iJomtEntityStore = project.doc;
            if (iJomtEntityStore == null) {
                return;
            }
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            if (diagramEditor == null) {
                return;
            }
            if (!(diagramEditor.getDiagram() instanceof MMDiagram)) {
                return;
            }
            MMDiagram mMDiagram = (MMDiagram)diagramEditor.getDiagram();
            DiagramElement[] diagramElementArray = diagramEditor.getSelectedPresentations();
            if (diagramElementArray == null || diagramElementArray.length == 0) {
                return;
            }
            for (int i2 = 0; i2 < diagramElementArray.length; ++i2) {
                if (!(diagramElementArray[i2] instanceof MMTopicShape)) continue;
                this.a = (MMTopicShape)diagramElementArray[i2];
                break;
            }
            if (this.a == null) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                MMDiagram mMDiagram2 = this.a(mMDiagram, iJomtEntityStore);
                MMTopicShape mMTopicShape = mMDiagram2.getRoot();
                HyperlinkUtil.createHyperlink((EObject)this.a, mMTopicShape);
                EditingDomain editingDomain = iJomtEntityStore.getDomain();
                CommandUtils.execute(editingDomain, DestroyCommand.create(editingDomain, this.a.getChildren()));
                iJomtEntityStore.commitTransaction();
                this.a(mMDiagram2);
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                iJomtEntityStore.abortTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    private MMDiagram a(MMDiagram mMDiagram, IEntityStore iEntityStore) throws InterruptedException, RollbackException {
        CloneModelFromPrjCommand cloneModelFromPrjCommand = new CloneModelFromPrjCommand();
        cloneModelFromPrjCommand.doc = iEntityStore;
        NamedElement namedElement = (NamedElement)mMDiagram.getParent();
        cloneModelFromPrjCommand.setParent(namedElement);
        cloneModelFromPrjCommand.setCloneDiagramName(this.a.getText());
        BasicEList<DiagramElement> basicEList = new BasicEList<DiagramElement>();
        basicEList.add(this.a);
        EList<MMTopicShape> eList = this.a.allChildren();
        for (MMTopicShape mMTopicShape : eList) {
            MMTopicShape mMTopicShape2;
            basicEList.add(mMTopicShape);
            for (MMLinkEdge mMLinkEdge : mMTopicShape.getTargetLinks()) {
                mMTopicShape2 = mMLinkEdge.getSourceTopic();
                if (!eList.contains(mMTopicShape2) && !basicEList.contains(mMTopicShape2) || basicEList.contains(mMLinkEdge)) continue;
                basicEList.add(mMLinkEdge);
            }
            for (MMLinkEdge mMLinkEdge : mMTopicShape.getSourceLinks()) {
                mMTopicShape2 = mMLinkEdge.getTargetTopic();
                if (!eList.contains(mMTopicShape2) && !basicEList.contains(mMTopicShape2) || basicEList.contains(mMLinkEdge)) continue;
                basicEList.add(mMLinkEdge);
            }
        }
        return (MMDiagram)cloneModelFromPrjCommand.cloneDiagramFromOtherCommand(namedElement, mMDiagram, basicEList);
    }

    private void a(Diagram diagram) {
        OpenDiagramEditorCommand openDiagramEditorCommand = new OpenDiagramEditorCommand();
        DiagramViewInfo diagramViewInfo = new DiagramViewInfo(diagram, new GCamera());
        openDiagramEditorCommand.setDiagramViewInfo(diagramViewInfo);
        this.callCommand(openDiagramEditorCommand);
    }
}

