/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jcontrol.Z;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;

public class SignalReverseCommand
extends Command {
    protected boolean signalReverse = true;
    protected boolean setSingalReverse = false;

    protected void setSingalReverse(boolean bl) {
        this.signalReverse = bl;
        this.setSingalReverse = true;
    }

    @Override
    public void setArgumentString(String string) {
        if (string != null && string.equalsIgnoreCase("true")) {
            this.setSingalReverse(true);
        }
        if (string != null && string.equalsIgnoreCase("false")) {
            this.setSingalReverse(false);
        }
    }

    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            Object[] objectArray = diagramEditor.getSelectedModels();
            if (objectArray == null || objectArray.length == 0) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    UserObject userObject;
                    Presentation presentation;
                    if (!(objectArray[i2] instanceof UserObject) || (presentation = (userObject = (UserObject)objectArray[i2]).getPresentation()) == null) continue;
                    new Z(this).doSwitch(presentation);
                }
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }
}

