/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.ArrayList;
import java.util.List;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.widget.CFrame;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.PartPresentation;
import net.astah.jmodel.PortPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PropertyChooseDialog;
import net.astah.jomt.jviewElement.DiagramViewElement;
import net.astah.jomt.jviewElement.JomtDiagramViewElement;
import org.eclipse.uml2.uml.Property;

public abstract class ShowPropertyPresentationsCommand
extends Command {
    protected static final double H_FONT = 15.0;
    protected static final double OFFSET = 14.0;
    protected DiagramEditor de = this.a();
    private boolean a = false;

    public void setCreateEditState(boolean bl) {
        this.a = bl;
    }

    private DiagramEditor a() {
        if (JomtGlobal.isNoGUI()) {
            return null;
        }
        return JomtGlobal.viewManager.getCurrentDiagramEditor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        DiagramViewElement diagramViewElement = null;
        if (this.de != null && !this.a && (diagramViewElement = this.de.getDiagramScene().getDiagramViewElement()) instanceof JomtDiagramViewElement) {
            diagramViewElement.setCreateEditState(false);
        }
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        ArrayList<Property> arrayList = new ArrayList<Property>();
        if (this.isShouldShowChooseDialog() && !JomtGlobal.isNoGUI()) {
            CFrame cFrame = (CFrame)JomtGlobal.viewManager.getManagementView().getComponent();
            PropertyChooseDialog propertyChooseDialog = this.createPropertyDialog(cFrame);
            this.setPropertyTableData(propertyChooseDialog);
            propertyChooseDialog.showDialog();
            if (propertyChooseDialog.getResultState() != 1) {
                return;
            }
            arrayList.addAll(propertyChooseDialog.getSelectedResult());
        } else {
            arrayList.addAll(this.getShowElements());
        }
        try {
            boolean bl = false;
            if (!iJomtEntityStore.isInTransaction()) {
                iJomtEntityStore.beginTransaction();
                bl = true;
            }
            this.showProperty(arrayList, this.getSelectPs());
            if (bl) {
                iJomtEntityStore.commitTransaction();
            }
        }
        catch (BadTransactionException badTransactionException) {
            MessageManager.requireBugReport(badTransactionException);
            iJomtEntityStore.abortTransaction();
        }
        catch (Exception exception) {
            iJomtEntityStore.abortTransaction();
            MessageManager.requireBugReport(exception);
        }
        finally {
            if (diagramViewElement != null && !this.a) {
                diagramViewElement.setCreateEditState(true);
            }
        }
    }

    protected List<Property> getShowElements() {
        return new ArrayList<Property>();
    }

    protected abstract PropertyChooseDialog createPropertyDialog(CFrame var1);

    protected abstract String getDialogTitle();

    protected abstract void setPropertyTableData(PropertyChooseDialog var1);

    protected abstract void showProperty(List<Property> var1, JomtPresentation var2);

    protected JomtPresentation getSelectPs() {
        if (this.de != null) {
            Object[] objectArray = this.de.getSelectedModels();
            if (objectArray == null || objectArray.length == 0 || !(objectArray[0] instanceof UserObject)) {
                return null;
            }
            return (JomtPresentation)((UserObject)objectArray[0]).getPresentation();
        }
        return null;
    }

    protected Object isPropertyPsShow(Property property, JomtPresentation jomtPresentation) {
        List<Presentation> list = Presentations.getPresentations(property);
        for (Presentation presentation : list) {
            Object object;
            if (jomtPresentation instanceof ClassifierPresentation) {
                LabelPresentation labelPresentation;
                object = (ClassifierPresentation)jomtPresentation;
                if (presentation instanceof PartPresentation) {
                    labelPresentation = (PartPresentation)presentation;
                    if (object.getSubElements().contains(labelPresentation) && labelPresentation.isVisibility()) {
                        return Boolean.TRUE;
                    }
                } else if (presentation instanceof PortPresentation) {
                    labelPresentation = (PortPresentation)presentation;
                    if (object.getAllClients().contains(labelPresentation) && labelPresentation.isVisibility()) {
                        return Boolean.TRUE;
                    }
                }
            }
            if (!(jomtPresentation instanceof PartPresentation) || (object = this.isPropertyPsShowInPart(jomtPresentation, presentation)) == null || !object.equals(Boolean.TRUE)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Object isPropertyPsShowInPart(JomtPresentation jomtPresentation, Object object) {
        PartPresentation partPresentation = (PartPresentation)jomtPresentation;
        if (object instanceof PortPresentation) {
            PortPresentation portPresentation = (PortPresentation)object;
            if (partPresentation.getAllClients().contains(portPresentation) && portPresentation.isVisibility()) {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    protected String getTitle(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public boolean isShouldShowChooseDialog() {
        return true;
    }
}

