/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.RectPresentation;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;

public class ShiftLocalMovementCommand
extends Command {
    protected RectPresentation[] presentations = null;
    protected Vec2d moveVector = null;

    public void setPresentations(RectPresentation[] rectPresentationArray) {
        this.presentations = rectPresentationArray;
    }

    public void setMoveVector(Vec2d vec2d) {
        this.moveVector = vec2d;
    }

    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            if (iJomtEntityStore == null) {
                return;
            }
            if (this.presentations == null || this.presentations.length == 0) {
                return;
            }
            if (this.moveVector == null) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                for (int i2 = 0; i2 < this.presentations.length; ++i2) {
                    this.presentations[i2].shiftLocalMovement(this.moveVector);
                }
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }
}

