/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.dd.di.DiagramElement;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;

public abstract class SetVisibleCommand
extends Command {
    protected DiagramElement[] diagramElements = null;
    protected boolean visible = true;
    protected boolean setVisibility = false;

    public void setPresentations(DiagramElement[] diagramElementArray) {
        this.diagramElements = diagramElementArray;
    }

    public void setVisibility(boolean bl) {
        this.visible = bl;
        this.setVisibility = true;
    }

    @Override
    public void setArgumentString(String string) {
        if (string != null && string.equalsIgnoreCase("true")) {
            this.setVisibility(true);
        }
        if (string != null && string.equalsIgnoreCase("false")) {
            this.setVisibility(false);
        }
    }

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            DiagramEditor diagramEditor;
            if (this.diagramElements == null && (diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor()) != null) {
                this.diagramElements = diagramEditor.getSelectedPresentations();
            }
            if (this.diagramElements == null || !this.allowCaseOfNoPresentation() && this.diagramElements.length == 0) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                this.setVisibility();
                this.unselect();
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected void setVisibility() {
        this.setVisibilityForPresentations();
    }

    protected void setVisibilityForPresentations() {
        for (DiagramElement diagramElement : this.diagramElements) {
            if (!this.isPresentationValid(diagramElement)) continue;
            boolean bl = this.getVisibility(diagramElement);
            if (this.setVisibility) {
                if (bl == this.visible) continue;
                this.setVisibility(diagramElement, this.visible);
                continue;
            }
            this.setVisibility(diagramElement, !bl);
        }
    }

    protected void unselect() {
    }

    protected boolean isPresentationValid(DiagramElement diagramElement) {
        return true;
    }

    protected abstract boolean getVisibility(DiagramElement var1);

    protected abstract void setVisibility(DiagramElement var1, boolean var2);

    protected boolean allowCaseOfNoPresentation() {
        return false;
    }
}

