/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.astah.dd.di.DiagramElement;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IStyleMapOwner;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.StyleSupport;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.mindmap.edit.layout.MMStyleMapOwner;
import net.astah.notation.mindmap.edit.layout.MMStyleSupport;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;

public abstract class SetStyleValueCommand
extends net.astah.golf.control.Command {
    protected DiagramElement[] styleMapOwners = null;
    protected String newValue = null;

    @Override
    public void setArgumentString(String string) {
        this.newValue = this.isValidStyle(string) ? string : this.getDefaultStyle();
    }

    protected abstract String getDefaultStyle();

    public abstract boolean isValidStyle(String var1);

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            DiagramEditor diagramEditor = null;
            if (this.styleMapOwners == null && (diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor()) != null) {
                this.styleMapOwners = diagramEditor.getSelectedPresentations();
            }
            if (this.styleMapOwners == null || this.styleMapOwners.length == 0) {
                return;
            }
            Command command = null;
            List<DiagramElement> list = this.a(this.styleMapOwners);
            if (list.isEmpty() && !(command = this.createCommand(Arrays.asList(this.styleMapOwners))).canExecute()) {
                command.dispose();
                return;
            }
            try {
                if (command == null) {
                    if (this.useTransaction) {
                        iJomtEntityStore.beginTransaction();
                    }
                    for (DiagramElement diagramElement : list) {
                        if (diagramElement instanceof IStyleMapOwner) {
                            this.setNewValue((IStyleMapOwner)((Object)diagramElement), this.getKeyOfStyle(), this.getNewValue());
                            continue;
                        }
                        this.setNewValue(diagramElement, this.getKeyOfStyle(), this.getNewValue());
                    }
                    this.postOperationBeforeCommit(diagramEditor, list);
                    if (this.useTransaction) {
                        iJomtEntityStore.commitTransaction();
                    }
                    this.postOperationAfterCommit(diagramEditor, list);
                } else {
                    if (this.useTransaction) {
                        iJomtEntityStore.beginTransaction();
                    }
                    CommandUtils.execute(iJomtEntityStore.getDomain(), command);
                    if (this.useTransaction) {
                        iJomtEntityStore.commitTransaction();
                    }
                }
                diagramEditor.repaintCanvas();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected String getNewValue() {
        return this.newValue;
    }

    private List<DiagramElement> a(DiagramElement[] diagramElementArray) {
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>();
        String string = this.getKeyOfStyle();
        for (int i2 = 0; i2 < diagramElementArray.length; ++i2) {
            DiagramElement diagramElement = diagramElementArray[i2];
            boolean bl = false;
            if (diagramElement instanceof IStyleMapOwner) {
                if (this.isValidTarget((IStyleMapOwner)((Object)diagramElement), string)) {
                    bl = !this.hasSameStyleValue((IStyleMapOwner)((Object)diagramElement), string, this.newValue);
                }
            } else if (this.isValidTarget(diagramElement, string)) {
                boolean bl2 = bl = !this.hasSameStyleValue(diagramElement, string, this.newValue);
            }
            if (!bl) continue;
            arrayList.add(diagramElement);
        }
        return arrayList;
    }

    public boolean isValidTarget(IStyleMapOwner iStyleMapOwner, String string) {
        return iStyleMapOwner.isSupportedStyleKey(string);
    }

    public boolean isValidTarget(DiagramElement diagramElement, String string) {
        return MMStyleMapOwner.isSupportedStyleKey(diagramElement, string);
    }

    protected abstract boolean hasSameStyleValue(IStyleMapOwner var1, String var2, String var3);

    protected boolean hasSameStyleValue(DiagramElement diagramElement, String string, String string2) {
        return true;
    }

    protected void setNewValue(IStyleMapOwner iStyleMapOwner, String string, String string2) {
        StyleSupport.setValueWithSetChanged(iStyleMapOwner, string, string2);
    }

    protected void setNewValue(DiagramElement diagramElement, String string, String string2) {
        MMStyleSupport.setValueWithSetChanged(diagramElement, string, string2);
    }

    protected abstract String getKeyOfStyle();

    protected void postOperationBeforeCommit(DiagramEditor diagramEditor, List<DiagramElement> list) {
    }

    protected void postOperationAfterCommit(DiagramEditor diagramEditor, List<DiagramElement> list) {
    }

    public void setStyleMapOwners(DiagramElement[] diagramElementArray) {
        this.styleMapOwners = diagramElementArray;
    }

    protected boolean isSameValue(String string, String string2) {
        if (string != null && string.equals(string2)) {
            return true;
        }
        return string == null && string2 == null;
    }

    protected Command createCommand(List<DiagramElement> list) {
        return UnexecutableCommand.INSTANCE;
    }
}

