/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Iterables;
import java.util.List;
import net.astah.dd.dg.DGPackage;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Rectangle;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.model.IStyleMapOwner;
import net.astah.jmodel.StyleSupport;
import net.astah.jomt.jcontrol.SetStyleValueCommand;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.notation.GraphicalShape;
import net.astah.notation.provider.graphics.DGSetSizeHelper;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class SetRectTypeCommand
extends SetStyleValueCommand {
    @Override
    protected boolean hasSameStyleValue(IStyleMapOwner iStyleMapOwner, String string, String string2) {
        String string3 = StyleSupport.getRectTypeWithAuto(iStyleMapOwner);
        if (string2 != null && string2.equals(string3)) {
            return true;
        }
        return string2 == null && string3 == null;
    }

    @Override
    protected String getKeyOfStyle() {
        return "rect.type";
    }

    @Override
    protected String getDefaultStyle() {
        return null;
    }

    @Override
    public boolean isValidTarget(IStyleMapOwner iStyleMapOwner, String string) {
        if ("oval".equals(StyleSupport.getRectTypeWithAuto(iStyleMapOwner))) {
            return false;
        }
        return super.isValidTarget(iStyleMapOwner, string);
    }

    @Override
    public boolean isValidStyle(String string) {
        return "round".equals(string) || string == null;
    }

    @Override
    protected Command createCommand(List<DiagramElement> list) {
        EditingDomain editingDomain = ModelGlobal.prjManager.getCurrentProject().doc.getDomain();
        CompoundCommand compoundCommand = new CompoundCommand();
        for (GraphicalShape graphicalShape : Iterables.filter(list, GraphicalShape.class)) {
            GraphicalElement graphicalElement;
            Object object = SetCommand.UNSET_VALUE;
            if ("round".equals(this.newValue) && (graphicalElement = graphicalShape.getFigure()) instanceof Rectangle) {
                object = DGSetSizeHelper.getCornerRadius(((Rectangle)graphicalElement).getBounds());
            }
            compoundCommand.append(SetCommand.create(editingDomain, graphicalShape.getFigure(), DGPackage.Literals.RECTANGLE__CORNER_RADIUS, object));
        }
        return compoundCommand;
    }
}

