/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.dd.di.DiagramElement;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.PackagePresentation;
import net.astah.jmodel.Presentation;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;

public class SetPackageNameInBodyCommand
extends Command {
    protected DiagramElement[] presentations = null;
    protected boolean inBody = true;
    protected boolean setInBody = false;

    public void setPresentations(Presentation[] presentationArray) {
        this.presentations = presentationArray;
    }

    public void setInBody(boolean bl) {
        this.inBody = bl;
        this.setInBody = true;
    }

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            DiagramEditor diagramEditor;
            if (this.presentations == null && (diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor()) != null) {
                this.presentations = diagramEditor.getSelectedPresentations();
            }
            if (this.presentations == null || this.presentations.length == 0) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                for (int i2 = 0; i2 < this.presentations.length; ++i2) {
                    if (!(this.presentations[i2] instanceof PackagePresentation)) continue;
                    PackagePresentation packagePresentation = (PackagePresentation)this.presentations[i2];
                    boolean bl = packagePresentation.isWithinBodyName();
                    if (this.setInBody) {
                        if (bl == this.inBody) continue;
                        packagePresentation.setWithinBodyName(this.inBody);
                        continue;
                    }
                    packagePresentation.setWithinBodyName(!bl);
                }
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }
}

