/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import net.astah.dd.di.DiagramElement;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.notation.mindmap.edit.layout.MMTopicSymmetryRelocater;

public class SetMMTopicLevelCommand
extends Command {
    private int a = -1;

    @Override
    public void setArgumentString(String string) {
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string);
                if (n2 >= 0) {
                    this.a = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void execute() {
        if (this.a == -1) {
            return;
        }
        Project project = ModelGlobal.prjManager.getCurrentProject();
        if (project == null || project.doc == null) {
            return;
        }
        IJomtEntityStore iJomtEntityStore = project.doc;
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        if (diagramEditor == null || !(diagramEditor.getDiagram() instanceof MMDiagram)) {
            return;
        }
        MMTopicShape mMTopicShape = this.a(diagramEditor.getSelectedPresentations());
        if (mMTopicShape == null) {
            return;
        }
        try {
            if (this.useTransaction) {
                iJomtEntityStore.beginTransaction();
            }
            MMDiagram mMDiagram = (MMDiagram)diagramEditor.getDiagram();
            this.a(mMDiagram, mMTopicShape);
            if (this.useTransaction) {
                iJomtEntityStore.commitTransaction();
            }
        }
        catch (BadTransactionException badTransactionException) {
            if (this.useTransaction) {
                iJomtEntityStore.abortTransaction();
            }
            MessageManager.requireBugReport(badTransactionException);
        }
        catch (Exception exception) {
            if (this.useTransaction) {
                iJomtEntityStore.abortTransaction();
            }
            MessageManager.requireBugReport(exception);
        }
    }

    private void a(MMDiagram mMDiagram, MMTopicShape mMTopicShape) {
        new MMTopicSymmetryRelocater(mMDiagram).changeLevel(mMTopicShape, this.a);
    }

    private MMTopicShape a(DiagramElement[] diagramElementArray) {
        for (MMTopicShape mMTopicShape : Iterables.filter(Arrays.asList(diagramElementArray), MMTopicShape.class)) {
            if (mMTopicShape.isRoot() || !mMTopicShape.isTop()) continue;
            return mMTopicShape;
        }
        return null;
    }
}

