/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.dd.di.DiagramElement;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.edit.layout.DiagramElementOperations;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.notation.mindmap.edit.layout.MMStyleMapOwner;

public class SetMMDefaultStyleCommand
extends Command {
    @Override
    public void execute() {
        try {
            Project project = ModelGlobal.prjManager.getCurrentProject();
            IJomtEntityStore iJomtEntityStore = project.doc;
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            Object[] objectArray = diagramEditor.getSelectedModels();
            if (objectArray == null || objectArray.length == 0) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                int n2 = 0;
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    DiagramElement diagramElement = DiagramElementOperations.getDiagramElement(objectArray[i2]);
                    MMStyleMapOwner.clearStyleMap(diagramElement);
                    if (diagramElement instanceof MMTopicShape) {
                        ((MMTopicShape)diagramElement).setAutoResize(true);
                    }
                    ++n2;
                }
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }
}

