/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jcontrol.SetVisibleCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.edit.layout.DiagramElementOperations;
import net.astah.notation.mindmap.MMBoundaryShape;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMNotationFactory;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.notation.mindmap.edit.layout.MMStyleSupport;
import net.astah.uml.exception.IllegalModelTypeException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetMMBoundaryVisibleCommand
extends SetVisibleCommand {
    private static final Logger a = LoggerFactory.getLogger(SetMMBoundaryVisibleCommand.class);

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            MMTopicShape[] mMTopicShapeArray;
            Diagram diagram = null;
            if (this.diagramElements == null && (mMTopicShapeArray = JomtGlobal.viewManager.getCurrentDiagramEditor()) != null) {
                diagram = mMTopicShapeArray.getDiagram();
                this.diagramElements = mMTopicShapeArray.getSelectedPresentations();
            }
            if ((mMTopicShapeArray = this.a(this.diagramElements)) == null || mMTopicShapeArray.length == 0) {
                return;
            }
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                for (MMTopicShape mMTopicShape : mMTopicShapeArray) {
                    boolean bl = this.a(mMTopicShape);
                    this.setVisibility(iJomtEntityStore, mMTopicShape, bl, false);
                }
                if (diagram instanceof MMDiagram) {
                    // empty if block
                }
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    public void setVisibility(IEntityStore iEntityStore, MMTopicShape mMTopicShape, boolean bl, boolean bl2) throws IllegalModelTypeException {
        Diagram diagram;
        MMBoundaryShape mMBoundaryShape = mMTopicShape.getBoundary();
        if (bl && mMBoundaryShape == null) {
            this.a(mMTopicShape, bl);
        } else if (!bl && mMBoundaryShape != null) {
            this.a(iEntityStore, mMBoundaryShape);
        }
        if (!bl2 || (diagram = DiagramElementOperations.getDiagram(mMTopicShape)) instanceof MMDiagram) {
            // empty if block
        }
    }

    private void a(MMTopicShape mMTopicShape, boolean bl) {
        MMBoundaryShape mMBoundaryShape = MMNotationFactory.eINSTANCE.createMMBoundaryShape();
        mMBoundaryShape.setTopic(mMTopicShape);
        mMTopicShape.setBoundary(mMBoundaryShape);
        this.setVisibility(mMBoundaryShape, bl);
        MMDiagram mMDiagram = (MMDiagram)mMTopicShape.getOwningElement();
        mMDiagram.getMMOwnedElements().add(mMBoundaryShape);
    }

    private void a(IEntityStore iEntityStore, MMBoundaryShape mMBoundaryShape) {
        EditingDomain editingDomain = iEntityStore.getDomain();
        try {
            CommandUtils.execute(editingDomain, DestroyCommand.create(editingDomain, mMBoundaryShape));
        }
        catch (InterruptedException | RollbackException exception) {
            a.error("An error has occurred.", exception);
        }
    }

    private boolean a(MMTopicShape mMTopicShape) {
        boolean bl = MMStyleSupport.isShowBoundary(mMTopicShape);
        return this.setVisibility ? this.visible : !bl;
    }

    private MMTopicShape[] a(DiagramElement[] diagramElementArray) {
        if (diagramElementArray == null) {
            return null;
        }
        BasicEList<DiagramElement> basicEList = new BasicEList<DiagramElement>();
        for (DiagramElement diagramElement : diagramElementArray) {
            if (!this.isPresentationValid(diagramElement)) continue;
            basicEList.add(diagramElement);
        }
        return basicEList.toArray(new MMTopicShape[0]);
    }

    @Override
    protected boolean isPresentationValid(DiagramElement diagramElement) {
        if (diagramElement instanceof MMTopicShape) {
            MMTopicShape mMTopicShape = (MMTopicShape)diagramElement;
            return !mMTopicShape.isTop();
        }
        return false;
    }

    @Override
    protected boolean getVisibility(DiagramElement diagramElement) {
        return ((MMBoundaryShape)diagramElement).isVisible();
    }

    @Override
    protected void setVisibility(DiagramElement diagramElement, boolean bl) {
        MMBoundaryShape mMBoundaryShape = (MMBoundaryShape)diagramElement;
        MMStyleSupport.showBoundary(mMBoundaryShape.getTopic(), bl);
    }
}

