/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.base.Strings;
import java.util.List;
import net.astah.dd.dg.DGPackage;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.command.SetStyleCommand;
import net.astah.golf.model.IStyleMapOwner;
import net.astah.jmodel.StyleSupport;
import net.astah.jomt.jcontrol.SetStyleValueCommand;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.notation.mindmap.edit.layout.MMStyleSupport;
import net.astah.notation.resource.NotationResources;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class SetLineArrowCommand
extends SetStyleValueCommand {
    @Override
    protected boolean hasSameStyleValue(IStyleMapOwner iStyleMapOwner, String string, String string2) {
        String string3 = StyleSupport.getLineArrowTypeWithAuto(iStyleMapOwner);
        if (string2 != null && string2.equals(string3)) {
            return true;
        }
        return string2 == null && string3 == null;
    }

    @Override
    protected boolean hasSameStyleValue(DiagramElement diagramElement, String string, String string2) {
        String string3 = MMStyleSupport.getLineArrowTypeWithAuto(diagramElement);
        if (string2 != null && string2.equals(string3)) {
            return true;
        }
        return string2 == null && string3 == null;
    }

    @Override
    protected String getKeyOfStyle() {
        return "line.arrow.type";
    }

    @Override
    protected String getDefaultStyle() {
        return "noarrow";
    }

    @Override
    public boolean isValidStyle(String string) {
        return "noarrow".equals(string) || "endarrow".equals(string) || "startarrow".equals(string) || "botharrow".equals(string);
    }

    @Override
    protected Command createCommand(List<DiagramElement> list) {
        EditingDomain editingDomain = ModelGlobal.prjManager.getCurrentProject().doc.getDomain();
        CompoundCommand compoundCommand = new CompoundCommand();
        for (DiagramElement diagramElement : list) {
            Object object;
            Object object2;
            switch (Strings.nullToEmpty(this.newValue)) {
                case "startarrow": {
                    object2 = this.getStartMarker(diagramElement);
                    object = SetCommand.UNSET_VALUE;
                    break;
                }
                case "endarrow": {
                    object2 = SetCommand.UNSET_VALUE;
                    object = this.getEndMarker(diagramElement);
                    break;
                }
                case "botharrow": {
                    object2 = this.getStartMarker(diagramElement);
                    object = this.getEndMarker(diagramElement);
                    break;
                }
                default: {
                    object2 = SetCommand.UNSET_VALUE;
                    object = SetCommand.UNSET_VALUE;
                }
            }
            compoundCommand.append(SetStyleCommand.create(editingDomain, null, diagramElement, DGPackage.Literals.MARKED_ELEMENT__START_MARKER, object2));
            compoundCommand.append(SetStyleCommand.create(editingDomain, null, diagramElement, DGPackage.Literals.MARKED_ELEMENT__END_MARKER, object));
        }
        return compoundCommand.unwrap();
    }

    protected Object getStartMarker(EObject eObject) {
        return NotationResources.getLibraryMarker(eObject, "Arrowhead-Start");
    }

    protected Object getEndMarker(EObject eObject) {
        return NotationResources.getLibraryMarker(eObject, "Arrowhead-End");
    }
}

