/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.astah.dd.dg.DGFactory;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Group;
import net.astah.dd.dg.Style;
import net.astah.dd.dg.Text;
import net.astah.dd.dg.util.DGStyleResolver;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.Shape;
import net.astah.dd.di.edit.command.SetStyleCommand;
import net.astah.dd.di.edit.provider.IItemGraphicalStyleProvider;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.model.IStyleMapOwner;
import net.astah.golf.view.GFontChooser;
import net.astah.golf.view.swing.FontChooserPeer;
import net.astah.golf.widget.CComponent;
import net.astah.jmodel.ActivityPartitionPresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.NotePresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.StyleSupport;
import net.astah.jmodel.TaggedValueUtilities;
import net.astah.jmodel.TextPresentation;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jcontrol.Messages;
import net.astah.jomt.jcontrol.SetStyleValueCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.FontManager;
import net.astah.jomt.jutil.JFont;
import net.astah.jomt.jutil.JomtFontUtilities;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.model.extension.Preferences;
import net.astah.notation.GraphicalShape;
import net.astah.notation.editor.GraphicalStyles;
import net.astah.notation.mindmap.MMDiagramElement;
import net.astah.notation.mindmap.MMGraphicalShape;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.notation.mindmap.edit.layout.MMStyleMapOwner;
import net.astah.notation.mindmap.edit.layout.MMStyleSupport;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.uml2.uml.util.PartitionUtil;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;

public class SetFontCommand
extends SetStyleValueCommand {
    protected DiagramElement[] elements;
    private JFont a = null;
    private IEntityStore b = null;

    public void setPresentations(DiagramElement[] diagramElementArray) {
        this.elements = diagramElementArray;
    }

    public void setDoc(IEntityStore iEntityStore) {
        this.b = iEntityStore;
    }

    @Override
    public void execute() {
        if (this.b == null) {
            this.b = ModelGlobal.prjManager.getCurrentProject().doc;
        }
        if (this.b.isInTransaction() && this.useTransaction) {
            return;
        }
        try {
            int n2;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (this.elements == null && JomtGlobal.viewManager != null && (object4 = JomtGlobal.viewManager.getCurrentDiagramEditor()) != null) {
                this.elements = ((DiagramEditor)object4).getSelectedPresentations();
            }
            this.elements = this.omitPresentationWithoutFontStyle(this.elements);
            if (this.elements == null || this.elements.length == 0) {
                JomtGlobal.modeManager.changeButtonsState(false);
                return;
            }
            object4 = this.b.getDomain();
            ResourceSet resourceSet = object4.getResourceSet();
            Project project = ProjectManagerAdapter.getRootProject(resourceSet);
            Preferences preferences = project.getPreferences();
            if (this.a == null) {
                object3 = JomtGlobal.viewManager.getManagementView().getComponent();
                GFontChooser.setParentComponent((CComponent)object3);
                object2 = GFontChooser.getInstance();
                object = null;
                if (this.elements != null) {
                    object = this.elements[0];
                }
                ((GFontChooser)object2).setWithoutStyle(false);
                ((GFontChooser)object2).setWithLines(false);
                FontChooserPeer fontChooserPeer = ((GFontChooser)object2).getFontChooserPeer();
                fontChooserPeer.setShowAutoNameCheckBox(true);
                fontChooserPeer.setShowAutoSizeCheckBox(true);
                fontChooserPeer.setShowAutoStyleCheckBox(true);
                this.a((DiagramElement)object, fontChooserPeer);
                JFont jFont = this.a((DiagramElement)object);
                if (jFont == null) {
                    jFont = JomtFontUtilities.getProjectJFont();
                }
                if (jFont == null) {
                    jFont = JomtFontUtilities.getDefaultJFont();
                }
                fontChooserPeer.setCurrentJfont(FontManager.getFontFromJFontWithCash(jFont));
                fontChooserPeer.setCurrentUnderline(jFont.isUnderlined());
                fontChooserPeer.setCurrentStrikeThrough(jFont.isStruckthrough());
                if (object != null) {
                    this.b((DiagramElement)object, fontChooserPeer);
                } else if (preferences != null) {
                    this.a(preferences, fontChooserPeer);
                }
                int n3 = 6;
                int n4 = 96;
                ((GFontChooser)object2).initialize(6, 96);
                if (this.a == null) {
                    n2 = ((GFontChooser)object2).show(Messages.set_font_command_tell_font_size_error_message);
                    if (n2 == ((GFontChooser)object2).getCancel() || n2 == ((GFontChooser)object2).getError()) {
                        return;
                    }
                    this.a = JomtFontUtilities.getSelectedJFont((GFontChooser)object2);
                }
            }
            if (this.a == null) {
                return;
            }
            object3 = JomtFontUtilities.getProjectJFont(this.b);
            object2 = null;
            if (this.elements != null && !(object = Arrays.asList(this.elements).stream().filter(diagramElement -> diagramElement instanceof Shape).collect(Collectors.toList())).isEmpty() && !(object2 = this.createCommand((List<DiagramElement>)object)).canExecute()) {
                object2.dispose();
                return;
            }
            try {
                if (object2 == null) {
                    if (this.useTransaction) {
                        this.b.beginTransaction();
                    }
                    double d2 = 0.0;
                    if (this.elements != null) {
                        for (int i2 = 0; i2 < this.elements.length; ++i2) {
                            DiagramElement diagramElement2 = this.elements[i2];
                            if (diagramElement2 instanceof Presentation && !((Presentation)diagramElement2).isSupportedStyleKey("font")) continue;
                            if (diagramElement2 instanceof TextPresentation) {
                                StyleSupport.setJFont((IStyleMapOwner)((Object)diagramElement2), this.a);
                            } else if (diagramElement2 instanceof MMTopicShape) {
                                MMStyleSupport.setJFont(diagramElement2, this.a);
                            } else if (diagramElement2 instanceof NotePresentation) {
                                StyleSupport.setJFont((IStyleMapOwner)((Object)diagramElement2), this.a);
                            }
                            if (!(this.elements[i2] instanceof ActivityPartitionPresentation)) continue;
                            ActivityPartitionPresentation activityPartitionPresentation = (ActivityPartitionPresentation)this.elements[i2];
                            d2 = JomtFontUtilities.compareLabelSizeWithFont(FontManager.getFontFromJFontWithCash((JFont)object3), FontManager.getFontFromJFontWithCash(this.a), activityPartitionPresentation.getLabel());
                        }
                    }
                    if (!this.a().isEmpty()) {
                        for (Diagram diagram : Iterables.filter(this.a(), UMLDiagram.class)) {
                            if (!(diagram instanceof UMLActivityDiagram)) continue;
                            UMLActivityDiagram uMLActivityDiagram = (UMLActivityDiagram)diagram;
                            if (d2 == 0.0) continue;
                            n2 = uMLActivityDiagram.getVerticalMaxLevel() + 1;
                            int n5 = uMLActivityDiagram.getHorizontalMaxLevel() + 1;
                            double d3 = (double)n5 * d2;
                            double d4 = (double)n2 * d2;
                            PartitionUtil.moveContentsAndOtherPresentation(uMLActivityDiagram, d3, true);
                            PartitionUtil.moveContentsAndOtherPresentation(uMLActivityDiagram, d4, false);
                            PartitionUtil.resizeAllPartitionPsHavingNoChild(uMLActivityDiagram);
                        }
                    }
                    if (this.useTransaction) {
                        this.b.commitTransaction();
                    }
                } else {
                    if (this.useTransaction) {
                        this.b.beginTransaction();
                    }
                    CommandUtils.execute((EditingDomain)object4, (Command)object2);
                    if (this.useTransaction) {
                        this.b.commitTransaction();
                    }
                }
                JomtGlobal.modeManager.changeButtonsState(false);
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    this.b.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    this.b.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    private JFont a(DiagramElement diagramElement) {
        if (diagramElement instanceof IStyleMapOwner) {
            return StyleSupport.getJFontWithAuto((IStyleMapOwner)((Object)diagramElement));
        }
        if (diagramElement instanceof MMGraphicalShape) {
            return this.a((MMGraphicalShape)diagramElement);
        }
        if (diagramElement instanceof MMDiagramElement) {
            return MMStyleSupport.getJFontWithAuto(diagramElement);
        }
        return null;
    }

    private JFont a(MMGraphicalShape mMGraphicalShape) {
        int n2;
        String string;
        JFont jFont = JomtFontUtilities.getProjectJFont();
        String string2 = this.a(mMGraphicalShape, "font.name");
        if (Strings.isNullOrEmpty(string2)) {
            string2 = jFont.getFontName();
        }
        if (Strings.isNullOrEmpty(string = this.a(mMGraphicalShape, "font.style"))) {
            string = jFont.getFontStyle();
        }
        if ((n2 = this.b(mMGraphicalShape)) == -1) {
            n2 = jFont.getFontSize();
        }
        return new JFont(string2, string, n2);
    }

    private void a(DiagramElement diagramElement, FontChooserPeer fontChooserPeer) {
        Text text;
        String string = "";
        if (diagramElement != null && diagramElement instanceof TextPresentation) {
            TextPresentation textPresentation = (TextPresentation)diagramElement;
            string = textPresentation.getLabel();
        } else if (diagramElement != null && diagramElement instanceof MMTopicShape) {
            string = ((MMTopicShape)diagramElement).getText();
        } else if (diagramElement != null && diagramElement instanceof GraphicalShape && (text = this.a((GraphicalShape)diagramElement)) != null) {
            this.newValue = string = text.getData();
        }
        if (string != null && !string.equals("")) {
            fontChooserPeer.setSampleString(string);
        }
    }

    private void a(Preferences preferences, FontChooserPeer fontChooserPeer) {
        fontChooserPeer.setAutoName(preferences.getBooleanValue("font.name.auto", true));
        fontChooserPeer.setAutoStyle(preferences.getBooleanValue("font.style.auto", true));
        fontChooserPeer.setAutoSize(preferences.getBooleanValue("font.size.auto", true));
    }

    private void b(DiagramElement diagramElement, FontChooserPeer fontChooserPeer) {
        String string = this.c(diagramElement, "font.name");
        fontChooserPeer.setAutoFontName(string);
        if (!fontChooserPeer.getSelectedFont().getFontName().equals(string)) {
            fontChooserPeer.setAutoName(false);
        } else if (diagramElement instanceof MMGraphicalShape) {
            String string2 = this.a((MMGraphicalShape)diagramElement, "font.name");
            if (string2.equals(string)) {
                fontChooserPeer.setAutoName(true);
            }
        } else if (this.b(diagramElement, "font.name") == null) {
            fontChooserPeer.setAutoName(true);
        } else if (this.b(diagramElement, "font.name.auto") != null) {
            boolean bl = Boolean.valueOf(this.b(diagramElement, "font.name.auto"));
            fontChooserPeer.setAutoName(bl);
        }
        String string3 = this.c(diagramElement, "font.style");
        fontChooserPeer.setAutoFontStyle(string3);
        if (!FontManager.getJFontFromFont(fontChooserPeer.getSelectedFont()).getFontStyle().equals(string3)) {
            fontChooserPeer.setAutoStyle(false);
        } else if (diagramElement instanceof MMGraphicalShape) {
            String string4 = this.a((MMGraphicalShape)diagramElement, "font.style");
            if (string4.equals(string3)) {
                fontChooserPeer.setAutoStyle(true);
            }
        } else if (this.b(diagramElement, "font.style") == null) {
            fontChooserPeer.setAutoStyle(true);
        } else if (this.b(diagramElement, "font.style.auto") != null) {
            boolean bl = Boolean.valueOf(this.b(diagramElement, "font.style.auto"));
            fontChooserPeer.setAutoStyle(bl);
        }
        String string5 = this.c(diagramElement, "font.size");
        fontChooserPeer.setAutoFontSize(Integer.parseInt(string5));
        if (FontManager.getJFontFromFont(fontChooserPeer.getSelectedFont()).getFontSize() != Integer.parseInt(string5)) {
            fontChooserPeer.setAutoSize(false);
        } else if (diagramElement instanceof MMGraphicalShape) {
            if (Integer.valueOf(string5).intValue() == this.b((MMGraphicalShape)diagramElement)) {
                fontChooserPeer.setAutoSize(true);
            }
        } else if (this.a(diagramElement, "font.size") == -1) {
            fontChooserPeer.setAutoSize(true);
        } else if (this.b(diagramElement, "font.size.auto") != null) {
            boolean bl = Boolean.valueOf(this.b(diagramElement, "font.size.auto"));
            fontChooserPeer.setAutoSize(bl);
        }
    }

    private int a(DiagramElement diagramElement, String string) {
        if (diagramElement instanceof IStyleMapOwner) {
            return StyleSupport.getValueInteger((IStyleMapOwner)((Object)diagramElement), "font.size");
        }
        if (diagramElement instanceof MMDiagramElement) {
            return MMStyleSupport.getValueInteger(diagramElement, string);
        }
        return -1;
    }

    private int b(MMGraphicalShape mMGraphicalShape) {
        Text text = this.a((GraphicalShape)mMGraphicalShape);
        if (text != null) {
            Style style = this.a(text);
            if (style == null) {
                return -1;
            }
            return (int)style.getFontSize();
        }
        return -1;
    }

    private String b(DiagramElement diagramElement, String string) {
        if (diagramElement instanceof IStyleMapOwner) {
            return StyleSupport.getValueString((IStyleMapOwner)((Object)diagramElement), string);
        }
        if (diagramElement instanceof MMDiagramElement) {
            return MMStyleSupport.getValueString(diagramElement, string);
        }
        return null;
    }

    private String a(MMGraphicalShape mMGraphicalShape, String string) {
        Text text = this.a((GraphicalShape)mMGraphicalShape);
        if (text != null) {
            if (string == "font.name") {
                return DGStyleResolver.getInstance(mMGraphicalShape).resolveFontName(mMGraphicalShape.getFigure());
            }
            if (string == "font.style") {
                Style style = DGFactory.eINSTANCE.createStyle();
                style.setFontBold(DGStyleResolver.getInstance(mMGraphicalShape).resolveFontBold(mMGraphicalShape.getFigure()));
                style.setFontItalic(DGStyleResolver.getInstance(mMGraphicalShape).resolveFontItalic(mMGraphicalShape.getFigure()));
                int n2 = this.a(style);
                return FontManager.getFontStyleString(n2);
            }
            if (string == "font.size") {
                return Double.toString(DGStyleResolver.getInstance(mMGraphicalShape).resolveFontSize(mMGraphicalShape.getFigure()));
            }
        }
        return null;
    }

    private int a(Style style) {
        return (style.isFontBold() ? 1 : 0) | (style.isFontItalic() ? 2 : 0);
    }

    private Style a(GraphicalElement graphicalElement) {
        if (graphicalElement.getLocalStyles().isEmpty()) {
            return null;
        }
        Style style = (Style)graphicalElement.getLocalStyles().get(0);
        return style;
    }

    private Text a(GraphicalShape graphicalShape) {
        GraphicalElement graphicalElement = graphicalShape.getFigure();
        if (!(graphicalElement instanceof Group)) {
            return null;
        }
        Group group = (Group)graphicalElement;
        Text text = Iterables.getFirst(Iterables.filter(group.getMembers(), Text.class), null);
        return text;
    }

    private String c(DiagramElement diagramElement, String string) {
        if (diagramElement instanceof IStyleMapOwner) {
            return StyleSupport.getDefaultStyleFromDiagramOrProjectOrSystem((IStyleMapOwner)((Object)diagramElement), string);
        }
        if (diagramElement instanceof MMGraphicalShape) {
            JFont jFont = JomtFontUtilities.getProjectJFont();
            if (string == "font.name") {
                return jFont.getFontName();
            }
            if (string == "font.style") {
                return jFont.getFontStyle();
            }
            if (string == "font.size") {
                return String.valueOf(jFont.getFontSize());
            }
        } else {
            if (diagramElement instanceof MMDiagramElement) {
                return MMStyleMapOwner.getDefaultStyleFromSystem(diagramElement, string);
            }
            if (diagramElement instanceof Shape) {
                JFont jFont = JomtFontUtilities.getProjectJFont();
                if (string == "font.name") {
                    return jFont.getFontName();
                }
                if (string == "font.style") {
                    return jFont.getFontStyle();
                }
                if (string == "font.size") {
                    return String.valueOf(jFont.getFontSize());
                }
            }
        }
        return null;
    }

    private List<Diagram> a() {
        ArrayList<Diagram> arrayList = new ArrayList<Diagram>();
        if (this.elements != null) {
            for (int i2 = 0; i2 < this.elements.length; ++i2) {
                DiagramElement diagramElement = this.elements[i2];
                if (!(diagramElement instanceof ActivityPartitionPresentation) || arrayList.contains(((ActivityPartitionPresentation)diagramElement).getDiagram())) continue;
                arrayList.add(((ActivityPartitionPresentation)diagramElement).getDiagram());
            }
        }
        return arrayList;
    }

    protected DiagramElement[] omitPresentationWithoutFontStyle(DiagramElement[] diagramElementArray) {
        if (diagramElementArray == null) {
            return null;
        }
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>();
        for (int i2 = 0; i2 < diagramElementArray.length; ++i2) {
            EObject eObject;
            DiagramElement diagramElement = diagramElementArray[i2];
            if (diagramElement instanceof IStyleMapOwner) {
                eObject = (IStyleMapOwner)((Object)diagramElement);
                if (!eObject.isSupportedStyleKey("font")) continue;
                arrayList.add(diagramElement);
                continue;
            }
            if (diagramElement instanceof MMGraphicalShape) {
                eObject = ((MMGraphicalShape)diagramElement).getFigure();
                if (!(eObject instanceof Group) || Iterables.getFirst(Iterables.filter(((Group)eObject).getMembers(), Text.class), null) == null) continue;
                arrayList.add(diagramElement);
                continue;
            }
            if (diagramElement instanceof MMDiagramElement) {
                if (!MMStyleMapOwner.isSupportedStyleKey(diagramElement, "font")) continue;
                arrayList.add(diagramElement);
                continue;
            }
            if (!(diagramElement instanceof Shape)) continue;
            arrayList.add(diagramElement);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        DiagramElement[] diagramElementArray2 = new DiagramElement[arrayList.size()];
        return arrayList.toArray(diagramElementArray2);
    }

    @Override
    public boolean isValidTarget(IStyleMapOwner iStyleMapOwner, String string) {
        return super.isValidTarget(iStyleMapOwner, string) && iStyleMapOwner instanceof LabelPresentation && !TaggedValueUtilities.isTraceabilityMap(((LabelPresentation)iStyleMapOwner).getDiagram());
    }

    @Override
    protected String getDefaultStyle() {
        JFont jFont = JomtFontUtilities.getDefaultJFont();
        return jFont.encode();
    }

    @Override
    public boolean isValidStyle(String string) {
        return string != null && !string.equals("");
    }

    @Override
    protected boolean hasSameStyleValue(IStyleMapOwner iStyleMapOwner, String string, String string2) {
        JFont jFont = StyleSupport.getJFontWithAuto(iStyleMapOwner);
        if (string.equals("font.name")) {
            String string3 = jFont.getFontName();
            return string2 != null && string2.equals(string3);
        }
        if (string.equals("font.style")) {
            String string4 = jFont.getFontStyle();
            return string2 != null && string2.equals(string4);
        }
        if (string.equals("font.size")) {
            int n2 = jFont.getFontSize();
            if (string2 != null) {
                int n3 = 0;
                try {
                    n3 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 0;
                }
                return n3 == n2;
            }
            return false;
        }
        if (string.equals("font.struckthrough")) {
            boolean bl = jFont.isStruckthrough();
            if (string2 != null) {
                String string5 = Boolean.toString(bl);
                return string2.equals(string5);
            }
            return false;
        }
        if (string.equals("font.underlined")) {
            boolean bl = jFont.isUnderlined();
            if (string2 != null) {
                String string6 = Boolean.toString(bl);
                return string2.equals(string6);
            }
            return false;
        }
        return false;
    }

    @Override
    protected String getKeyOfStyle() {
        return "font";
    }

    public void setJFont(JFont jFont) {
        this.a = jFont;
    }

    @Override
    protected Command createCommand(List<DiagramElement> list) {
        EditingDomain editingDomain = ModelGlobal.prjManager.getCurrentProject().doc.getDomain();
        CompoundCommand compoundCommand = new CompoundCommand();
        for (DiagramElement diagramElement : list) {
            compoundCommand.append(SetStyleCommand.create(editingDomain, null, diagramElement, (Object)IItemGraphicalStyleProvider.Feature.FONT, GraphicalStyles.createFontURI(this.a)));
        }
        return compoundCommand.unwrap();
    }
}

