/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import net.astah.golf.control.Command;
import net.astah.golf.draw.GNode;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Presentation;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.CastUtil;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.MultiFeatureVisibilityChooser;
import net.astah.uml2.uml.Classifiers;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Property;

public class SetFeatureVisibilityCommand
extends Command {
    protected Presentation[] presentations = null;

    public void setPresentations(Presentation[] presentationArray) {
        this.presentations = presentationArray;
    }

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            Object object;
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            if (diagramEditor == null) {
                return;
            }
            if (this.presentations == null) {
                object = Arrays.asList(diagramEditor.getSelectedPresentations());
                this.presentations = Iterables.toArray(Iterables.filter(object, Presentation.class), Presentation.class);
            }
            if (this.presentations == null || this.presentations.length == 0) {
                return;
            }
            if (!this.isValidatePs()) {
                return;
            }
            object = (ClassifierPresentation)this.presentations[0];
            List<GNode> list = diagramEditor.getCanvas().getSelectedNodes();
            diagramEditor.getCanvas().unselect();
            try {
                SwingComponent swingComponent = (SwingComponent)JomtGlobal.viewManager.getManagementView().getComponent();
                JFrame jFrame = (JFrame)swingComponent.component;
                MultiFeatureVisibilityChooser multiFeatureVisibilityChooser = this.getChooser(jFrame, (ClassifierPresentation)this.presentations[0]);
                multiFeatureVisibilityChooser.setSize(500, 400);
                multiFeatureVisibilityChooser.setLocationRelativeTo(jFrame);
                multiFeatureVisibilityChooser.setVisible(true);
                if (!multiFeatureVisibilityChooser.isApprove()) {
                    return;
                }
                List<Feature> list2 = this.getNewVisibleFeatures(multiFeatureVisibilityChooser);
                if (!this.hasChangedFeature((ClassifierPresentation)object, list2)) {
                    return;
                }
                iJomtEntityStore.beginTransaction();
                this.setFeatureVisibility((ClassifierPresentation)object, list2);
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
            diagramEditor.getCanvas().select(list);
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected boolean hasChangedAttribute(ClassifierPresentation classifierPresentation, List<Property> list) {
        for (Property object : list) {
            if (classifierPresentation.isFeatureVisible(object)) continue;
            return true;
        }
        Classifier classifier = (Classifier)Classifier.class.cast(classifierPresentation.getModel());
        for (Property property : Classifiers.getAttributesWithoutAssociations(classifier)) {
            if (list.contains(property) || !classifierPresentation.isFeatureVisible(property)) continue;
            return true;
        }
        return false;
    }

    protected MultiFeatureVisibilityChooser getChooser(JFrame jFrame, ClassifierPresentation classifierPresentation) {
        MultiFeatureVisibilityChooser multiFeatureVisibilityChooser = new MultiFeatureVisibilityChooser(jFrame, classifierPresentation);
        multiFeatureVisibilityChooser.setTitle(this.getTitle("ui.dialog.multi_feature_visibility_chooser.title"));
        return multiFeatureVisibilityChooser;
    }

    protected String getTitle(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    protected boolean isValidatePs() {
        return this.presentations[0] instanceof ClassifierPresentation;
    }

    protected boolean hasChangedFeature(ClassifierPresentation classifierPresentation, List<Feature> list) {
        for (Feature feature : list) {
            if (classifierPresentation.isFeatureVisible(feature)) continue;
            return true;
        }
        for (Feature feature : this.a(classifierPresentation)) {
            if (list.contains(feature) || !classifierPresentation.isFeatureVisible(feature)) continue;
            return true;
        }
        return false;
    }

    private List<Feature> a(ClassifierPresentation classifierPresentation) {
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        Classifier classifier = (Classifier)Classifier.class.cast(classifierPresentation.getModel());
        arrayList.addAll(Classifiers.getAttributesWithoutAssociations(classifier));
        arrayList.addAll(classifier.getOperations());
        return arrayList;
    }

    protected List<Feature> getNewVisibleFeatures(MultiFeatureVisibilityChooser multiFeatureVisibilityChooser) {
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        arrayList.addAll((Collection)CastUtil.automaticCast(multiFeatureVisibilityChooser.getAttributeCheckedItems()));
        arrayList.addAll((Collection)CastUtil.automaticCast(multiFeatureVisibilityChooser.getOperationCheckedItems()));
        return arrayList;
    }

    protected void setFeatureVisibility(ClassifierPresentation classifierPresentation, List<Feature> list) {
        classifierPresentation.removeAllInvlisibleFeatures();
        for (Feature feature : this.a(classifierPresentation)) {
            if (list.contains(feature)) continue;
            classifierPresentation.setFeatureVisibility(feature, false);
        }
    }
}

