/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractButton;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.command.SetStyleCommand;
import net.astah.dd.di.edit.provider.IItemGraphicalStyleProvider;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.emf.edit.command.DiagramCommands;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IStyleMapOwner;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.view.GColorChooser;
import net.astah.golf.widget.CColor;
import net.astah.golf.widget.CComponent;
import net.astah.golf.widget.GolfWidgetFactory;
import net.astah.golf.widget.swing.DropDownJButton;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.StyleSupport;
import net.astah.jmodel.TaggedValueUtilities;
import net.astah.jomt.jcontrol.V;
import net.astah.jomt.jcontrol.W;
import net.astah.jomt.jcontrol.X;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jviewElement.JomtViewElement;
import net.astah.notation.GraphicalShape;
import net.astah.notation.editor.GraphicalStyles;
import net.astah.notation.mindmap.MMDiagramElement;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.notation.mindmap.edit.layout.MMStyleSupport;
import net.astah.uml2.operations.NoteAnchorPresentations;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

public class SetColorCommand
extends net.astah.golf.control.Command {
    protected DiagramElement[] presentations;
    protected CColor bodyColor;
    protected CColor[] defaultColorMap = JomtViewElement.DEFAULT_COLOR_MAP;
    protected boolean isLine = false;

    @Override
    public void setArgumentString(String string) {
        if (string != null) {
            Color color = null;
            int n2 = string.indexOf("|");
            if (n2 != -1) {
                this.isLine = true;
                color = GolfUtilities.createColor(string.substring(n2 + 1));
            } else {
                color = GolfUtilities.createColor(string);
            }
            if (color != null) {
                this.bodyColor = GolfWidgetFactory.instance().createCColor(color);
            }
        }
    }

    public void setPresentations(Presentation[] presentationArray) {
        this.presentations = presentationArray;
    }

    public DiagramElement[] getPresentations() {
        return this.presentations;
    }

    public void setBodyColor(CColor cColor) {
        this.bodyColor = cColor;
    }

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            Object object;
            Object object2;
            DiagramEditor diagramEditor = null;
            if (this.presentations == null && JomtGlobal.viewManager != null && (diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor()) != null && !TaggedValueUtilities.isTraceabilityMap(diagramEditor.getDiagram())) {
                this.presentations = diagramEditor.getSelectedPresentations();
            }
            if (this.presentations == null || this.presentations.length == 0) {
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(false);
                }
                return;
            }
            this.removelines();
            if (this.bodyColor == null && JomtGlobal.viewManager != null) {
                Object object3;
                object2 = JomtGlobal.viewManager.getManagementView().getComponent();
                GColorChooser.setParentComponent((CComponent)object2);
                object = null;
                if (this.presentations.length == 1) {
                    Object object4 = object3 = this.isLine ? this.d(this.presentations[0]) : this.c(this.presentations[0]);
                    if (object3 != null) {
                        object = ((CColor)object3).transferToAWTColor();
                    }
                }
                object3 = GColorChooser.getInstance(object, PropertyManager.getProjectViewResourceBundle(), RuntimeGlobal.sysProp);
                ((GColorChooser)object3).show();
                if (((GColorChooser)object3).getResultState() != 1) {
                    return;
                }
                this.bodyColor = ((GColorChooser)object3).getSelectedColor();
                if (this.bodyColor != null && this.event.getSource() instanceof AbstractButton) {
                    AbstractButton abstractButton = (AbstractButton)AbstractButton.class.cast(this.event.getSource());
                    for (ActionListener actionListener : abstractButton.getActionListeners()) {
                        if (!(actionListener instanceof DropDownJButton)) continue;
                        DropDownJButton dropDownJButton = (DropDownJButton)DropDownJButton.class.cast(actionListener);
                        String string = GolfUtilities.getColorString(this.bodyColor);
                        dropDownJButton.setCurrentIcon(string, abstractButton);
                        if (this.isLine) {
                            dropDownJButton.setCurrentActionCommand("SetLineColor%line|" + string);
                            break;
                        }
                        dropDownJButton.setCurrentActionCommand("SetColor%" + string);
                        break;
                    }
                }
            }
            if (this.bodyColor == null) {
                return;
            }
            if (this.presentations.length > 0) {
                this.presentations = NoteAnchorPresentations.setAssociationClassAnchor(this.presentations);
            }
            object2 = this.createCompoundSetStyleCommand(this.presentations);
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                if (object2.canExecute()) {
                    CommandUtils.execute(iJomtEntityStore.getDomain(), (Command)object2);
                }
                object = this.presentations;
                int n2 = ((DiagramElement[])object).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    ActionListener[] actionListenerArray = object[i2];
                    if (actionListenerArray instanceof Presentation) {
                        this.a((DiagramElement)actionListenerArray);
                        continue;
                    }
                    if (!(actionListenerArray instanceof MMDiagramElement)) continue;
                    this.b((DiagramElement)actionListenerArray);
                }
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(false);
                }
                if (JomtGlobal.viewManager != null && (object = JomtGlobal.viewManager.getCurrentDiagramEditor()) != null) {
                    ((DiagramEditor)object).getCanvas().requestFocus();
                    ((DiagramEditor)object).repaintCanvas();
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    private void a(DiagramElement diagramElement) {
        V v2 = new V(this);
        v2.doSwitch(diagramElement);
    }

    private void b(DiagramElement diagramElement) {
        W w2 = new W(this);
        w2.doSwitch(diagramElement);
    }

    private CColor c(DiagramElement diagramElement) {
        if (diagramElement instanceof IStyleMapOwner) {
            return StyleSupport.getBodyColorWithAuto(diagramElement);
        }
        if (diagramElement instanceof MMDiagramElement) {
            return MMStyleSupport.getBodyColorWithAuto(diagramElement);
        }
        return null;
    }

    private CColor d(DiagramElement diagramElement) {
        if (diagramElement instanceof IStyleMapOwner) {
            return StyleSupport.getLineColorWithAuto(diagramElement);
        }
        if (diagramElement instanceof MMDiagramElement) {
            return MMStyleSupport.getLineColorWithAuto(diagramElement);
        }
        return null;
    }

    private boolean a() {
        for (int i2 = 0; i2 < this.presentations.length; ++i2) {
            if (!(this.presentations[i2] instanceof MMTopicShape)) continue;
            return true;
        }
        return false;
    }

    protected void removelines() {
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>(Arrays.asList(this.presentations));
        DiagramElement[] diagramElementArray = this.presentations;
        int n2 = diagramElementArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            X x2 = new X(this);
            DiagramElement diagramElement = diagramElementArray[i2];
            Presentation presentation = (Presentation)x2.doSwitch(diagramElement);
            if (presentation == null) continue;
            arrayList.remove(presentation);
        }
        this.presentations = arrayList.toArray(new DiagramElement[arrayList.size()]);
    }

    protected Object getFeature() {
        return IItemGraphicalStyleProvider.Feature.FILL_COLOR;
    }

    protected Command createCompoundSetStyleCommand(DiagramElement[] diagramElementArray) {
        EditingDomain editingDomain = ModelGlobal.prjManager.getCurrentProject().doc.getDomain();
        CompoundCommand compoundCommand = new CompoundCommand();
        URI uRI = GraphicalStyles.toURI(this.bodyColor);
        ArrayList<DiagramElement> arrayList = Lists.newArrayList(diagramElementArray);
        for (GraphicalShape diagramElement : Iterables.filter(arrayList, GraphicalShape.class)) {
            compoundCommand.append(SetStyleCommand.create(editingDomain, null, diagramElement, this.getFeature(), uRI));
        }
        for (DiagramElement diagramElement : Iterables.filter(arrayList, SetColorCommand::e)) {
            if (!this.isLine) {
                compoundCommand.appendIfCanExecute(this.a(diagramElement, uRI));
                continue;
            }
            compoundCommand.appendIfCanExecute(this.b(diagramElement, uRI));
        }
        return compoundCommand.unwrap();
    }

    private Command a(DiagramElement diagramElement, URI uRI) {
        IItemGraphicalStyleProvider.Feature feature = IItemGraphicalStyleProvider.Feature.FILL_COLOR;
        CommandParameter commandParameter = new CommandParameter((Object)diagramElement, (Object)feature, uRI);
        return DiagramCommands.createDiagramCommand(AdapterFactoryEditingDomain.getEditingDomainFor(diagramElement), SetStyleCommand.class, commandParameter);
    }

    private Command b(DiagramElement diagramElement, URI uRI) {
        IItemGraphicalStyleProvider.Feature feature = IItemGraphicalStyleProvider.Feature.STROKE_COLOR;
        CommandParameter commandParameter = new CommandParameter((Object)diagramElement, (Object)feature, uRI);
        return DiagramCommands.createDiagramCommand(AdapterFactoryEditingDomain.getEditingDomainFor(diagramElement), SetStyleCommand.class, commandParameter);
    }

    private static boolean e(DiagramElement diagramElement) {
        return diagramElement instanceof net.astah.notation.DiagramElement && !(diagramElement instanceof MMDiagramElement);
    }

    static /* synthetic */ boolean a(SetColorCommand setColorCommand) {
        return setColorCommand.a();
    }
}

