/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Project;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;

public class SetBoundTemplateParameterNameVisibilityCommand
extends Command {
    @Override
    public void execute() {
        try {
            Project project = ModelGlobal.prjManager.getCurrentProject();
            IJomtEntityStore iJomtEntityStore = project.doc;
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            Object[] objectArray = diagramEditor.getSelectedModels();
            if (objectArray == null || objectArray.length == 0) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    UserObject userObject = (UserObject)objectArray[i2];
                    Presentation presentation = userObject.getPresentation();
                    if (!(presentation instanceof ClassifierPresentation)) continue;
                    ClassifierPresentation classifierPresentation = (ClassifierPresentation)presentation;
                    boolean bl = this.isShowTemplateParameterName(classifierPresentation);
                    classifierPresentation.setBoundClassTemplateParameterNameVisibility(bl);
                    classifierPresentation.resize();
                }
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected boolean isShowTemplateParameterName(ClassifierPresentation classifierPresentation) {
        return !classifierPresentation.isBoundClassTemplateParameterNameVisibility();
    }
}

