/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.BinaryRelationNameDirectionPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Presentation;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;

public class SetBinaryRelationNameDirectionReverseCommand
extends Command {
    protected Presentation[] presentations = null;

    public void setPresentations(Presentation[] presentationArray) {
        this.presentations = presentationArray;
    }

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            Object object;
            DiagramEditor diagramEditor;
            if (this.presentations == null && (diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor()) != null) {
                object = Arrays.asList(diagramEditor.getSelectedPresentations());
                this.presentations = Iterables.toArray(Iterables.filter(object, Presentation.class), Presentation.class);
            }
            if (this.presentations == null || this.presentations.length == 0) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                for (int i2 = 0; i2 < this.presentations.length; ++i2) {
                    if (!this.isPresentationValid(this.presentations[i2])) continue;
                    object = (BinaryRelationNameDirectionPresentation)((Object)this.presentations[i2]);
                    if (object.getNameDirectionReverse() == 0) {
                        object.setNameDirectionReverse(1);
                        continue;
                    }
                    object.setNameDirectionReverse(0);
                }
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected boolean isPresentationValid(Presentation presentation) {
        return presentation instanceof BinaryRelationNameDirectionPresentation;
    }
}

