/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Iterables;
import java.awt.Point;
import java.util.List;
import net.astah.golf.control.Command;
import net.astah.golf.draw.GNode;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.BinaryRelationPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.NodeUtil;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jviewElement.CJomtTextNode;
import net.astah.uml2.operations.AssociationPresentations;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class SetAssociationRoleCommand
extends Command {
    @Override
    public void execute() {
        try {
            Pnt2d[] pnt2dArray;
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            if (diagramEditor == null) {
                return;
            }
            Object[] objectArray = diagramEditor.getSelectedModels();
            if (objectArray.length != 1) {
                return;
            }
            UserObject userObject = (UserObject)UserObject.class.cast(objectArray[0]);
            BinaryRelationPresentation binaryRelationPresentation = null;
            Association association = null;
            Presentation presentation = userObject.getPresentation();
            if (!(presentation instanceof BinaryRelationPresentation)) {
                return;
            }
            binaryRelationPresentation = (BinaryRelationPresentation)BinaryRelationPresentation.class.cast(presentation);
            EObject eObject = binaryRelationPresentation.getModel();
            if (!(eObject instanceof Association)) {
                return;
            }
            association = (Association)Association.class.cast(eObject);
            NodeUtil.unselectedRelatedTextNode(diagramEditor, binaryRelationPresentation);
            Pnt2d pnt2d = null;
            Point point = this.getPoint();
            if (point != null) {
                pnt2dArray = diagramEditor.getCamera();
                double d2 = pnt2dArray.toWorldCoordX(point.x);
                double d3 = pnt2dArray.toWorldCoordY(point.y);
                pnt2d = new Pnt2d(d2, d3);
            }
            if ((pnt2dArray = binaryRelationPresentation.getOuterPoints().toArray(new Pnt2d[0])) == null || pnt2dArray.length == 0) {
                pnt2dArray = binaryRelationPresentation.getAllPoints().toArray(new Pnt2d[0]);
            }
            Property property = this.getTargetEnd(association, pnt2d, pnt2dArray);
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            String string = this.a(property);
            try {
                iJomtEntityStore.beginTransaction();
                property.setName(string);
                iJomtEntityStore.commitTransaction();
                this.b(property);
                JomtGlobal.viewManager.updatePropertyView(property);
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected Property getTargetEnd(Association association, Pnt2d pnt2d, Pnt2d[] pnt2dArray) {
        Property property = AssociationPresentations.getAssociationEnd(association, pnt2d, pnt2dArray);
        return property;
    }

    private String a(Property property) {
        if (property == null) {
            return "";
        }
        String string = property.getName();
        if (string == null || "".equals(string)) {
            Type type = property.getType();
            if (type == null) {
                return "";
            }
            String string2 = type.getName();
            if (string2 == null || "".equals(string2)) {
                return "";
            }
            char c2 = string2.charAt(0);
            c2 = Character.toLowerCase(c2);
            String string3 = Character.toString(c2);
            return string3.concat(string2.substring(1));
        }
        return string;
    }

    protected Object getObject() {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        Object[] objectArray = diagramEditor.getSelectedModels();
        if (objectArray == null || objectArray.length == 0 || !(objectArray[0] instanceof UserObject)) {
            return null;
        }
        return objectArray[0];
    }

    private void b(Property property) {
        Object object = this.getObject();
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        List<GNode> list = diagramEditor.getCanvas().getAllNodes();
        for (CJomtTextNode cJomtTextNode : Iterables.filter(list, CJomtTextNode.class)) {
            EObject eObject;
            Object object2;
            Object object3;
            if (!cJomtTextNode.and(64) || !cJomtTextNode.isVisible() || cJomtTextNode.getParent() == null || (object3 = cJomtTextNode.getParent().getModel()) != object || (object2 = cJomtTextNode.getModel()) == null || !(object2 instanceof UserObject) || (eObject = ((UserObject)UserObject.class.cast(object2)).getModel()) != property) continue;
            cJomtTextNode.setSelected(true);
            cJomtTextNode.setComponentFocus(true);
            break;
        }
        diagramEditor.repaintCanvas();
    }
}

