/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Rectangle;
import net.astah.dd.dc.Bounds;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.control.Command;
import net.astah.golf.draw.GNode;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.widget.CCanvas;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.edit.layout.DiagramElementOperations;

public class SelectAllCommand
extends Command {
    @Override
    public void execute() {
        try {
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            if (diagramEditor == null) {
                return;
            }
            SelectAllCommand.selectAll(diagramEditor);
            CCanvas cCanvas = diagramEditor.getCanvas();
            cCanvas.draw();
            cCanvas.repaint();
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    public static void selectAll(DiagramEditor diagramEditor) {
        Rectangle2d rectangle2d;
        if (diagramEditor == null) {
            return;
        }
        Diagram diagram = diagramEditor.getDiagram();
        if (!(diagram instanceof UMLDiagram)) {
            Bounds bounds = new LayoutCalculator().getTotalBounds((Iterable<?>)diagram.getOwnedElements(), true);
            rectangle2d = Geometries.toRectangle2d(bounds);
        } else {
            rectangle2d = DiagramElementOperations.getBoundsRect(diagram.getOwnedElements(), true);
        }
        if (rectangle2d.isEmpty()) {
            return;
        }
        int n2 = (int)rectangle2d.getMinX();
        int n3 = (int)rectangle2d.getMinY();
        int n4 = (int)rectangle2d.getWidth();
        int n5 = (int)rectangle2d.getHeight();
        GNode.pickHiddenNode = true;
        diagramEditor.select(new Rectangle(n2, n3, n4, n5), 1);
        GNode.pickHiddenNode = false;
    }
}

