/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import net.astah.golf.control.Command;
import net.astah.golf.control.GolfAction;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.SaveFailedException;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.FileLockManager;
import net.astah.jomt.jview.ManagementView;
import net.astah.jomt.jview.MessageManager;

public class SavePrjCommand
extends Command {
    private boolean a;

    @Override
    public void start() {
        if (this.a) {
            if (GolfUtilities.isMacOS()) {
                super.start();
            } else {
                List<GolfAction> list = this.a();
                this.a(list, false);
                this.a(false);
                super.start();
                this.a(list, true);
                this.a(true);
            }
        } else {
            super.start();
        }
    }

    private List<GolfAction> a() {
        ArrayList<GolfAction> arrayList = new ArrayList<GolfAction>();
        ManagementView managementView = JomtGlobal.viewManager.getManagementView();
        Map<String, Action> map = managementView.getActions().getTable();
        for (Action action : map.values()) {
            if (!action.isEnabled()) continue;
            arrayList.add((GolfAction)action);
        }
        return arrayList;
    }

    private void a(List<GolfAction> list, boolean bl) {
        for (GolfAction golfAction : list) {
            golfAction.setEnabled(bl);
        }
    }

    private void a(boolean bl) {
        ManagementView managementView = JomtGlobal.viewManager.getManagementView();
        managementView.getMenubar().setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        int n2;
        Project project = ModelGlobal.prjManager.getCurrentProject();
        if (project == null) {
            return;
        }
        if (project.isReadOnlyMode()) {
            this.setEndState(1);
            MessageManager.displayErrorMessage("app", "tell_save_fail_due_to_read_only_mode.message");
            return;
        }
        boolean bl = false;
        if (!PropertyManager.getTarget().equals("J")) {
            bl = RuntimeGlobal.sysProp.getBooleanWithDefault("file.lock_project_file");
        }
        if ((n2 = FileLockManager.getInstance().isFileLocked(project.doc.getName(), bl)) == 1 || n2 == 2) {
            this.setEndState(1);
            MessageManager.displayAlertMessageDialog("app", "tell_save_fail_due_to_file_not_writable.message");
            return;
        }
        if (n2 == 3) {
            this.setEndState(1);
            MessageManager.displayAlertMessageDialog("app", "tell_save_fail_due_to_file_locked_other.message");
            return;
        }
        if (!this.a) {
            JomtGlobal.commandSupport.startWaitCursor();
        }
        try {
            block25: {
                try {
                    if (JomtGlobal.viewManager.getManagementView() != null) {
                        project.doc.setParentComponent(JomtGlobal.viewManager.getManagementView().getComponent());
                    }
                    project.doc.setIsProgress(this.a);
                    project.doc.save();
                }
                catch (BadTransactionException badTransactionException) {
                    try {
                        project.doc.abortTransaction();
                        project.doc.save();
                    }
                    catch (SaveFailedException saveFailedException) {
                        this.setEndState(1);
                        MessageManager.displayErrorMessage("app", "tell_save_fail.message");
                    }
                    catch (IOException iOException) {
                        this.setEndState(1);
                        if (!(iOException instanceof InterruptedIOException) || !iOException.getMessage().equals("progress")) {
                            MessageManager.displayErrorMessage("app", "tell_save_fail.message");
                        }
                    }
                }
                catch (SaveFailedException saveFailedException) {
                    this.setEndState(1);
                    MessageManager.displayErrorMessage("app", "tell_save_fail.message");
                }
                catch (IOException iOException) {
                    this.setEndState(1);
                    if (iOException instanceof InterruptedIOException && iOException.getMessage().equals("progress")) break block25;
                    MessageManager.displayErrorMessage("app", "tell_save_fail.message");
                }
            }
            JomtGlobal.commandSupport.updateTitle();
            String string = JomtGlobal.viewManager.getAllDiagramEditorIds();
            ModelGlobal.prjManager.setRecentFileName(project.doc.getName(), string);
        }
        catch (Throwable throwable) {
            this.setEndState(1);
            if (throwable instanceof OutOfMemoryError) {
                MessageManager.displayErrorMessage("app", "out_of_memory.message");
            } else if (throwable instanceof StackOverflowError) {
                MessageManager.displayErrorMessage("app", "stack_overflow_error.message");
            } else {
                MessageManager.requireBugReport(throwable);
            }
        }
        finally {
            if (!this.a) {
                JomtGlobal.commandSupport.endWaitCursor();
            }
        }
    }

    public void setShowProgress(boolean bl) {
        this.a = bl;
    }
}

