/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.filechooser.FileFilter;
import net.astah.golf.control.Command;
import net.astah.golf.control.GolfAction;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.SaveFailedException;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.CMenuBar;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.FileLockManager;
import net.astah.jomt.jutil.JomtFileFilter;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jutil.MacFilenameFilter;
import net.astah.jomt.jutil.PathUtil;
import net.astah.jomt.jview.CommonDialog;
import net.astah.jomt.jview.CommonSaveFileDialogImp;
import net.astah.jomt.jview.ManagementView;
import net.astah.jomt.jview.MessageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveAsPrjCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(SaveAsPrjCommand.class);
    public static final int CANCEL_END = 2;
    private boolean b = true;
    private File c;
    private JomtFileFilter d;
    private String e = "";
    private boolean f;

    public void setFile(File file) {
        this.c = file;
    }

    public void setDoAskOverwrite(boolean bl) {
        this.b = bl;
    }

    @Override
    public void setArgumentString(String string) {
        this.c = new File(string);
    }

    public String getErrMSG() {
        return this.e;
    }

    @Override
    public void start() {
        if (this.f) {
            if (GolfUtilities.isMacOS()) {
                super.start();
            } else {
                List<GolfAction> list = this.a();
                this.a(list, false);
                this.a(false);
                super.start();
                this.a(list, true);
                this.a(true);
            }
        } else {
            super.start();
        }
    }

    private List<GolfAction> a() {
        ArrayList<GolfAction> arrayList = new ArrayList<GolfAction>();
        ManagementView managementView = JomtGlobal.viewManager.getManagementView();
        Map<String, Action> map = managementView.getActions().getTable();
        for (Action action : map.values()) {
            if (!action.isEnabled()) continue;
            arrayList.add((GolfAction)action);
        }
        return arrayList;
    }

    private void a(List<GolfAction> list, boolean bl) {
        for (GolfAction golfAction : list) {
            golfAction.setEnabled(bl);
        }
    }

    private void a(boolean bl) {
        ManagementView managementView = JomtGlobal.viewManager.getManagementView();
        CMenuBar cMenuBar = managementView.getMenubar();
        cMenuBar.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void execute() {
        JomtGlobal.commandSupport.startWaitCursor();
        try {
            var1_1 = JomtGlobal.viewManager.getCurrentEditor();
            if (var1_1 != null) {
                var1_1.stopEditing();
            }
            if ((var2_3 = ModelGlobal.prjManager.getCurrentProject()) == null) {
                return;
            }
            var3_4 = "no_title";
            var2_3.doc.setIsProgress(this.f);
            while (true) lbl-1000:
            // 3 sources

            {
                this.c = this.a(var3_4);
                if (this.c == null) {
                    this.e = "tell_save_fail.message";
                    return;
                }
                try {
                    var2_3.doc.saveAs(this.c.getAbsolutePath());
                    if (this.c.exists()) break;
                    MessageManager.displayAlertMessageDialog("app", "tell_save_fail.message");
                    this.c = null;
                    continue;
                }
                catch (BadTransactionException var4_5) {
                    try {
                        var2_3.doc.abortTransaction();
                        var2_3.doc.saveAs(this.c.getAbsolutePath());
                        if (this.c.exists()) break;
                        MessageManager.displayAlertMessageDialog("app", "tell_save_fail.message");
                        this.c = null;
                        continue;
                    }
                    catch (SaveFailedException var5_9) {
                        var2_3.doc.abortTransaction();
                        MessageManager.displayErrorMessage("app", "tell_save_fail.message");
                        this.e = "tell_save_fail.message";
                        break;
                    }
                    catch (IOException var5_10) {
                        var2_3.doc.abortTransaction();
                        if (var5_10 instanceof InterruptedIOException && var5_10.getMessage().equals("progress")) break;
                        MessageManager.displayErrorMessage("app", "tell_save_fail.message");
                        this.e = "tell_save_fail.message";
                        break;
                    }
                    catch (Exception var5_11) {
                        var2_3.doc.abortTransaction();
                        throw var5_11;
                    }
                }
                ** while (true)
                catch (SaveFailedException var4_6) {
                    MessageManager.displayErrorMessage("app", "tell_save_fail.message");
                    this.e = "tell_save_fail.message";
                    break;
                }
                catch (IOException var4_7) {
                    if (var4_7 instanceof InterruptedIOException && var4_7.getMessage().equals("progress")) break;
                    MessageManager.displayErrorMessage("app", "tell_save_fail.message");
                    this.e = "tell_save_fail.message";
                }
                break;
            }
            JomtGlobal.setFileDir(this.c.getParent());
            JomtGlobal.commandSupport.updateTitle();
            var4_8 = JomtGlobal.viewManager.getAllDiagramEditorIds();
            ModelGlobal.prjManager.setRecentFileName(var2_3.doc.getName(), var4_8);
        }
        catch (Throwable var1_2) {
            this.e = var1_2.getMessage();
            if (var1_2 instanceof OutOfMemoryError) {
                MessageManager.displayErrorMessage("app", "out_of_memory.message");
            } else if (var1_2 instanceof StackOverflowError) {
                MessageManager.displayErrorMessage("app", "stack_overflow_error.message");
            } else {
                MessageManager.requireBugReport(var1_2);
            }
        }
        finally {
            JomtGlobal.commandSupport.endWaitCursor();
        }
    }

    private String a(String string, String string2) {
        if (!Project.isSupportedExtension(string2)) {
            string2 = this.d.getFilters().keySet().contains(Project.FILE_EXTENTION_JUTH.substring(1)) ? string2 + Project.FILE_EXTENTION_JUTH : (string.toLowerCase().endsWith(Project.FILE_EXTENTION) ? string2 + Project.FILE_EXTENTION : (string.toLowerCase().endsWith(Project.FILE_EXTENTION_ASTA) ? string2 + Project.FILE_EXTENTION_ASTA : (a.isDebugEnabled() ? string2 + ".axmp" : string2 + Project.FILE_EXTENTION_ASTA)));
        }
        return string2;
    }

    private File a(String string) {
        int n2;
        int n3;
        Project project;
        File file;
        block12: {
            file = null;
            this.setEndState(0);
            while (true) {
                if (this.c == null) {
                    this.c = this.b(string);
                }
                if (this.c == null) {
                    this.setEndState(2);
                    return null;
                }
                if (this.c.exists() && !this.c.canWrite()) {
                    MessageManager.displayAlertMessageDialog("app", "read_only.message");
                    this.c = null;
                    continue;
                }
                project = ModelGlobal.prjManager.getCurrentProject();
                if (project == null) {
                    return null;
                }
                if (!PathUtil.isLegalFileName(this.c.getName())) {
                    MessageManager.displayErrorMessage("app", "tell_save_fail_illegal_file_name.message");
                    this.e = "tell_save_fail_illegal_file_name.message";
                    this.c = null;
                    this.setEndState(1);
                    return null;
                }
                String string2 = this.a(string, this.c.getAbsolutePath());
                file = new File(GolfUtilities.normalizeToNFC(string2));
                if (file.exists() && !file.canWrite()) {
                    MessageManager.displayAlertMessageDialog("app", "read_only.message");
                    this.c = null;
                    continue;
                }
                if (!this.b || !file.exists() || (n3 = MessageManager.displayMessageYesNoDialog("app", "ask_overwrite_file.message")) == 0) break block12;
                if (n3 != 1) break;
                this.c = null;
            }
            if (n3 == 2) {
                this.setEndState(2);
                return null;
            }
        }
        n3 = 0;
        if (!PropertyManager.getTarget().equals("J")) {
            n3 = RuntimeGlobal.sysProp.getBooleanWithDefault("file.lock_project_file") ? 1 : 0;
        }
        if ((n2 = FileLockManager.getInstance().isFileLocked(file.getAbsolutePath(), n3 != 0)) == 1) {
            this.setEndState(1);
            MessageManager.displayAlertMessageDialog("app", "tell_save_fail_due_to_file_locked.message");
            return null;
        }
        if (n2 == 2) {
            this.setEndState(1);
            MessageManager.displayAlertMessageDialog("app", "tell_save_fail_due_to_file_not_writable.message");
            return null;
        }
        if (n2 == 3) {
            this.setEndState(1);
            MessageManager.displayAlertMessageDialog("app", "tell_save_fail_due_to_file_locked_other.message");
            return null;
        }
        project.setReadOnlyMode(false);
        return file;
    }

    private File b(String string) {
        if (PropertyManager.isMacOS()) {
            Frame frame = (Frame)((SwingComponent)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
            FileDialog fileDialog = new FileDialog(frame);
            fileDialog.setMode(1);
            fileDialog.setFilenameFilter(new MacFilenameFilter());
            fileDialog.setDirectory(JomtGlobal.getFileDir());
            if (string != null && !string.equals("") && !string.equals("no_title")) {
                fileDialog.setFile(string);
            } else {
                fileDialog.setFile(CommonSaveFileDialogImp.getFirstDiagramName());
            }
            fileDialog.setVisible(true);
            if (fileDialog.getFile() == null) {
                return null;
            }
            File file = new File(fileDialog.getDirectory() + fileDialog.getFile());
            CommonDialog commonDialog = JomtWidgetFactory.instance().createCommonSaveFileDialog(string);
            this.d = (JomtFileFilter)((CommonSaveFileDialogImp)commonDialog).getFileChooser().getFileFilter();
            return file;
        }
        CommonDialog commonDialog = JomtWidgetFactory.instance().createCommonSaveFileDialog(string);
        File file = commonDialog.open();
        FileFilter fileFilter = ((CommonSaveFileDialogImp)commonDialog).getFileChooser().getFileFilter();
        if (fileFilter instanceof JomtFileFilter) {
            this.d = (JomtFileFilter)fileFilter;
        }
        return file;
    }

    public void setShowProgress(boolean bl) {
        this.f = bl;
    }
}

