/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.dd.di.DiagramElement;
import net.astah.golf.control.Command;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.jmodel.CombinedFragmentPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.InteractionUsePresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.LifelinePresentation;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResizeObjectCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(ResizeObjectCommand.class);
    protected LifelinePresentation presentation = null;
    protected double width = 0.0;
    protected double height = 0.0;
    protected Pnt2d location = null;
    protected double length = 0.0;

    public void setPresentation(LifelinePresentation lifelinePresentation) {
        this.presentation = lifelinePresentation;
    }

    public void setSize(double d2, double d3) {
        this.width = d2;
        this.height = d3;
    }

    public void setLocation(Pnt2d pnt2d) {
        this.location = pnt2d;
    }

    public void setLifelineLength(double d2) {
        this.length = d2;
    }

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        if (iJomtEntityStore == null) {
            return;
        }
        try {
            Object object;
            Object object2;
            if (this.presentation == null && (object2 = JomtGlobal.viewManager.getCurrentDiagramEditor()) != null) {
                object = ((DiagramEditor)object2).getSelectedPresentations();
                if (object == null || ((DiagramElement[])object).length != 1 || !(object[0] instanceof LifelinePresentation)) {
                    return;
                }
                this.presentation = (LifelinePresentation)object[0];
            }
            if (this.presentation == null) {
                return;
            }
            if (this.width == 0.0 && this.height == 0.0) {
                this.width = this.presentation.getWidth();
                this.height = this.presentation.getHeight();
            }
            if (this.length == 0.0) {
                this.length = this.presentation.getLifelineLength();
            }
            if (this.width < 20.0) {
                return;
            }
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                this.presentation.setWidth(this.width);
                this.presentation.setHeight(Math.max(this.height, this.presentation.getDefaultHeight()));
                if (this.location != null) {
                    this.presentation.setLocation(this.location);
                }
                this.presentation.setLifelineLength(this.length);
                this.presentation.updateTermination();
                this.presentation.movePresentationsOnClassifierRole();
                object2 = this.presentation.getDiagram().getPresentations();
                object = object2.iterator();
                while (object.hasNext()) {
                    Object e2 = object.next();
                    if (!(e2 instanceof CombinedFragmentPresentation) && !(e2 instanceof InteractionUsePresentation)) continue;
                    LabelPresentation labelPresentation = (LabelPresentation)LabelPresentation.class.cast(e2);
                    InteractionFragment interactionFragment = (InteractionFragment)InteractionFragment.class.cast(labelPresentation.getModel());
                    Lifeline lifeline = this.presentation.getClassifierRole();
                    Pnt2d pnt2d = labelPresentation.getLocation();
                    double d2 = this.presentation.getCenterX();
                    if (!(d2 >= pnt2d.x) || !(d2 <= pnt2d.x + labelPresentation.getWidth())) continue;
                    if (this.presentation.getLocation().y <= pnt2d.y + labelPresentation.getHeight() && this.presentation.getLifelineLocY() + this.presentation.getLifelineLength() >= pnt2d.y) {
                        interactionFragment.getCovereds().add(lifeline);
                        continue;
                    }
                    interactionFragment.getCovereds().remove(lifeline);
                }
                this.presentation.moveAllClassifier();
                object = this.presentation;
                object.setDoAutoResize(false);
                if (RuntimeGlobal.sysProp.getBooleanWithDefault("lifeline.self_adjustment")) {
                    object.fitAllLifelineLengthOfMine();
                }
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                a.error("error has occurred", badTransactionException);
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            a.error("error has occurred", exception);
            MessageManager.requireBugReport(exception);
        }
    }
}

